/****************************************************************
 * Copyright (c) 2004, David N. Main, All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the 
 * following conditions are met:
 *
 * 1. Redistributions of source code must retain the above 
 * copyright notice, this list of conditions and the following 
 * disclaimer. 
 * 
 * 2. Redistributions in binary form must reproduce the above 
 * copyright notice, this list of conditions and the following 
 * disclaimer in the documentation and/or other materials 
 * provided with the distribution.
 * 
 * 3. The name of the author may not be used to endorse or 
 * promote products derived from this software without specific 
 * prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY 
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
 * AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************/
 
package org.javaswf.swf.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import com.anotherbigidea.flash.interfaces.SWFTagTypes;

/**
 * Base for all SWF tags.
 * 
 * @author Nick
 */
public abstract class SWFTag {
    
    /** The frame that contains the tag */
    private SWFFrame frame;
    
    private List references;
    
    /** Add a reference to a symbol */
    protected void addReference( SWFSymbol symbol ) {
    	if( references == null ) {
    		references = new ArrayList();
    	}
    	
    	references.add( symbol );
    	symbol.makeReference( this );
    }
    
    /** Get the frame this tag appears in */
    public SWFFrame getFrame() {
        return frame;
    }
    
    /* package */ void setFrame( SWFFrame frame ) {
        this.frame = frame;
    }
    
    /**
     * Write the tag.
     * @param tagOutput the tag output
     */
    public abstract void writeTag( SWFTagTypes tagOutput ) throws IOException;
    
    /** Get the number of references this tag has to SWFSymbols */
    public int referenceCount() {
    	if( references == null ) return 0;
    	return references.size();
    }
    
    /**
     * Get all the symbol references made by this tag.
     */
    public Iterator getSymbolReferences() {
        if( references == null ) {
        	return Collections.EMPTY_LIST.iterator();
        }
        
        return references.iterator();
    }
}
