/****************************************************************
 * Copyright (c) 2004, David N. Main, All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the 
 * following conditions are met:
 *
 * 1. Redistributions of source code must retain the above 
 * copyright notice, this list of conditions and the following 
 * disclaimer. 
 * 
 * 2. Redistributions in binary form must reproduce the above 
 * copyright notice, this list of conditions and the following 
 * disclaimer in the documentation and/or other materials 
 * provided with the distribution.
 * 
 * 3. The name of the author may not be used to endorse or 
 * promote products derived from this software without specific 
 * prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY 
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
 * AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************/
 
package org.javaswf.swf.model.builders;

import java.io.IOException;

import org.javaswf.swf.model.SWFMovieFile;

import com.anotherbigidea.flash.interfaces.SWFFileSignature;

/**
 * SWFTagTypes implementation that builds a SWFMovieFile model.
 * @author Nick
 */
public class SWFModelBuilder extends SWFTimelineBuilder {
    
    private SWFMovieFile movieFile;
    private String signature;
    
    /**
     * @return the movie file being built - null until the SWF header has been
     * received.
     */
    public SWFMovieFile getMovieFile() {
        return movieFile;
    }
    
    /**
     * @see com.anotherbigidea.flash.interfaces.SWFHeader#header(int, long, int, int, int, int)
     */
    public void header( int version, long length, int twipsWidth, int twipsHeight, int frameRate, int frameCount ) throws IOException {
        movieFile = new SWFMovieFile( version, 
                                      frameRate, 
                                      twipsWidth,
                                      twipsHeight,
                                      length,
                                      frameCount, 
                                      SWFFileSignature.SIGNATURE_COMPRESSED.equals( signature ));
        
        super.timeline = movieFile.getTimeline();
    }
    /**
     * @see com.anotherbigidea.flash.interfaces.SWFFileSignature#signature(java.lang.String)
     */
    public void signature( String sig ) {
        signature = sig;
    }
}
