import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.epistem.io.Byte4ByteDebugStreams;

import com.anotherbigidea.flash.interfaces.SWFTags;
import com.anotherbigidea.flash.readers.SWFReader;
import com.anotherbigidea.flash.readers.TagParser;
import com.anotherbigidea.flash.writers.SWFWriter;
import com.anotherbigidea.flash.writers.TagWriter;

/**
 * Read/Write a movie and compare the bytes 
 * @author nmain
 */
public class ReadWriteCompare {
    
    /** 
     * @param args[0] name of movie to compare
     */
    public static void main( String[] args ) throws IOException {
        String filename = args[0];
        
        
        Byte4ByteDebugStreams debug = new Byte4ByteDebugStreams( filename );
        
        List tagCompares = new ArrayList();
        
        SWFWriter   out     = new SWFWriter( debug );
        TagComparer compOut = new TagComparer( out, tagCompares );
        TagWriter   writer  = new TagWriter( compOut );
        TagParser   parser  = new TagParser( writer );
        
        TagComparer compIn  = new TagComparer( parser );
        compIn.tagInfo = tagCompares;
        
        SWFReader reader = new SWFReader( compIn, filename );
        reader.readFile();
        
        System.out.println( "OK" );
    }
    
    
    public static class TagComparer implements SWFTags {
        private SWFTags tags;
        public List tagInfo; //int[] { type, longTag, contentSize }
        public boolean compareMode = false;
        
        TagComparer( SWFTags tags ) {
            this.tags = tags;
        }        

        TagComparer( SWFTags tags, List toCompareAgainst ) {
            this.tags = tags;
            tagInfo = toCompareAgainst;
            compareMode = true;
        }        
        
        public void header( int version, long length, int twipsWidth, int twipsHeight, int frameRate, int frameCount ) throws IOException {
            tags.header( version, length, twipsWidth, twipsHeight, frameRate, frameCount );
        }
        public void tag( int tagType, boolean longTag, byte[] contents ) throws IOException {
            
            if( contents == null ) contents = new byte[0];
            
            if( compareMode ) {
                int[] info = (int[]) tagInfo.remove(0);
                int     prevTagType = info[0];
                boolean prevLongTag = info[1] == 1;
                int     prevSize    = info[2];
                
                if( prevTagType != tagType
               //  || prevLongTag != longTag
                 || prevSize    != contents.length ) {
                    System.out.println( "Mismatch in tag - expected: " +
                            
                            "type=" + prevTagType + " long=" + prevLongTag + " size=" + prevSize + 
                            " but got " +
                            "type=" + tagType + " long=" + longTag + " size=" + contents.length );
                }
                
            } else {            
                tagInfo.add( new int[] { tagType, longTag ? 0 : 1, contents.length } );
            }
            
            tags.tag( tagType, longTag, contents );
        }
    }
}
