/*
 * Copyright 2021 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import { User, DefaultUser, LogoutUserContext } from './Auth';

export interface KeycloakInfo {
  userName: string;
  roles: string[];
  token: string;
  tokenMinValidity: number;
  logout: () => void;
}
export class KeycloakUserContext implements LogoutUserContext {
  private readonly currentUser: User;
  private token: string;
  private readonly tokenMinValidity: number;
  private handleLogout: () => void;
  constructor(keycloakInfo: KeycloakInfo) {
    this.currentUser = new DefaultUser(
      keycloakInfo.userName,
      keycloakInfo.roles
    );
    this.tokenMinValidity = keycloakInfo.tokenMinValidity;
    this.token = keycloakInfo.token;
    this.handleLogout = keycloakInfo.logout;
  }

  logout() {
    this.handleLogout();
  }

  getCurrentUser(): User {
    return this.currentUser;
  }

  getToken(): string {
    return this.token;
  }

  setToken(token: string): void {
    this.token = token;
  }

  getTokenMinValidity(): number {
    return this.tokenMinValidity;
  }
}
