/*
 * Copyright 2021 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.kogito.taskassigning.service;

import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.taskassigning.user.service.User;
import org.kie.kogito.taskassigning.user.service.UserServiceConnector;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;

import static org.assertj.core.api.Assertions.assertThat;
import static org.mockito.Mockito.doReturn;
import static org.mockito.Mockito.verify;

@ExtendWith(MockitoExtension.class)
class UserServiceConnectorDelegateTest {

    private static final String USER_ID = "USER_ID";

    @Mock
    UserServiceConnector userServiceConnector;

    @Mock
    User user;

    @Test
    void findUser() {
        UserServiceConnectorDelegate delegate = new UserServiceConnectorDelegate(userServiceConnector);
        doReturn(user).when(userServiceConnector).findUser(USER_ID);
        User result = delegate.findUser(USER_ID);
        assertThat(result).isSameAs(user);
        verify(userServiceConnector).findUser(USER_ID);
    }
}
