/*
 * Copyright 2020 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kie.kogito.trusty.storage.infinispan.testfield;

import java.io.IOException;
import java.util.function.BiConsumer;
import java.util.function.Function;

import org.infinispan.protostream.MessageMarshaller;

import static org.mockito.ArgumentMatchers.eq;

public class DoubleTestField<M> extends AbstractTestField<M, Double> {

    public DoubleTestField(String fieldName, Double fieldValue, Function<M, Double> getter, BiConsumer<M, Double> setter) {
        super(fieldName, fieldValue, getter, setter);
    }

    @Override
    protected Double callMockReaderMethod(MessageMarshaller.ProtoStreamReader mock) throws IOException {
        return mock.readDouble(eq(fieldName));
    }

    @Override
    protected void callVerifyWriterMethod(MessageMarshaller.ProtoStreamWriter mock) throws IOException {
        mock.writeDouble(eq(fieldName), eq(fieldValue));
    }
}
