/*
 * Copyright 2021 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ruletask;

import java.util.concurrent.atomic.AtomicInteger;

import org.drools.ruleunits.api.DataSource;
import org.drools.ruleunits.api.DataStream;
import org.drools.ruleunits.api.RuleUnitData;
import org.kie.kogito.codegen.data.Person;

public class Example implements RuleUnitData {

    String singleValue;
    DataStream<Person> persons = DataSource.createBufferedStream(16);
    private AtomicInteger counter = new AtomicInteger(0);

    public DataStream<Person> getPersons() {
        return persons;
    }

    public String getSingleValue() {
        return singleValue;
    }

    public void setSingleValue(String singleValue) {
        this.singleValue = singleValue;
    }

    public AtomicInteger getCounter() {
        return counter;
    }

}
