/*
 * Copyright 2021 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import { CustomLabels } from './CustomLabels';
import { DiagramPreviewSize } from '@kogito-apps/process-details/dist/api';

export interface RuntimeToolsDevUIEnvelopeApi {
  runtimeToolsDevUI_initRequest(
    association: Association,
    initArgs: RuntimeToolsDevUIInitArgs
  ): Promise<void>;
}

export interface Association {
  origin: string;
  envelopeServerId: string;
}

export interface User {
  id: string;
  groups: string[];
}

export interface RuntimeToolsDevUIInitArgs {
  users?: User[];
  dataIndexUrl: string;
  trustyServiceUrl?: string;
  page: string;
  devUIUrl: string;
  openApiPath: string;
  isDataIndexAvailable: boolean;
  isTracingEnabled?: boolean;
  availablePages?: string[];
  customLabels: CustomLabels;
  omittedProcessTimelineEvents?: string[];
  diagramPreviewSize?: DiagramPreviewSize;
  isStunnerEnabled: boolean;
}
