/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import { DMN15__tDefinitions } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/ts-gen/types";

export function addMissingImportNamespaces(definitions: DMN15__tDefinitions) {
  if (definitions.import === undefined) {
    return;
  }

  // Collect all declared namespaces
  const definedNamespaces = new Set(
    Object.keys(definitions)
      .filter((keys: keyof DMN15__tDefinitions) => String(keys).startsWith("@_xmlns:"))
      .map((xmlnsKey: keyof DMN15__tDefinitions) => definitions[xmlnsKey])
  );

  // Add missing import namespace declarations as `xmlns:included*`
  let includedIndex = 0;
  for (let index = 0; index < definitions.import.length; index++) {
    const importedModelNamespace = definitions.import[index]["@_namespace"];

    // Check if namespace is already declared
    if (definedNamespaces.has(importedModelNamespace)) {
      // Ignore namespaces that are already declared
      continue;
    }

    // Get next available `included*` namespace declaration name
    while (definitions[`@_xmlns:included${includedIndex}`]) {
      includedIndex++;
    }

    definitions[`@_xmlns:included${includedIndex}`] = importedModelNamespace;
  }
}
