# cors_proxy

![Version: 0.0.0](https://img.shields.io/badge/Version-0.0.0-informational?style=flat-square) ![Type: application](https://img.shields.io/badge/Type-application-informational?style=flat-square) ![AppVersion: 0.0.0](https://img.shields.io/badge/AppVersion-0.0.0-informational?style=flat-square)

A Helm chart to deploy CORS Proxy on Kubernetes

## Values

| Key              | Type   | Default                                                                                                                                                                                                                                         | Description                                                                                                                              |
| ---------------- | ------ | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------- |
| autoscaling      | object | `{"enabled":false,"maxReplicas":100,"minReplicas":1,"targetCPUUtilizationPercentage":80}`                                                                                                                                                       | CORS Proxy HorizontalPodAutoscaler configuration (https://kubernetes.io/docs/tasks/run-application/horizontal-pod-autoscale/)            |
| fullnameOverride | string | `""`                                                                                                                                                                                                                                            | Overrides charts full name                                                                                                               |
| image            | object | `{"account":"kie-tools","name":"cors-proxy-image","pullPolicy":"IfNotPresent","registry":"quay.io","tag":"latest"}`                                                                                                                             | Image source configuration for the CORS Proxy image                                                                                      |
| imagePullSecrets | list   | `[]`                                                                                                                                                                                                                                            | Pull secrets used when pulling CORS Proxy image                                                                                          |
| ingress          | object | `{"annotations":{},"className":"{{ .Values.global.kubernetesIngressClass }}","enabled":false,"hosts":[{"host":"cors-proxy.{{ .Values.global.kubernetesClusterDomain }}","paths":[{"path":"/","pathType":"ImplementationSpecific"}]}],"tls":[]}` | CORS Proxy Ingress configuration (https://kubernetes.io/docs/concepts/services-networking/ingress/)                                      |
| name             | string | `"cors-proxy"`                                                                                                                                                                                                                                  | The CORS Proxy application name                                                                                                          |
| nameOverride     | string | `""`                                                                                                                                                                                                                                            | Overrides charts name                                                                                                                    |
| openshiftRoute   | object | `{"annotations":{},"enabled":false,"host":"cors-proxy.{{ .Values.global.openshiftRouteDomain }}","tls":{"insecureEdgeTerminationPolicy":"None","termination":"edge"}}`                                                                          | CORS Proxy OpenShift Route configuration (https://docs.openshift.com/container-platform/4.14/networking/routes/route-configuration.html) |
| service          | object | `{"nodePort":"","port":8080,"type":"ClusterIP"}`                                                                                                                                                                                                | CORS Proxy Service configuration (https://kubernetes.io/docs/concepts/services-networking/service/)                                      |
| serviceAccount   | object | `{"annotations":{},"create":true,"name":""}`                                                                                                                                                                                                    | CORS Proxy ServiceAccount configuration (https://kubernetes.io/docs/concepts/security/service-accounts/)                                 |

---

Autogenerated from chart metadata using [helm-docs v1.12.0](https://github.com/norwoodj/helm-docs/releases/v1.12.0)
