# extended_services

![Version: 0.0.0](https://img.shields.io/badge/Version-0.0.0-informational?style=flat-square) ![Type: application](https://img.shields.io/badge/Type-application-informational?style=flat-square) ![AppVersion: 0.0.0](https://img.shields.io/badge/AppVersion-0.0.0-informational?style=flat-square)

A Helm chart to deploy Extended Services on Kubernetes

## Values

| Key              | Type   | Default                                                                                                                                                                                                                                                | Description                                                                                                                                     |
| ---------------- | ------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | ----------------------------------------------------------------------------------------------------------------------------------------------- |
| autoscaling      | object | `{"enabled":false,"maxReplicas":100,"minReplicas":1,"targetCPUUtilizationPercentage":80}`                                                                                                                                                              | Extended Services HorizontalPodAutoscaler configuration (https://kubernetes.io/docs/tasks/run-application/horizontal-pod-autoscale/)            |
| fullnameOverride | string | `""`                                                                                                                                                                                                                                                   | Overrides charts full name                                                                                                                      |
| image            | object | `{"account":"kie-tools","name":"kie-sandbox-extended-services-image","pullPolicy":"IfNotPresent","registry":"quay.io","tag":"latest"}`                                                                                                                 | Image source configuration for the Extended Services image                                                                                      |
| imagePullSecrets | list   | `[]`                                                                                                                                                                                                                                                   | Pull secrets used when pulling Extended Services image                                                                                          |
| ingress          | object | `{"annotations":{},"className":"{{ .Values.global.kubernetesIngressClass }}","enabled":false,"hosts":[{"host":"extended-services.{{ .Values.global.kubernetesClusterDomain }}","paths":[{"path":"/","pathType":"ImplementationSpecific"}]}],"tls":[]}` | Extended Services Ingress configuration (https://kubernetes.io/docs/concepts/services-networking/ingress/)                                      |
| name             | string | `"extended-services"`                                                                                                                                                                                                                                  | The Extended Services application name                                                                                                          |
| nameOverride     | string | `""`                                                                                                                                                                                                                                                   | Overrides charts name                                                                                                                           |
| openshiftRoute   | object | `{"annotations":{},"enabled":false,"host":"extended-services.{{ .Values.global.openshiftRouteDomain }}","tls":{"insecureEdgeTerminationPolicy":"None","termination":"edge"}}`                                                                          | Extended Services OpenShift Route configuration (https://docs.openshift.com/container-platform/4.14/networking/routes/route-configuration.html) |
| service          | object | `{"nodePort":"","port":21345,"type":"ClusterIP"}`                                                                                                                                                                                                      | Extended Services Service configuration (https://kubernetes.io/docs/concepts/services-networking/service/)                                      |
| serviceAccount   | object | `{"annotations":{},"create":true,"name":""}`                                                                                                                                                                                                           | Extended Services ServiceAccount configuration (https://kubernetes.io/docs/concepts/security/service-accounts/)                                 |

---

Autogenerated from chart metadata using [helm-docs v1.12.0](https://github.com/norwoodj/helm-docs/releases/v1.12.0)
