/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *  http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License. 
 */


package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties;

import java.util.Set;

import org.eclipse.bpmn2.DataObject;
import org.eclipse.bpmn2.SubProcess;

public class MultipleInstanceSubProcessPropertyWriter extends SubProcessPropertyWriter {

    public MultipleInstanceSubProcessPropertyWriter(SubProcess process, VariableScope variableScope, Set<DataObject> dataObjects) {
        super(process, variableScope, dataObjects);
        setUpLoopCharacteristics();
    }

    @Override
    public void setInput(String name) {
        setInput(name, false);
    }

    @Override
    public void setOutput(String name) {
        setOutput(name, false);
    }
}
