# KIE Tools :: Sparse checkout

Sparse checkout lets you partially clone the KIE Tools monorepo. Doing a sparse checkout will help you save time and disk space, while also reducing the amount of code you need to deal with when developing.

This script will look at `repo/graph.json` to decide what packages need to be downloaded, depending on what packages you specified during your sparse checkout.

Keep in mind that sparse checkouts make Git behave a little differently for some commands. Read more at https://git-scm.com/docs/git-sparse-checkout.

## Usage

- zsh

```
ORG="apache"
BRANCH="main"
PKGS="@kie-tools/boxed-expression-component"
bash <(curl -s https://raw.githubusercontent.com/$ORG/incubator-kie-tools/$BRANCH/scripts/sparse-checkout/run.sh) $ORG $BRANCH ${(z)PKGS}
pnpm -F boxed-expression-component... build:dev
```

---

- bash

```
ORG="apache"
BRANCH="main"
PKGS="@kie-tools/boxed-expression-component"
bash <(curl -s https://raw.githubusercontent.com/$ORG/incubator-kie-tools/$BRANCH/scripts/sparse-checkout/run.sh) $ORG $BRANCH $PKGS
pnpm -F boxed-expression-component... build:dev
```

- Docker

```
docker run -it -p 9900:9900 --rm quay.io/kie-tools/kie-tools-ci-build bash -ic '\
cd; \
ORG="apache"; \
BRANCH="main"; \
PKGS="@kie-tools/boxed-expression-component"; \
bash <(curl -s https://raw.githubusercontent.com/$ORG/incubator-kie-tools/$BRANCH/scripts/sparse-checkout/run.sh) $ORG $BRANCH $PKGS; \
cd incubator-kie-tools; \
pnpm -F boxed-expression-component... build:dev'
```

## Known issues

- `repo/graph.dot` and `repo/graph.json` are not reliably re-generated by `pnpm bootstrap` because not all packages are present. Adding, removing, or renaming packages on partial clones won't work out of the box without a lot of manual intervention.
