/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.acme.travels.service;

import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;

@Path("/flightservice")
public class FlightBookingResource {

    @Inject
    FlightBookingService service;

    @Path("/shouldtimeout")
    @GET
    @Produces(MediaType.APPLICATION_JSON)
    public Boolean getShouldTimeout() {
        return service.getShouldTimeout();
    }

    @Path("/shouldtimeout")
    @PUT
    @Produces(MediaType.APPLICATION_JSON)
    public Boolean toggleTimeout() {
        service.setShouldTimeout(!service.getShouldTimeout());
        return getShouldTimeout();
    }
}
