/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.kie.flyway.springboot;

import java.util.HashMap;
import java.util.Map;

import org.kie.flyway.integration.KieFlywayConfiguration;
import org.kie.flyway.integration.KieFlywayNamedModule;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix = "kie.flyway")
public class KieFlywaySpringbootProperties implements KieFlywayConfiguration<KieFlywaySpringbootProperties.KieFlywaySpringbootNamedModule> {
    private boolean enabled = true;

    private Map<String, KieFlywaySpringbootNamedModule> modules = new HashMap<>();

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Map<String, KieFlywaySpringbootNamedModule> getModules() {
        return modules;
    }

    public void setModules(Map<String, KieFlywaySpringbootNamedModule> modules) {
        this.modules = modules;
    }

    public static class KieFlywaySpringbootNamedModule implements KieFlywayNamedModule {

        private boolean enabled = true;

        public boolean isEnabled() {
            return enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}
