/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.server.handlers.pages;

import com.google.gson.Gson;
import com.google.inject.Inject;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.FileSource;
import com.google.jstestdriver.hooks.FileInfoScheme;
import com.google.jstestdriver.model.HandlerPathPrefix;
import com.google.jstestdriver.model.JstdTestCase;
import com.google.jstestdriver.server.JstdTestCaseStore;
import com.google.jstestdriver.util.HtmlWriter;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestFileUtil {
    private static final Logger logger = LoggerFactory.getLogger(TestFileUtil.class);
    private final HandlerPathPrefix prefix;
    private final Set<FileInfoScheme> schemes;
    private final Gson gson;
    private final JstdTestCaseStore store;

    @Inject
    TestFileUtil(JstdTestCaseStore store, HandlerPathPrefix prefix, Set<FileInfoScheme> schemes, Gson gson) {
        this.store = store;
        this.prefix = prefix;
        this.schemes = schemes;
        this.gson = gson;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void writeTestFiles(HtmlWriter writer, String testCaseId) {
        JstdTestCase testCase;
        if (this.store.getCase(testCaseId) == null) {
            if (this.store.getCases().size() != 1) {
                logger.debug("More than one testcase found:\n{}", this.store.getCases());
                return;
            }
            testCase = this.store.getCases().iterator().next();
            logger.debug("One test case found, writing: {}", testCase);
        } else {
            testCase = this.store.getCase(testCaseId);
            logger.debug("Testcase found at id {}: {}", (Object)testCaseId, (Object)testCase);
        }
        logger.info("preloading {}", (Object)testCase.getId());
        Iterator<FileInfo> i$ = testCase.iterator();
        while (i$.hasNext()) {
            FileInfo file = i$.next();
            if (file.isServeOnly()) continue;
            FileSource fileSource = file.toFileSource(this.prefix, this.schemes);
            if (!fileSource.getFileSrc().startsWith("http") && !fileSource.getFileSrc().startsWith("/test")) {
                logger.debug("Unknown FileSource [{}], bail out on writing", (Object)fileSource.getFileSrc());
                return;
            }
            logger.debug("Writing " + fileSource.getFileSrc());
            writer.writeScript(String.format("jstestdriver.manualResourceTracker.startResourceLoad('%s')", this.gson.toJson(fileSource).replace(Pattern.quote("\\"), "\\\\")));
            if (fileSource.getFileSrc().endsWith(".css")) {
                writer.writeStyleSheet(fileSource.getFileSrc());
            } else {
                writer.writeExternalScript(fileSource.getFileSrc());
            }
            writer.writeScript("jstestdriver.manualResourceTracker.finishResourceLoad()");
        }
    }
}

