/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.browser;

import com.google.jstestdriver.ProcessFactory;
import com.google.jstestdriver.browser.BrowserRunner;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandLineBrowserRunner
implements BrowserRunner {
    private static final Logger logger = LoggerFactory.getLogger(CommandLineBrowserRunner.class);
    private final String browserPath;
    private final String browserArgs;
    private final ProcessFactory processFactory;
    private Process process;

    public CommandLineBrowserRunner(String browserPath, String browserArgs, ProcessFactory processFactory) {
        this.browserPath = browserPath;
        this.processFactory = processFactory;
        this.browserArgs = browserArgs;
    }

    public void startBrowser(String serverAddress) {
        try {
            String processArgs = "";
            if (this.browserArgs.contains("%s")) {
                processArgs = this.browserArgs.replace("%s", serverAddress);
            } else {
                if (this.browserArgs.length() > 0) {
                    processArgs = this.browserArgs + " ";
                }
                processArgs = processArgs + serverAddress;
            }
            String[] args = processArgs.split(" ");
            String[] finalArgs = new String[args.length + 1];
            finalArgs[0] = this.browserPath;
            System.arraycopy(args, 0, finalArgs, 1, args.length);
            this.process = this.processFactory.start(finalArgs);
        }
        catch (IOException e) {
            logger.error("Could not start: {} because {}", (Object)this.browserPath, (Object)e.toString());
            throw new RuntimeException(e);
        }
    }

    public void stopBrowser() {
        try {
            this.process.destroy();
            if (this.process.exitValue() != 0) {
                logger.warn("Unexpected shutdown " + this.process + " " + this.process.exitValue());
            }
        }
        catch (IllegalThreadStateException e) {
            logger.warn("Process refused to exit [" + this.browserPath + " ]: " + this.process);
        }
    }

    public int getTimeout() {
        return 30;
    }

    public int getNumStartupTries() {
        return 3;
    }

    public long getHeartbeatTimeout() {
        return 30000L;
    }

    public int getUploadSize() {
        return 50;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.browserPath == null ? 0 : this.browserPath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommandLineBrowserRunner)) {
            return false;
        }
        CommandLineBrowserRunner other = (CommandLineBrowserRunner)obj;
        return (this.browserPath == null && other.browserPath == null || this.browserPath.equals(other.browserPath)) && (this.browserArgs == null && other.browserArgs == null || this.browserArgs.equals(other.browserArgs));
    }

    public String toString() {
        return "CommandLineBrowserRunner [\nbrowserPath=" + this.browserPath + "\nargs=" + this.browserArgs + ",\nprocess=" + this.process + ",\n process log={\n" + this.getLog() + "\n}]";
    }

    private String getLog() {
        StringBuilder log = new StringBuilder("error:\n");
        if (this.process == null) {
            return "no process log";
        }
        InputStream errorStream = this.process.getErrorStream();
        InputStream outputStream = this.process.getInputStream();
        byte[] buffer = new byte[512];
        try {
            while (errorStream.available() > 0) {
                errorStream.read(buffer);
                log.append(buffer);
            }
        }
        catch (IOException e) {
            log.append("io exception reading error");
        }
        log.append("\ninput:\n");
        try {
            while (outputStream.available() > 0) {
                outputStream.read(buffer);
                log.append(buffer);
            }
        }
        catch (IOException e) {
            log.append("io exception reading input");
        }
        return log.toString();
    }
}

