/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.server.handlers;

import com.google.gson.Gson;
import com.google.inject.Inject;
import com.google.jstestdriver.FileResult;
import com.google.jstestdriver.JsonCommand;
import com.google.jstestdriver.LoadedFiles;
import com.google.jstestdriver.Response;
import com.google.jstestdriver.SlaveBrowser;
import com.google.jstestdriver.SlaveResourceService;
import com.google.jstestdriver.StreamMessage;
import com.google.jstestdriver.TestResult;
import com.google.jstestdriver.TestResultGenerator;
import com.google.jstestdriver.model.HandlerPathPrefix;
import com.google.jstestdriver.requesthandlers.RequestHandler;
import com.google.jstestdriver.runner.RunnerType;
import com.google.jstestdriver.server.handlers.pages.Page;
import com.google.jstestdriver.server.handlers.pages.PageType;
import com.google.jstestdriver.server.handlers.pages.SlavePageRequest;
import com.google.jstestdriver.util.HtmlWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StandaloneRunnerHandler
implements RequestHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandaloneRunnerHandler.class);
    private final Gson gson = new Gson();
    private final SlavePageRequest request;
    private final HttpServletResponse response;
    private final ConcurrentMap<SlaveBrowser, Thread> reportingThreads;
    private final TestResultGenerator testResultGenerator = new TestResultGenerator();
    private final Map<PageType, Page> pages;
    private final HandlerPathPrefix prefix;

    @Inject
    public StandaloneRunnerHandler(SlavePageRequest request, HttpServletResponse response, SlaveResourceService service, ConcurrentMap<SlaveBrowser, Thread> reportingThreads, Map<PageType, Page> pages, HandlerPathPrefix prefix) {
        this.request = request;
        this.response = response;
        this.reportingThreads = reportingThreads;
        this.pages = pages;
        this.prefix = prefix;
    }

    @Override
    public void handleIt() throws IOException {
        SlaveBrowser browser = this.request.getBrowser();
        if (browser == null) {
            LOGGER.warn("Invalid ID in: {}", this.request);
            this.response.sendRedirect("/capture/rt/" + RunnerType.STANDALONE.toString() + "/timeout/3600000");
        } else {
            browser.heartBeat();
            this.response.setContentType("text/html; charset=utf-8");
            HtmlWriter writer = new HtmlWriter(this.response.getWriter(), this.prefix);
            this.request.writeDTD(writer);
            this.pages.get((Object)this.request.getPageType()).render(writer, this.request);
            this.service(browser);
        }
    }

    public void service(final SlaveBrowser slaveBrowser) {
        LinkedList<String> runAllTestsParameters = new LinkedList<String>();
        runAllTestsParameters.add("false");
        runAllTestsParameters.add("false");
        runAllTestsParameters.add("0");
        slaveBrowser.createCommand(this.gson.toJson(new JsonCommand(JsonCommand.CommandType.RUNALLTESTS, runAllTestsParameters)));
        if (LOGGER.isDebugEnabled() && !this.reportingThreads.containsKey(slaveBrowser)) {
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    String runnerId = slaveBrowser.getBrowserInfo().toUniqueString();
                    long testStart = System.currentTimeMillis();
                    int loaded = 0;
                    block5: while (true) {
                        StreamMessage message;
                        if ((message = slaveBrowser.getResponse()) == null) {
                            continue;
                        }
                        Response response = message.getResponse();
                        response.setBrowser(slaveBrowser.getBrowserInfo());
                        switch (response.getResponseType()) {
                            case TEST_RESULT: {
                                Collection<TestResult> testResults = StandaloneRunnerHandler.this.testResultGenerator.getTestResults(response);
                                boolean failed = false;
                                for (TestResult result : testResults) {
                                    if (result.getResult() != TestResult.Result.passed) {
                                        failed = true;
                                        LOGGER.trace("{}: {} {}.{}: \n{}", new Object[]{runnerId, result.getResult(), result.getTestCaseName(), result.getTestName(), result.getMessage()});
                                        continue;
                                    }
                                    LOGGER.trace("{}: passed {}{}", new Object[]{runnerId, result.getTestCaseName(), result.getTestName()});
                                }
                                LOGGER.debug("{}: result {} {}s", new Object[]{runnerId, !failed, (System.currentTimeMillis() - testStart) / 1000L});
                                break;
                            }
                            case FILE_LOAD_RESULT: {
                                LoadedFiles files = (LoadedFiles)StandaloneRunnerHandler.this.gson.fromJson(response.getResponse(), response.getGsonType());
                                Iterator<FileResult> i$ = files.getLoadedFiles().iterator();
                                while (true) {
                                    if (!i$.hasNext()) continue block5;
                                    FileResult result = i$.next();
                                    if (result.isSuccess()) {
                                        ++loaded;
                                        continue;
                                    }
                                    LOGGER.debug("{}: failed to load {}", new Object[]{runnerId, result.getFileSource().getFileSrc()});
                                }
                            }
                            case LOG: {
                                LOGGER.debug("{}: test time {}s {}", new Object[]{runnerId, (System.currentTimeMillis() - testStart) / 1000L, response.getResponse()});
                            }
                        }
                    }
                }
            });
            this.reportingThreads.put(slaveBrowser, thread);
            thread.setDaemon(true);
            thread.start();
        }
    }
}

