## Backbone.Modal

A plugin for Backbone.js that simplifies creating modals for your application.

Backbone.Modal.js removes boilerplate code and adds default behaviors and interactions. You can create a simple dialog modal or complex wizards with stacked modals on top of each other in a few lines of code.

For a complete overview of the documentation visit: [http://awkward.github.io/backbone.modal/](http://awkward.github.io/backbone.modal/)

#### Bundled version
If you're using Backbone and Marionette.
* [backbone.modal-bundled-min.js](https://raw.github.com/awkward/backbone.modal/master/backbone.modal-bundled-min.js)

#### Backbone.Modals.js and Backbone.Marionette.Modals.js separate
If you just want to use the Backbone version without Marionette.
* [backbone.modal-min.js](https://raw.github.com/awkward/backbone.modal/master/backbone.modal-min.js)
* [backbone.marionette.modals-min.js](https://raw.github.com/awkward/backbone.modal/master/backbone.marionette.modals-min.js)

#### CSS files
There's default style, and you can use our theme to make things look pretty.
* [backbone.modal.css](https://raw.github.com/awkward/backbone.modal/master/backbone.modal.css)
* [backbone.modal.theme.css](https://raw.github.com/awkward/backbone.modal/master/backbone.modal.theme.css)

### How to contribute

To get started `grunt install` to install all dependencies. If you have any requests, please create an issue. If you're working on something yourself, make a pull request and we'll make sure to check it out to get in into the next release.

### Tests

When you run the project by doing `grunt watch`. This will watch the tests, src and example files. It will open up a browser with the tests on `http://localhost:8000`. When you head over `http://localhost:5000`, it will show the example that's defined in the `Gruntfile.coffee`.

### Legal stuff (MIT License)

Copyright (c) 2013 Awkward.

Distributed under MIT license.
