ceph-ansible stable-3.2 release note
====================================

323 files changed, 6659 insertions(+), 14919 deletions(-)

Ansible version support
-----------------------

This version supports Ansible 2.6 exclusively.

Ceph version support
--------------------

This version can deploy any version of Ceph starting from Luminous to Mimic.
Note that the general intent for Ceph Ansible is to support two Ceph releases only.
The next version will support Nautilus and Octopus, then the one after that will support P and Q Ceph releases.

Removed features
----------------

* remove Jewel support - [#3216](https://github.com/ceph/ceph-ansible/pull/3216)
* remove check_firewall code - [#3198](https://github.com/ceph/ceph-ansible/pull/3198)
* Remove Calamari-related pieces - [#3147](https://github.com/ceph/ceph-ansible/pull/3147)

Deprecation warnings and incoming removal
-----------------------------------------

* `ceph-rest-api` will go away in the next stable release
* ceph cluster name support will go away, but existing deployments will continue to work
* remove ceph-common-coreos role in the next release
* removal of `KV_*` options, which were refering to a container deployment involving ETCD
* removal of `pool_default_pg_num`, we don't lookup the default value form the monitors, we just assume the default is the same as Ceph
* ceph-disk based deployments will not be supported anymore, which means osd scenarios 'collocated' and 'non-collocated' will continue to work for existing OSDs but new deployments will not be possible
* the next stable release will collocated monitor and managers on the same node by default, this will speed up deployments in general. Also manager are intended to run along side the monitor. This means declaring a `[mgrs]` won't be needed anymore
* the next stable release will not enable any manager module, they will need to be explicitly declared via `ceph_mgr_modules`
* the group name 'iscsi-gws' will go away in the next stable release
* the rgw systemd service names in the following list won't be managed anymore in the next stable release: `ceph-rgw@<hostname>.service`, `ceph-radosgw@<hostname>.service`, `ceph-radosgw@radosgw.<hostname>.service`, `ceph-radosgw@radosgw.gateway.service`

About ceph-disk transition to ceph-volume for containers ONLY
-------------------------------------------------------------

**This section is only useful if your cluster is containerized.**

As mentionned earlier, the next release of ceph-ansible will only support Nautilus and above.
In Nautilus, ceph-disk is gone completely. So we have to have a transition for ceph-disk OSDs to ceph-volume.
That will be implemented during the next cycle.

However, with 3.2 people might start looking for deploying OSDs with ceph-volume starting from Luminous 12.2.10 (available since Nov 2018) and Mimic 13.2.3 (not available at the time of writting).
For more Ceph release info see the [schecule](http://docs.ceph.com/docs/master/releases/schedule/).

/!\ Current limitation to that transition, **it can only be managed by hosts, not by disk**. /!\

So users will have to decouple hosts running OSDs on ceph-disks and ceph-volume.
For this we are going to use 'groups of groups' in the ansible inventory.

Example:

Let's assume you used to have this inventory on an existing cluster:

```text
[osds]
ceph-osd-node-01 osd_scenario='collocated' devices="['/dev/disk/by-path/pci-0000:00:01.1-ata-1.0', '/dev/sdb']"
ceph-osd-node-02 osd_scenario='non-collocated' devices="['/dev/disk/by-path/pci-0000:00:01.1-ata-1.0', '/dev/sdb']" dedicated_devices="['/dev/sdc', '/dev/sdc']"
ceph-osd-node-03 osd_scenario='non-collocated' devices="['/dev/disk/by-path/pci-0000:00:01.1-ata-1.0', '/dev/sdb']" dedicated_devices="['/dev/sdc', '/dev/sdc']" dmcrypt=True
```

NOTE: Everything is defined at the inventory level but it could have been defined at group_vars level in osds.yml.
The three OSD nodes described above were deployed using `ceph-disk`.

If you desire to add new OSDs, you need to split all OSDs into two separate groups so everything is simplier.

Example:

```text
$ cat hosts
[osds:children]
osds-legacy
osds-lvm

[osds-legacy]
ceph-osd-node-01 osd_scenario='collocated' devices="['/dev/disk/by-path/pci-0000:00:01.1-ata-1.0', '/dev/sdb']"
ceph-osd-node-02
ceph-osd-node-03 dmcrypt=True

[osds-lvm]
ceph-osd-node-04 lvm_volumes={ "lvm_volumes": [ { "data": "data-lv1", "data_vg": "test_group" }, { "data": "data-lv2", "data_vg": "test_group", "db": "journal1", "db_vg": "journals" } ] }
ceph-osd-node-05 dedicated_devices="['/dev/sdc', '/dev/sdc']"
```

Defining values according to the new form of the inventory:

```text
$ cat group_vars/osds-legacy.yml
---
osd_scenario: non-collocated
devices: ['/dev/disk/by-path/pci-0000:00:01.1-ata-1.0', '/dev/sdb']
dedicated_devices: ['/dev/sdc', '/dev/sdc']
```

```text
$ cat group_vars/osds-lvm.yml
---
osd_scenario: lvm
devices: ['/dev/disk/by-path/pci-0000:00:01.1-ata-1.0', '/dev/sdb']
```

What happened here?

    * We moved the three existing OSD node to a new group `osds-legacy`
    * The existing `[osds]` became a group (`[osds:children]`) of groups `[osds-legacy],[osds-lvm]`
    * We added the new OSD nodes into a new group `[osds-lvm]`

This means we can avoid defining everything at inventory level.
For instance, it's pretty useful if all or most of your already existing OSDs share the same `osd_scenario` and/or same `devices` list.
Indeed, you can define a 'default' value for `osd_scenario`, `devices`, `dedicated_devices` in `group_vars/osds-legacy.yml` and then manage with the few nodes that would differ if so.
The same principe can be adopted for `osds-lvm` in `group_vars\osds-lvm.yml`.
Finally, anything set in `group_vars\osds.yml` would be shared across all OSD nodes.

Major changes from stable-3.1
-----------------------------

* Better support for python 3 in our modules
* allow custom pool size - [#3145](https://github.com/ceph/ceph-ansible/pull/3145)
* infra: add a gather-ceph-logs.yml playbook - [#2641](https://github.com/ceph/ceph-ansible/pull/2641)
* day 2 playbook: add-osds - [#3175](https://github.com/ceph/ceph-ansible/pull/3175)
* ceph-osd: ceph-volume container support - [#2866](https://github.com/ceph/ceph-ansible/pull/2866)
* add ceph-infra role - [#3201](https://github.com/ceph/ceph-ansible/pull/3201)
* ceph-volume: makes the lvm scenario idempotent when using the simple configuration - [#3190](https://github.com/ceph/ceph-ansible/pull/3190)
* Add support for different NTP daemons - [#3099](https://github.com/ceph/ceph-ansible/pull/3099)
* purge-cluster: zap devices used with the lvm scenario - [#3157](https://github.com/ceph/ceph-ansible/pull/3157)
* default: use bluestore as default object store - [#3172](https://github.com/ceph/ceph-ansible/pull/3172)
* set osd max memory based on host memory - [#3113](https://github.com/ceph/ceph-ansible/pull/3113)
* shrink-osd: purge dedicated devices - [#3145](https://github.com/ceph/ceph-ansible/pull/3145)
* ceph-volume: adds support for the 'lvm batch' command - [#2980](https://github.com/ceph/ceph-ansible/pull/2980)
* site: report ceph -s status at the end of the deployment - [#2936](https://github.com/ceph/ceph-ansible/pull/2936)
* validate: add checks for interfaces - [#2915](https://github.com/ceph/ceph-ansible/pull/2915)
* Generate a copy of ceph.conf locally - [#2700](https://github.com/ceph/ceph-ansible/pull/2700)
* Add support for containerized iscsi deployment - [#2466](https://github.com/ceph/ceph-ansible/pull/2466)
* ceph-common: add firewall rules for ceph-mgr - [#2686](https://github.com/ceph/ceph-ansible/pull/2686)
* Create rgw pools containerized - [#2424](https://github.com/ceph/ceph-ansible/pull/2424)
* rgw: container add option to configure multi-site zone - [#2525](https://github.com/ceph/ceph-ansible/pull/2525)
* Config validation action plugin - [#2555](https://github.com/ceph/ceph-ansible/pull/2555)
* mon: refactor of mgr key fetching - [#2589](https://github.com/ceph/ceph-ansible/pull/2589)
* roles: do not limit docker_memory_limit for various daemons - [#3263](https://github.com/ceph/ceph-ansible/pull/3263)
* Rm ceph disk scenarios - [#3262](https://github.com/ceph/ceph-ansible/pull/3262)
* ceph_volume: add container support for batch - [#3269](https://github.com/ceph/ceph-ansible/pull/3269)
* rgw: enable multisite functionality - [#1944](https://github.com/ceph/ceph-ansible/pull/1944)

Notable changes from stable-3.1
-------------------------------

* [3764e52c](https://github.com/ceph/ceph-ansible/commit/3764e52c) - tests: reintroduce purge_cluster scenario (Guillaume Abrioux)
* [408597f2](https://github.com/ceph/ceph-ansible/commit/408597f2) - tests: add purge_lvm_osds_container scenario (Guillaume Abrioux)
* [e37a90b5](https://github.com/ceph/ceph-ansible/commit/e37a90b5) - purge: add iscsi support (Guillaume Abrioux)
* [c3a2320e](https://github.com/ceph/ceph-ansible/commit/c3a2320e) - revert infra: don't restart firewalld if unit is masked (Guillaume Abrioux)
* [0ec2ac34](https://github.com/ceph/ceph-ansible/commit/0ec2ac34) - rolling_update: fail if less than 3 MONs (Ramana Raja)
* [50fe5604](https://github.com/ceph/ceph-ansible/commit/50fe5604) - disable nfs scenario (Sébastien Han)
* [fa8bd10c](https://github.com/ceph/ceph-ansible/commit/fa8bd10c) - test: disable nfs for containers (Sébastien Han)
* [8d1c67be](https://github.com/ceph/ceph-ansible/commit/8d1c67be) - osd: discover osd_objectstore on the fly (Sébastien Han)
* [11515217](https://github.com/ceph/ceph-ansible/commit/11515217) - ceph-osd: change jinja condition (Sébastien Han)
* [729744c6](https://github.com/ceph/ceph-ansible/commit/729744c6) - rolling_update: do not fail on missing keys (Sébastien Han)
* [e8b10f47](https://github.com/ceph/ceph-ansible/commit/e8b10f47) - rgw: use correct default rgw frontend address (Noah Watkins)
* [788723cc](https://github.com/ceph/ceph-ansible/commit/788723cc) - tox.ini: setup LVs in OSD hosts for '*-cluster' scenarios (Ramana Raja)
* [452069cb](https://github.com/ceph/ceph-ansible/commit/452069cb) - osd: manage legacy ceph-disk non-container startup (Sébastien Han)
* [8d93007e](https://github.com/ceph/ceph-ansible/commit/8d93007e) - config: write jinja comment with appropriate syntax (Guillaume Abrioux)
* [2cea33f7](https://github.com/ceph/ceph-ansible/commit/2cea33f7) - rolling_update: default ceph json output to empty dict (Sébastien Han)
* [316e49c6](https://github.com/ceph/ceph-ansible/commit/316e49c6) - client: change default pool size (Guillaume Abrioux)
* [1077ae00](https://github.com/ceph/ceph-ansible/commit/1077ae00) - defaults: change default size for openstack pools (Guillaume Abrioux)
* [a4db9bd6](https://github.com/ceph/ceph-ansible/commit/a4db9bd6) - defaults: change for default pool size for cephfs_pools (Guillaume Abrioux)
* [65699e45](https://github.com/ceph/ceph-ansible/commit/65699e45) - defaults: add ceph related vars file (Guillaume Abrioux)
* [f0195e97](https://github.com/ceph/ceph-ansible/commit/f0195e97) - refact osd pool size customization (Guillaume Abrioux)
* [68b2ad11](https://github.com/ceph/ceph-ansible/commit/68b2ad11) - mon: move `osd_pool_default_pg_num` in `ceph-defaults` (Guillaume Abrioux)
* [e8dd6b89](https://github.com/ceph/ceph-ansible/commit/e8dd6b89) - tests: change default pools size (Guillaume Abrioux)
* [292d967d](https://github.com/ceph/ceph-ansible/commit/292d967d) - update: fix a typo (Guillaume Abrioux)
* [30cec03a](https://github.com/ceph/ceph-ansible/commit/30cec03a) - tests: do not fully override previous ceph_conf_overrides (Guillaume Abrioux)
* [1f4cf610](https://github.com/ceph/ceph-ansible/commit/1f4cf610) - rolling_update: refact set_fact `mon_host` (Guillaume Abrioux)
* [d4f1f12b](https://github.com/ceph/ceph-ansible/commit/d4f1f12b) - rolling_update: create rbd and rbd-mirror keyrings (Sébastien Han)
* [ee964549](https://github.com/ceph/ceph-ansible/commit/ee964549) - ceph_key: add a get_key function (Sébastien Han)
* [26ea9642](https://github.com/ceph/ceph-ansible/commit/26ea9642) - switch: do not look for devices anymore (Sébastien Han)
* [57ac7b94](https://github.com/ceph/ceph-ansible/commit/57ac7b94) - switch: disable all ceph units (Sébastien Han)
* [8d0379b4](https://github.com/ceph/ceph-ansible/commit/8d0379b4) - switch: do not mask systemd unit (Sébastien Han)
* [9b5a93e3](https://github.com/ceph/ceph-ansible/commit/9b5a93e3) - osd: re-introduce disk_list check (Sébastien Han)
* [659f2c60](https://github.com/ceph/ceph-ansible/commit/659f2c60) - validate: change default value for `radosgw_address` (Guillaume Abrioux)
* [968e6f58](https://github.com/ceph/ceph-ansible/commit/968e6f58) - tests: rgw_multisite allow clusters to talk to each other (Guillaume Abrioux)
* [13361547](https://github.com/ceph/ceph-ansible/commit/13361547) - tests: set pool size to 1 in ceph-override.json (Guillaume Abrioux)
* [4cc15063](https://github.com/ceph/ceph-ansible/commit/4cc15063) - osd: commonize start_osd code (Guillaume Abrioux)
* [b72d806f](https://github.com/ceph/ceph-ansible/commit/b72d806f) - mgr: fix mgr keyring error on rolling_update (Guillaume Abrioux)
* [3ead8a25](https://github.com/ceph/ceph-ansible/commit/3ead8a25) - tests: apply dev_setup on the secondary cluster for rgw_multisite (Guillaume Abrioux)
* [2fca8555](https://github.com/ceph/ceph-ansible/commit/2fca8555) - handler: show unit logs on error (Sébastien Han)
* [59524c72](https://github.com/ceph/ceph-ansible/commit/59524c72) - ceph-volume: be idempotent when the batch strategy changes (Andrew Schoen)
* [1a1886a4](https://github.com/ceph/ceph-ansible/commit/1a1886a4) - config: convert _osd_memory_target to int (Guillaume Abrioux)
* [abdc245c](https://github.com/ceph/ceph-ansible/commit/abdc245c) - infra: don't restart firewalld if unit is masked (Guillaume Abrioux)
* [c96af4ba](https://github.com/ceph/ceph-ansible/commit/c96af4ba) - osd_memory_target: standardize unit and fix calculation (Neha Ojha)
* [f5d8701e](https://github.com/ceph/ceph-ansible/commit/f5d8701e) - client: fix a typo in create_users_keys.yml (Guillaume Abrioux)
* [62d2ddaf](https://github.com/ceph/ceph-ansible/commit/62d2ddaf) - validate: allow stable-3.2 to run with ansible 2.4 (Guillaume Abrioux)
* [3b40e2bc](https://github.com/ceph/ceph-ansible/commit/3b40e2bc) - igw: add support for IPv6 (Jason Dillaman)
* [702f2bac](https://github.com/ceph/ceph-ansible/commit/702f2bac) - igw: open iscsi target port (Mike Christie)
* [44ee5c74](https://github.com/ceph/ceph-ansible/commit/44ee5c74) - igw: use api_port variable for firewall port setting (Mike Christie)
* [db576f6f](https://github.com/ceph/ceph-ansible/commit/db576f6f) - igw: fix firewall iscsi_group_name check (Mike Christie)
* [c843ea1d](https://github.com/ceph/ceph-ansible/commit/c843ea1d) - igw: Fix default api port (Mike Christie)
* [f17140c0](https://github.com/ceph/ceph-ansible/commit/f17140c0) - ceph-validate : Added functions to accept true and flase (VasishtaShastry)
* [a74f4204](https://github.com/ceph/ceph-ansible/commit/a74f4204) - remove configuration files for ceph packages on ubuntu clusters (Rishabh Dave)
* [77de5402](https://github.com/ceph/ceph-ansible/commit/77de5402) - igw: stop tcmu-runner on iscsi purge (Mike Christie)
* [93cdbddd](https://github.com/ceph/ceph-ansible/commit/93cdbddd) - tests: test ooo_collocation agasint v3.0.3 ceph-container image (Guillaume Abrioux)
* [12ce311d](https://github.com/ceph/ceph-ansible/commit/12ce311d) - rbd-mirror: enable ceph-rbd-mirror.target (Sébastien Han)
* [ee883aa9](https://github.com/ceph/ceph-ansible/commit/ee883aa9) - validate: do not validate ceph_repository if deploying containers (Andrew Schoen)
* [d5409109](https://github.com/ceph/ceph-ansible/commit/d5409109) - rgw: move multisite default variables in ceph-defaults (Guillaume Abrioux)
* [f5234430](https://github.com/ceph/ceph-ansible/commit/f5234430) - tests: add more memory for rgw_multsite scenarios (Guillaume Abrioux)
* [547e90f2](https://github.com/ceph/ceph-ansible/commit/547e90f2) - rgw: move multisite related tasks after docker/main.yml (Guillaume Abrioux)
* [710e1166](https://github.com/ceph/ceph-ansible/commit/710e1166) - rgw: add rgw_multisite for containerized deployments (Guillaume Abrioux)
* [37970a5b](https://github.com/ceph/ceph-ansible/commit/37970a5b) - tests: add rgw_multisite functional test (Guillaume Abrioux)
* [4d464c10](https://github.com/ceph/ceph-ansible/commit/4d464c10) - rgw: add testing scenario for rgw multisite (Guillaume Abrioux)
* [fe88c89c](https://github.com/ceph/ceph-ansible/commit/fe88c89c) - validate: remove check on rgw_multisite_endpoint_addr definition (Guillaume Abrioux)
* [59e6d04f](https://github.com/ceph/ceph-ansible/commit/59e6d04f) - rgw: add ceph-validate tasks for multisite, other fixes (Ali Maredia)
* [77d5d128](https://github.com/ceph/ceph-ansible/commit/77d5d128) - rgw: add a dedicated variable for multisite endpoint (Guillaume Abrioux)
* [474f1514](https://github.com/ceph/ceph-ansible/commit/474f1514) - rgw: update rgw multisite tasks (Ali Maredia)
* [9e87a5ae](https://github.com/ceph/ceph-ansible/commit/9e87a5ae) - travis: add ansible-galaxy integration (Sébastien Han)
* [49d4b657](https://github.com/ceph/ceph-ansible/commit/49d4b657) - gitignore: add mergify and travis as exceptions (Sébastien Han)
* [b8a203ba](https://github.com/ceph/ceph-ansible/commit/b8a203ba) - contrib: rm script push-roles-to-ansible-galaxy.sh (Sébastien Han)
* [0e659caf](https://github.com/ceph/ceph-ansible/commit/0e659caf) - cleanup repos's root (Sébastien Han)
* [252d0f9c](https://github.com/ceph/ceph-ansible/commit/252d0f9c) - ceph-volume: fix TypeError exception when setting osds-per-device > 1 (Maciej Naruszewicz)
* [22aed972](https://github.com/ceph/ceph-ansible/commit/22aed972) - testinfra: change test osds for containers (Sébastien Han)
* [1df0a7ac](https://github.com/ceph/ceph-ansible/commit/1df0a7ac) - ceph_volume: add container support for batch (Sébastien Han)
* [1cdec406](https://github.com/ceph/ceph-ansible/commit/1cdec406) - test_osd: dynamically get the osd container (Sébastien Han)
* [876f6ced](https://github.com/ceph/ceph-ansible/commit/876f6ced) - test: convert all the tests to use lvm (Sébastien Han)
* [89e76e5b](https://github.com/ceph/ceph-ansible/commit/89e76e5b) - tox: change container image to use master (Sébastien Han)
* [2fd7da12](https://github.com/ceph/ceph-ansible/commit/2fd7da12) - test: remove ceph-disk CI tests (Sébastien Han)
* [748342f5](https://github.com/ceph/ceph-ansible/commit/748342f5) - roles: fix *_docker_memory_limit default value (Guillaume Abrioux)
* [b7e4d4eb](https://github.com/ceph/ceph-ansible/commit/b7e4d4eb) - roles: do not limit docker_memory_limit for various daemons (Neha Ojha)
* [219fa8f9](https://github.com/ceph/ceph-ansible/commit/219fa8f9) - infrastructure playbooks: ensure nvme_device is defined in lv-create.yml (Ali Maredia)
* [5ab90b35](https://github.com/ceph/ceph-ansible/commit/5ab90b35) - nfs: do not create the nfs user if already present (Sébastien Han)
* [fc20973c](https://github.com/ceph/ceph-ansible/commit/fc20973c) - Fix problem with ceph_key in python3 (Jairo Llopis)
* [91385e4f](https://github.com/ceph/ceph-ansible/commit/91385e4f) - ceph_volume: better error handling (Sébastien Han)
* [c5810000](https://github.com/ceph/ceph-ansible/commit/c5810000) - ceph_volume: expose ceph-volume logs on the host (Sébastien Han)
* [cd3d6409](https://github.com/ceph/ceph-ansible/commit/cd3d6409) - resync group_vars/*.sample files (Guillaume Abrioux)
* [a0cceb3e](https://github.com/ceph/ceph-ansible/commit/a0cceb3e) - tox: fix a typo (Guillaume Abrioux)
* [09048600](https://github.com/ceph/ceph-ansible/commit/09048600) - igw: stop daemons on purge all calls (Mike Christie)
* [ff4dc83b](https://github.com/ceph/ceph-ansible/commit/ff4dc83b) - ceph-validate: avoid "list index out of range" error (Rishabh Dave)
* [4d698ce8](https://github.com/ceph/ceph-ansible/commit/4d698ce8) - ceph-infra: reload firewall after rules are added (Guillaume Abrioux)
* [ee2d52d3](https://github.com/ceph/ceph-ansible/commit/ee2d52d3) - allow custom pool size (Rishabh Dave)
* [c47aa2e8](https://github.com/ceph/ceph-ansible/commit/c47aa2e8) - tests: remove unnecessary variables definition (Guillaume Abrioux)
* [48cfc607](https://github.com/ceph/ceph-ansible/commit/48cfc607) - defaults: set default `configure_firewall` to `True` (Guillaume Abrioux)
* [44d0da0d](https://github.com/ceph/ceph-ansible/commit/44d0da0d) - rolling_update: fix upgrade when using fqdn (Sébastien Han)
* [a439eb57](https://github.com/ceph/ceph-ansible/commit/a439eb57) - validate: check the version of python-notario (Andrew Schoen)
* [8fa437b7](https://github.com/ceph/ceph-ansible/commit/8fa437b7) - iscsi: fix networking issue on containerized env (Guillaume Abrioux)
* [1f909088](https://github.com/ceph/ceph-ansible/commit/1f909088) - Revert "tests: test `test_all_docker_osds_are_up_and_in()` from mon nodes" (Guillaume Abrioux)
* [cb35cac9](https://github.com/ceph/ceph-ansible/commit/cb35cac9) - tests: set configure_firewall: true in centos7|docker_cluster (Guillaume Abrioux)
* [e77c36ad](https://github.com/ceph/ceph-ansible/commit/e77c36ad) - infra: move restart fw handler in ceph-infra role (Guillaume Abrioux)
* [b8ad35ce](https://github.com/ceph/ceph-ansible/commit/b8ad35ce) - tests: test `test_all_docker_osds_are_up_and_in()` from mon nodes (Guillaume Abrioux)
* [b8418ebd](https://github.com/ceph/ceph-ansible/commit/b8418ebd) - add-osds: followup on 3632b26 (Guillaume Abrioux)
* [d6e79044](https://github.com/ceph/ceph-ansible/commit/d6e79044) - infra: add a gather-ceph-logs.yml playbook (Sébastien Han)
* [3632b260](https://github.com/ceph/ceph-ansible/commit/3632b260) - tests: add tests for day-2-operation playbook (Guillaume Abrioux)
* [fbd878c8](https://github.com/ceph/ceph-ansible/commit/fbd878c8) - infra: rename osd-configure to add-osd and improve it (Sébastien Han)
* [680574ed](https://github.com/ceph/ceph-ansible/commit/680574ed) - ceph-fetch-keys: refact (Sébastien Han)
* [3e0fa3bc](https://github.com/ceph/ceph-ansible/commit/3e0fa3bc) - Add ability to use a different client container (Andy McCrae)
* [f0b2d826](https://github.com/ceph/ceph-ansible/commit/f0b2d826) - infra: fix wrong condition on firewalld start task (Guillaume Abrioux)
* [ac37a0d0](https://github.com/ceph/ceph-ansible/commit/ac37a0d0) - ceph-defaults: set ceph_stable_openstack_release_uca to queens (Christian Berendt)
* [5fa2b699](https://github.com/ceph/ceph-ansible/commit/5fa2b699) - contrib: add a bash script to snapshort libvirt vms (Guillaume Abrioux)
* [b9539653](https://github.com/ceph/ceph-ansible/commit/b9539653) - handler: remove some leftover in restart_*_daemon.sh.j2 (Guillaume Abrioux)
* [fc6f1ae0](https://github.com/ceph/ceph-ansible/commit/fc6f1ae0) - doc: update default osd_objectstore value (Guillaume Abrioux)
* [55334baa](https://github.com/ceph/ceph-ansible/commit/55334baa) - docker-ce is used in aarch64 instead of docker engine (Nan Li)
* [07140f80](https://github.com/ceph/ceph-ansible/commit/07140f80) - Mergify: fix regexp operator (Julien Danjou)
* [25bde395](https://github.com/ceph/ceph-ansible/commit/25bde395) - Update Mergify configuration to v2 (Julien Danjou)
* [dc020058](https://github.com/ceph/ceph-ansible/commit/dc020058) - vagrantfile: remove disk path of OSD nodes (binhong.hua)
* [60bc1e38](https://github.com/ceph/ceph-ansible/commit/60bc1e38) - handler: fix osd containers handler (Guillaume Abrioux)
* [40b7747a](https://github.com/ceph/ceph-ansible/commit/40b7747a) - remove jewel support (Guillaume Abrioux)
* [fa38b86c](https://github.com/ceph/ceph-ansible/commit/fa38b86c) - test: fix docker test for lvm (Sébastien Han)
* [9fccffa1](https://github.com/ceph/ceph-ansible/commit/9fccffa1) - switch: allow switch big clusters (more than 99 osds) (Sébastien Han)
* [31a0438c](https://github.com/ceph/ceph-ansible/commit/31a0438c) - ceph_volume: refactor (Sébastien Han)
* [d2ca24ec](https://github.com/ceph/ceph-ansible/commit/d2ca24ec) - tests: do not install lvm2 on atomic host (Guillaume Abrioux)
* [90c66a58](https://github.com/ceph/ceph-ansible/commit/90c66a58) - ci: test lvm in containerized (Sébastien Han)
* [05afaed8](https://github.com/ceph/ceph-ansible/commit/05afaed8) - doc: improve osd configuration section (Sébastien Han)
* [bfe68909](https://github.com/ceph/ceph-ansible/commit/bfe68909) - osd: do not run when lvm scenario (Sébastien Han)
* [2bea8d8e](https://github.com/ceph/ceph-ansible/commit/2bea8d8e) - handler: add support for ceph-volume containerized restart (Sébastien Han)
* [790f52f9](https://github.com/ceph/ceph-ansible/commit/790f52f9) - ceph-handler: change osd container check (Sébastien Han)
* [0735d395](https://github.com/ceph/ceph-ansible/commit/0735d395) - tests: osd adjust osd name (Sébastien Han)
* [05803283](https://github.com/ceph/ceph-ansible/commit/05803283) - validate: add warning for ceph-disk (Sébastien Han)
* [a948677d](https://github.com/ceph/ceph-ansible/commit/a948677d) - osd: ceph-volume activate, just pass the OSD_ID (Sébastien Han)
* [5f35910e](https://github.com/ceph/ceph-ansible/commit/5f35910e) - osd: change unit template for ceph-volume container (Sébastien Han)
* [ece9e981](https://github.com/ceph/ceph-ansible/commit/ece9e981) - osd: do not use expose_partitions on lvm (Sébastien Han)
* [e39fc4f6](https://github.com/ceph/ceph-ansible/commit/e39fc4f6) - ceph_volume: add container support for batch command (Sébastien Han)
* [3ddcc9af](https://github.com/ceph/ceph-ansible/commit/3ddcc9af) - ceph_volume: try to get ride of the dummy container (Sébastien Han)
* [aa2c1b27](https://github.com/ceph/ceph-ansible/commit/aa2c1b27) - ceph-osd: ceph-volume container support (Sébastien Han)
* [678e1553](https://github.com/ceph/ceph-ansible/commit/678e1553) - infra: fix a typo in filename (Guillaume Abrioux)
* [f666902d](https://github.com/ceph/ceph-ansible/commit/f666902d) - infra: add tags for each subcomponent (Guillaume Abrioux)
* [f8a7ffb0](https://github.com/ceph/ceph-ansible/commit/f8a7ffb0) - infra: add firewall configuration for containerized deployment (Guillaume Abrioux)
* [0fb8812e](https://github.com/ceph/ceph-ansible/commit/0fb8812e) - infra: update firewall rules, add cluster_network for osds (Guillaume Abrioux)
* [b3a71eeb](https://github.com/ceph/ceph-ansible/commit/b3a71eeb) - ceph-infra: add new role ceph-infra (Guillaume Abrioux)
* [8dcc8d14](https://github.com/ceph/ceph-ansible/commit/8dcc8d14) - Stringify ceph_docker_image_tag (Noah Watkins)
* [306e308f](https://github.com/ceph/ceph-ansible/commit/306e308f) - Avoid using tests as filter (Noah Watkins)
* [cc6f41f7](https://github.com/ceph/ceph-ansible/commit/cc6f41f7) - tests: fix lvm2 setup issue (Guillaume Abrioux)
* [ce8e740f](https://github.com/ceph/ceph-ansible/commit/ce8e740f) - docs: Correct mandatory config options (Ramana Raja)
* [3e488e82](https://github.com/ceph/ceph-ansible/commit/3e488e82) - tests: install lvm2 before setting up ceph-volume/LVM tests (Alfredo Deza)
* [ada03d06](https://github.com/ceph/ceph-ansible/commit/ada03d06) - ceph-validate: remove versions checks for bluestore and lvm scenario (Andrew Schoen)
* [436dc8c5](https://github.com/ceph/ceph-ansible/commit/436dc8c5) - ceph-config: allow the batch --report to fail when getting the OSD num (Andrew Schoen)
* [a63ca220](https://github.com/ceph/ceph-ansible/commit/a63ca220) - ceph-volume: if --report fails to load json, fail with better info (Andrew Schoen)
* [a68c6802](https://github.com/ceph/ceph-ansible/commit/a68c6802) - tests: remove journal_size from lvm-batch testing scenario (Andrew Schoen)
* [5ee305d1](https://github.com/ceph/ceph-ansible/commit/5ee305d1) - ceph-volume: make the batch action idempotent (Andrew Schoen)
* [40f82319](https://github.com/ceph/ceph-ansible/commit/40f82319) - ceph-config: use 'lvm list' to find num_osds for an existing cluster (Andrew Schoen)
* [2ffad1b4](https://github.com/ceph/ceph-ansible/commit/2ffad1b4) - ceph-volume: adds `lvm list` support to the ceph_volume module (Andrew Schoen)
* [8afef3d0](https://github.com/ceph/ceph-ansible/commit/8afef3d0) - ceph-config: use the ceph_volume module to get num_osds for lvm batch (Andrew Schoen)
* [07a384ba](https://github.com/ceph/ceph-ansible/commit/07a384ba) - ceph_volume: adds the report parameter (Andrew Schoen)
* [c453ea25](https://github.com/ceph/ceph-ansible/commit/c453ea25) - ceph-osd: use journal_size and block_db_size for lvm batch (Andrew Schoen)
* [71ce539d](https://github.com/ceph/ceph-ansible/commit/71ce539d) - ceph-defaults: add the block_db_size option (Andrew Schoen)
* [8bb131c7](https://github.com/ceph/ceph-ansible/commit/8bb131c7) - ceph-volume: add the journal_size and block_db_size options (Andrew Schoen)
* [82ec5a29](https://github.com/ceph/ceph-ansible/commit/82ec5a29) - site: use default value for 'cluster' variable (Sébastien Han)
* [9180f6a2](https://github.com/ceph/ceph-ansible/commit/9180f6a2) - rhcs: add helpers for the containerized deployment (Sébastien Han)
* [3e2cdcc7](https://github.com/ceph/ceph-ansible/commit/3e2cdcc7) - common: remove check_firewall code (Guillaume Abrioux)
* [be31c15c](https://github.com/ceph/ceph-ansible/commit/be31c15c) - follow up on b5d2ea2 (Guillaume Abrioux)
* [79bd06ad](https://github.com/ceph/ceph-ansible/commit/79bd06ad) - rolling_update: add ceph-handler role (Guillaume Abrioux)
* [b5d2ea26](https://github.com/ceph/ceph-ansible/commit/b5d2ea26) - don't use "static" field while including tasks (Rishabh Dave)
* [bae0f417](https://github.com/ceph/ceph-ansible/commit/bae0f417) - switch: copy initial mon keyring (Sébastien Han)
* [03e76af7](https://github.com/ceph/ceph-ansible/commit/03e76af7) - switch: add missing call to ceph-handler role (Guillaume Abrioux)
* [54b02fe1](https://github.com/ceph/ceph-ansible/commit/54b02fe1) - switch: support migration when cluster is scrubbing (Guillaume Abrioux)
* [6130bc84](https://github.com/ceph/ceph-ansible/commit/6130bc84) - config: look up for monitor_address_block in hostvars (Guillaume Abrioux)
* [85071e6e](https://github.com/ceph/ceph-ansible/commit/85071e6e) - Add support for different NTP daemons (Benjamin Cherian)
* [eddb9594](https://github.com/ceph/ceph-ansible/commit/eddb9594) - igw: valid client CHAP settings. (Mike Christie)
* [54adb6d8](https://github.com/ceph/ceph-ansible/commit/54adb6d8) - doc: redo lvm scenario documentation, improved wording and config descriptions (Alfredo Deza)
* [4db6a213](https://github.com/ceph/ceph-ansible/commit/4db6a213) - add ceph-handler role (Sébastien Han)
* [9747f3db](https://github.com/ceph/ceph-ansible/commit/9747f3db) - purge-cluster: zap devices used with the lvm scenario (Andrew Schoen)
* [5da71e1c](https://github.com/ceph/ceph-ansible/commit/5da71e1c) - purge-cluster: recursively remove ceph-related files, symlinks and directories under /etc/systemd/system. (wumingqiao)
* [9fe86c22](https://github.com/ceph/ceph-ansible/commit/9fe86c22) - test: use osd_objecstore default value (Sébastien Han)
* [145aef9f](https://github.com/ceph/ceph-ansible/commit/145aef9f) - defaults: do not disable THP on bluestore (Sébastien Han)
* [dc3319c3](https://github.com/ceph/ceph-ansible/commit/dc3319c3) - default: use bluestore as default object store (Sébastien Han)
* [380168da](https://github.com/ceph/ceph-ansible/commit/380168da) - don't use "include" to include tasks (Rishabh Dave)
* [144c92b2](https://github.com/ceph/ceph-ansible/commit/144c92b2) - purge: actually remove of /var/lib/ceph/* (Guillaume Abrioux)
* [179c4d00](https://github.com/ceph/ceph-ansible/commit/179c4d00) - rolling_update: ensure pgs_by_state has at least 1 entry (Guillaume Abrioux)
* [c13a3c34](https://github.com/ceph/ceph-ansible/commit/c13a3c34) - upgrade: consider all 'active+clean' states as valid pgs (Guillaume Abrioux)
* [4cd675e7](https://github.com/ceph/ceph-ansible/commit/4cd675e7) - docs: supported validation by the ceph-validate role (Andrew Schoen)
* [3285b477](https://github.com/ceph/ceph-ansible/commit/3285b477) - tests: add an RGW node on osd0 for ooo-collocation (Guillaume Abrioux)
* [6126210e](https://github.com/ceph/ceph-ansible/commit/6126210e) - Fix version check in ceph.conf template (Giulio Fidente)
* [806461ac](https://github.com/ceph/ceph-ansible/commit/806461ac) - restart_osd_daemon.sh.j2 - use `+` rather than `{1,}` in regex (Matthew Vernon)
* [04f49916](https://github.com/ceph/ceph-ansible/commit/04f49916) - restart_osd_daemon.sh.j2 - consider active+clean+* pgs as OK (Matthew Vernon)
* [aa97ecf0](https://github.com/ceph/ceph-ansible/commit/aa97ecf0) - restart_osd_daemon.sh.j2 - Reset RETRIES between calls of check_pgs (Matthew Vernon)
* [26bfef41](https://github.com/ceph/ceph-ansible/commit/26bfef41) - Remove Calamari-related pieces (John Spray)
* [bd82c380](https://github.com/ceph/ceph-ansible/commit/bd82c380) - vagrantfile: fix references to OpenStack settings (Norbert Illés)
* [16ccac83](https://github.com/ceph/ceph-ansible/commit/16ccac83) - ceph-config: calculate num_osds for the lvm batch scenario (Andrew Schoen)
* [6d6fd514](https://github.com/ceph/ceph-ansible/commit/6d6fd514) - config: set default _rgw_hostname value to respective host (Guillaume Abrioux)
* [8afad35f](https://github.com/ceph/ceph-ansible/commit/8afad35f) - ceph-config: default devices and lvm_volumes when setting num_osds (Andrew Schoen)
* [27027a17](https://github.com/ceph/ceph-ansible/commit/27027a17) - osd: add osd memory target option (Neha Ojha)
* [57f0b6a4](https://github.com/ceph/ceph-ansible/commit/57f0b6a4) - shrink-osd: follow up on 36fb3cde (Guillaume Abrioux)
* [98c210d7](https://github.com/ceph/ceph-ansible/commit/98c210d7) - site-docker: fix undefined variable error (Guillaume Abrioux)
* [735e1917](https://github.com/ceph/ceph-ansible/commit/735e1917) - shrink-osd: purge dedicated devices (Sébastien Han)
* [8fcd63cc](https://github.com/ceph/ceph-ansible/commit/8fcd63cc) - igw: enable and start rbd-target-api (Mike Christie)
* [3382c522](https://github.com/ceph/ceph-ansible/commit/3382c522) - tests: fix monitor_address for shrink_osd scenario (Guillaume Abrioux)
* [4159326a](https://github.com/ceph/ceph-ansible/commit/4159326a) - shrink-osd: fix purge osd on containerized deployment (Guillaume Abrioux)
* [7a617715](https://github.com/ceph/ceph-ansible/commit/7a617715) - doc: update lvm doc (Guillaume Abrioux)
* [a6f77340](https://github.com/ceph/ceph-ansible/commit/a6f77340) - nfs: ignore error on semanage command for ganesha_t (Guillaume Abrioux)
* [8f2c660d](https://github.com/ceph/ceph-ansible/commit/8f2c660d) - tests: pin sphinx version to 1.7.9 (Guillaume Abrioux)
* [b36f3e06](https://github.com/ceph/ceph-ansible/commit/b36f3e06) - ceph_volume: adds the osds_per_device parameter (Andrew Schoen)
* [1c88c444](https://github.com/ceph/ceph-ansible/commit/1c88c444) - mon: fix `ExecStartPre` option in systemd unit file (Guillaume Abrioux)
* [9ff26e80](https://github.com/ceph/ceph-ansible/commit/9ff26e80) - defaults: add a default value to rgw_hostname (Guillaume Abrioux)
* [6954ac18](https://github.com/ceph/ceph-ansible/commit/6954ac18) - tests: do not upgrade ceph release for switch_to_containers scenario (Guillaume Abrioux)
* [ecbd3e45](https://github.com/ceph/ceph-ansible/commit/ecbd3e45) - Revert "client: add quotes to the dict values" (Guillaume Abrioux)
* [bf8f5899](https://github.com/ceph/ceph-ansible/commit/bf8f5899) - run rados cmd in container if containerized deployment (Tom Barron)
* [217f35db](https://github.com/ceph/ceph-ansible/commit/217f35db) - roles: ceph-rgw: Enable the ceph-radosgw target (Markos Chandras)
* [38dc20e7](https://github.com/ceph/ceph-ansible/commit/38dc20e7) - purge: only purge /var/lib/ceph content (Sébastien Han)
* [58b23080](https://github.com/ceph/ceph-ansible/commit/58b23080) - tests: use new 'num_osds' variable in tests (Alfredo Deza)
* [e5fcb0d2](https://github.com/ceph/ceph-ansible/commit/e5fcb0d2) - tests: allow defining arbitrary number of OSDs (Alfredo Deza)
* [772e6b9b](https://github.com/ceph/ceph-ansible/commit/772e6b9b) - Dont run client dummy container on non-x86_64 hosts (Andy McCrae)
* [561ec920](https://github.com/ceph/ceph-ansible/commit/561ec920) - infrastructure-playbooks: add comments for lv_vars.yml (Ali Maredia)
* [77eb459a](https://github.com/ceph/ceph-ansible/commit/77eb459a) - infrastructure playbooks: remove lv-create error msg (Ali Maredia)
* [124fc727](https://github.com/ceph/ceph-ansible/commit/124fc727) - doc: remove old statement (Sébastien Han)
* [9ba67056](https://github.com/ceph/ceph-ansible/commit/9ba67056) - remove warning for unsupported variables (Sébastien Han)
* [e1ff4388](https://github.com/ceph/ceph-ansible/commit/e1ff4388) - infrastructure-playbooks: failure msg for pvcreate (Ali Maredia)
* [ae5ebeeb](https://github.com/ceph/ceph-ansible/commit/ae5ebeeb) - sites: fix conditonnal (Sébastien Han)
* [30cfeb54](https://github.com/ceph/ceph-ansible/commit/30cfeb54) - site-docker.yml: remove useless condition (Sébastien Han)
* [7012835d](https://github.com/ceph/ceph-ansible/commit/7012835d) - ci: stop using different images on the same run (Sébastien Han)
* [6d7fa99f](https://github.com/ceph/ceph-ansible/commit/6d7fa99f) - defaults: fix rgw_hostname (Sébastien Han)
* [0d448da6](https://github.com/ceph/ceph-ansible/commit/0d448da6) - vagrant: move variable samples to contrib (Sébastien Han)
* [a2ad2fb3](https://github.com/ceph/ceph-ansible/commit/a2ad2fb3) - rm ceph-aio-no-vagrant.sh (Sébastien Han)
* [017aa6ef](https://github.com/ceph/ceph-ansible/commit/017aa6ef) - remove monitor_keys_example file (Sébastien Han)
* [18684b72](https://github.com/ceph/ceph-ansible/commit/18684b72) - Sync config_template with base plugin (Andy McCrae)
* [2e6e885b](https://github.com/ceph/ceph-ansible/commit/2e6e885b) - rolling_upgrade: set sortbitwise properly (Sébastien Han)
* [77a3a682](https://github.com/ceph/ceph-ansible/commit/77a3a682) - iscsi group name preserve backward compatibility (Sébastien Han)
* [8c70a5b1](https://github.com/ceph/ceph-ansible/commit/8c70a5b1) - osd: fix ceph_release (Sébastien Han)
* [b7387068](https://github.com/ceph/ceph-ansible/commit/b7387068) - take-over-existing-cluster: do not call var_files (Sébastien Han)
* [126e2e3f](https://github.com/ceph/ceph-ansible/commit/126e2e3f) - roles: ceph-defaults: Check if 'rgw' attribute exists for rgw_hostname (Markos Chandras)
* [37e50114](https://github.com/ceph/ceph-ansible/commit/37e50114) - roles: ceph-defaults: Delegate cluster information task to monitor node (Markos Chandras)
* [f6519e40](https://github.com/ceph/ceph-ansible/commit/f6519e40) - mgr: improve/fix disabled modules check (Dardo D Kleiner)
* [04df3f08](https://github.com/ceph/ceph-ansible/commit/04df3f08) - lv-create: use copy instead of the template module (Andrew Schoen)
* [f5a4c898](https://github.com/ceph/ceph-ansible/commit/f5a4c898) - tests: cat the contents of lv-create.log in infra_lv_create (Andrew Schoen)
* [131796f2](https://github.com/ceph/ceph-ansible/commit/131796f2) - lv-create: add an example logfile_path config option in lv_vars.yml (Andrew Schoen)
* [810cc478](https://github.com/ceph/ceph-ansible/commit/810cc478) - tests: adds a testing scenario for lv-create and lv-teardown (Andrew Schoen)
* [b0bfc173](https://github.com/ceph/ceph-ansible/commit/b0bfc173) - lv-teardown: fail silently if lv_vars.yml is not found (Andrew Schoen)
* [8424858b](https://github.com/ceph/ceph-ansible/commit/8424858b) - lv-teardown: set become: true at the playbook level (Andrew Schoen)
* [e43eec57](https://github.com/ceph/ceph-ansible/commit/e43eec57) - lv-create: fail silenty if lv_vars.yml is not found (Andrew Schoen)
* [fde47be1](https://github.com/ceph/ceph-ansible/commit/fde47be1) - lv-create: set become: true at the playbook level (Andrew Schoen)
* [35301b35](https://github.com/ceph/ceph-ansible/commit/35301b35) - lv-create: use the template module to write log file (Andrew Schoen)
* [909b38da](https://github.com/ceph/ceph-ansible/commit/909b38da) - infrastructure-playbooks/vars/lv_vars.yaml: minor fixes (Neha Ojha)
* [f65f3ea8](https://github.com/ceph/ceph-ansible/commit/f65f3ea8) - infrastructure-playbooks/lv-create.yml: use tempfile to create logfile (Neha Ojha)
* [65fdad07](https://github.com/ceph/ceph-ansible/commit/65fdad07) - infrastructure-playbooks/lv-create.yml: add lvm_volumes to suggested paste (Neha Ojha)
* [50a6d814](https://github.com/ceph/ceph-ansible/commit/50a6d814) - infrastructure-playbooks/lv-create.yml: copy without using a template file (Neha Ojha)
* [186c4e11](https://github.com/ceph/ceph-ansible/commit/186c4e11) - infrastructure-playbooks/lv-create.yml: don't use action to copy (Neha Ojha)
* [9d43806d](https://github.com/ceph/ceph-ansible/commit/9d43806d) - infrastructure-playbooks: standardize variable usage with a space after brackets (Neha Ojha)
* [e0293de3](https://github.com/ceph/ceph-ansible/commit/e0293de3) - vars/lv_vars.yaml: remove journal_device (Neha Ojha)
* [1f018d86](https://github.com/ceph/ceph-ansible/commit/1f018d86) - infrastructure-playbooks: playbooks for creating LVs for bucket indexes and journals (Ali Maredia)
* [dad10e8f](https://github.com/ceph/ceph-ansible/commit/dad10e8f) - rolling_update: register container osd units (Sébastien Han)
* [3149b256](https://github.com/ceph/ceph-ansible/commit/3149b256) - Revert "osd: generate device list for osd_auto_discovery on rolling_update" (Sébastien Han)
* [85cc61a6](https://github.com/ceph/ceph-ansible/commit/85cc61a6) - Use /var/lib/ceph/osd folder to filter osd mount point (Jeffrey Zhang)
* [7172737f](https://github.com/ceph/ceph-ansible/commit/7172737f) - roles: ceph-defaults: Set ceph_uid on SUSE distributions (Markos Chandras)
* [36942af6](https://github.com/ceph/ceph-ansible/commit/36942af6) - mgr: backward compatibility for module management (Guillaume Abrioux)
* [8b5e3cd9](https://github.com/ceph/ceph-ansible/commit/8b5e3cd9) - validate: fail if fqdn deployment attempted (Guillaume Abrioux)
* [f422efb1](https://github.com/ceph/ceph-ansible/commit/f422efb1) - config: ensure rgw section has the correct name (Guillaume Abrioux)
* [db29b5b8](https://github.com/ceph/ceph-ansible/commit/db29b5b8) - config: clean template, remove useless conditions (Guillaume Abrioux)
* [4522dbfc](https://github.com/ceph/ceph-ansible/commit/4522dbfc) - doc: update ansible supported version matrix. (Guillaume Abrioux)
* [4c9e24a9](https://github.com/ceph/ceph-ansible/commit/4c9e24a9) - mon: fix calamari initialisation (Sébastien Han)
* [6423ab4a](https://github.com/ceph/ceph-ansible/commit/6423ab4a) - lvm: fix condition when selecting which scenario to run (Andrew Schoen)
* [e84f11e9](https://github.com/ceph/ceph-ansible/commit/e84f11e9) - osd: generate device list for osd_auto_discovery on rolling_update (Sébastien Han)
* [e15c61b6](https://github.com/ceph/ceph-ansible/commit/e15c61b6) - updates group_vars/osds.yml.sample to inlude crush_device_class (Andrew Schoen)
* [68d92929](https://github.com/ceph/ceph-ansible/commit/68d92929) - ceph-volume: docs for "lvm batch" support (Andrew Schoen)
* [647bbd8f](https://github.com/ceph/ceph-ansible/commit/647bbd8f) - tests: adds crush_device_class to lvm-batch scenario (Andrew Schoen)
* [3592c68c](https://github.com/ceph/ceph-ansible/commit/3592c68c) - ceph-osd: adds crush_device_class config option (Andrew Schoen)
* [6d431ec2](https://github.com/ceph/ceph-ansible/commit/6d431ec2) - ceph-volume: implement the 'lvm batch' subcommand (Andrew Schoen)
* [4d64dd46](https://github.com/ceph/ceph-ansible/commit/4d64dd46) - rgw: ability to use ceph-ansible vars into containers (Sébastien Han)
* [3bce117d](https://github.com/ceph/ceph-ansible/commit/3bce117d) - rgw: remove unused file (Sébastien Han)
* [5a89479a](https://github.com/ceph/ceph-ansible/commit/5a89479a) - rgw: remove useless condition (Sébastien Han)
* [a4602582](https://github.com/ceph/ceph-ansible/commit/a4602582) - Allow mgr bootstrap keyring to be defined (Graeme Gillies)
* [19518656](https://github.com/ceph/ceph-ansible/commit/19518656) - Resync rhcs_edits.txt (Sébastien Han)
* [83edbcb5](https://github.com/ceph/ceph-ansible/commit/83edbcb5) - docs: overall improvements (Christian Berendt)
* [77d4023f](https://github.com/ceph/ceph-ansible/commit/77d4023f) - test: follow up on osd_crush_location for containers (Sébastien Han)
* [50be3fd9](https://github.com/ceph/ceph-ansible/commit/50be3fd9) - test: remove osd_crush_location from shrink scenarios (Sébastien Han)
* [d168d81c](https://github.com/ceph/ceph-ansible/commit/d168d81c) - docs: overall syntax improvements (Christian Berendt)
* [52d9d406](https://github.com/ceph/ceph-ansible/commit/52d9d406) - Fix in regular expression matching OSD ID on non-contenerized deployment. restart_osd_daemon.sh is used to discover and restart all OSDs on a host. To do it the scripts loops the list of ceph-osd@ services in the system. This commit fixes bug in the regular expression responsile for extraction of OSDs - prior version uses `[0-9]{1,2}` expression which is ignoring all OSDS which numbers are greater than 99 (thus longer than 2 digits). Fix removed upper limit of digits in the number. This problem existed in two places in the script. (Artur Fijalkowski)
* [1164cdc0](https://github.com/ceph/ceph-ansible/commit/1164cdc0) - iscsigw: install ceph-iscsi-cli package (Guillaume Abrioux)
* [0a6ff6bb](https://github.com/ceph/ceph-ansible/commit/0a6ff6bb) - defaults: backward compatibility with fqdn deployments (Guillaume Abrioux)
* [ea9e60d4](https://github.com/ceph/ceph-ansible/commit/ea9e60d4) - config: enforce socket name (Sébastien Han)
* [6f72f96d](https://github.com/ceph/ceph-ansible/commit/6f72f96d) - igw: do not fail purge on rbd removal errors (Mike Christie)
* [d572a9a6](https://github.com/ceph/ceph-ansible/commit/d572a9a6) - igw: fix image removal during purge (Mike Christie)
* [b334cdcb](https://github.com/ceph/ceph-ansible/commit/b334cdcb) - restapi: disable it when ceph version > luminous (Sébastien Han)
* [2ca8c519](https://github.com/ceph/ceph-ansible/commit/2ca8c519) - osd: do not remove expose_partition container (Sébastien Han)
* [1f341e69](https://github.com/ceph/ceph-ansible/commit/1f341e69) - site: report ceph -s status at the end of the deployment (Sébastien Han)
* [578aa5c2](https://github.com/ceph/ceph-ansible/commit/578aa5c2) - tests: leave an OSD node in default crush root (Guillaume Abrioux)
* [a1ca2c8f](https://github.com/ceph/ceph-ansible/commit/a1ca2c8f) - iscsigw: do not run common roles when deploying jewel (Guillaume Abrioux)
* [1ecbbbdc](https://github.com/ceph/ceph-ansible/commit/1ecbbbdc) - rbd-mirror: bring back compatibility with jewel deployment (Guillaume Abrioux)
* [053709da](https://github.com/ceph/ceph-ansible/commit/053709da) - ceph-osds: backward compatibility with jewel for osp pools creation (Guillaume Abrioux)
* [2597a557](https://github.com/ceph/ceph-ansible/commit/2597a557) - client: fix an incorrect title in a task (Guillaume Abrioux)
* [2bbb4acc](https://github.com/ceph/ceph-ansible/commit/2bbb4acc) - site.yml.sample: fix install python2 (Arata Notsu)
* [e2ea5bac](https://github.com/ceph/ceph-ansible/commit/e2ea5bac) - rgw: add more config option for civetweb frontend (Sébastien Han)
* [e85e5ea7](https://github.com/ceph/ceph-ansible/commit/e85e5ea7) - Run creation of empty rados index object to first monitor (Giulio Fidente)
* [0640e2aa](https://github.com/ceph/ceph-ansible/commit/0640e2aa) - main: update requirements.txt (Guillaume Abrioux)
* [235d1b3f](https://github.com/ceph/ceph-ansible/commit/235d1b3f) - validate: add checks for interfaces (Sébastien Han)
* [b3266c5b](https://github.com/ceph/ceph-ansible/commit/b3266c5b) - rolling_update: set osd sortbitwise (Sébastien Han)
* [0a88bccf](https://github.com/ceph/ceph-ansible/commit/0a88bccf) - tests: followup on b89cc1746f (Guillaume Abrioux)
* [b89cc174](https://github.com/ceph/ceph-ansible/commit/b89cc174) - tests: do not deploy all daemons for shrink osds scenarios (Guillaume Abrioux)
* [af82e752](https://github.com/ceph/ceph-ansible/commit/af82e752) - tests: test master against ansible 2.6 (Guillaume Abrioux)
* [0c863a37](https://github.com/ceph/ceph-ansible/commit/0c863a37) - tests: add support of 'ooo-collocation' scenario when testing against ceph dev (Guillaume Abrioux)
* [d8281e50](https://github.com/ceph/ceph-ansible/commit/d8281e50) - tests: support update scenarios in test_rbd_mirror_is_up() (Guillaume Abrioux)
* [651ee469](https://github.com/ceph/ceph-ansible/commit/651ee469) - tests: stop hardcoding ansible version (Guillaume Abrioux)
* [7fc13bc9](https://github.com/ceph/ceph-ansible/commit/7fc13bc9) - validate: only run osd test on osd node (Sébastien Han)
* [77498022](https://github.com/ceph/ceph-ansible/commit/77498022) - docs: update doc (Guillaume Abrioux)
* [ce1dd8d2](https://github.com/ceph/ceph-ansible/commit/ce1dd8d2) - shrink-osd: purge osd on containerized deployment (Sébastien Han)
* [cf01e596](https://github.com/ceph/ceph-ansible/commit/cf01e596) - valide: improve device check (Sébastien Han)
* [05852b03](https://github.com/ceph/ceph-ansible/commit/05852b03) - tests: add latest-bis-jewel for jewel tests (Guillaume Abrioux)
* [1a626d3c](https://github.com/ceph/ceph-ansible/commit/1a626d3c) - nfs: change default stable branch for nfs-ganesha repo (Guillaume Abrioux)
* [cc71bb96](https://github.com/ceph/ceph-ansible/commit/cc71bb96) - tests: followup on #2656 (Guillaume Abrioux)
* [e61ca882](https://github.com/ceph/ceph-ansible/commit/e61ca882) - validate: force ansible version (Sébastien Han)
* [5ef5fcd0](https://github.com/ceph/ceph-ansible/commit/5ef5fcd0) - client: do not rely on copy_admin_key to import keys (Guillaume Abrioux)
* [a1b3d5b7](https://github.com/ceph/ceph-ansible/commit/a1b3d5b7) - Sync config_template with upstream for Ansible 2.6 (Andy McCrae)
* [ce5ac930](https://github.com/ceph/ceph-ansible/commit/ce5ac930) - mgr: fix condition to add modules to ceph-mgr (Guillaume Abrioux)
* [c45195a1](https://github.com/ceph/ceph-ansible/commit/c45195a1) - Update issue templates (Sébastien Han)
* [9f54b3b4](https://github.com/ceph/ceph-ansible/commit/9f54b3b4) - mon: ensure socker is purged when mon is stopped (Guillaume Abrioux)
* [d0746e08](https://github.com/ceph/ceph-ansible/commit/d0746e08) - common: switch from docker module to docker_container (Guillaume Abrioux)
* [9a65ec23](https://github.com/ceph/ceph-ansible/commit/9a65ec23) - tests: fix `_get_osd_id_from_host()` in TestOSDs() (Guillaume Abrioux)
* [07852ed0](https://github.com/ceph/ceph-ansible/commit/07852ed0) - Remove zone from zonegroup and update period before deleting the zone to avoid inconsistent period information across other zones. (Shilpa Jagannath)
* [b9f7df7b](https://github.com/ceph/ceph-ansible/commit/b9f7df7b) - common: remove hdparm (Sébastien Han)
* [103529c1](https://github.com/ceph/ceph-ansible/commit/103529c1) - tox: test mimic deployment (Guillaume Abrioux)
* [b6d09b51](https://github.com/ceph/ceph-ansible/commit/b6d09b51) - tests: refact ci testing master (Guillaume Abrioux)
* [09d795b5](https://github.com/ceph/ceph-ansible/commit/09d795b5) - tests: add mimic support for test_rbd_mirror_is_up() (Guillaume Abrioux)
* [713b9fcf](https://github.com/ceph/ceph-ansible/commit/713b9fcf) - ceph-config: do not log cluster log on container (Sébastien Han)
* [fcf11ecc](https://github.com/ceph/ceph-ansible/commit/fcf11ecc) - ceph-common: fix rhcs condition (Sébastien Han)
* [f8fd590f](https://github.com/ceph/ceph-ansible/commit/f8fd590f) - docs: make "OSD Configuration" a subsection (Christian Berendt)
* [0fdb2c4f](https://github.com/ceph/ceph-ansible/commit/0fdb2c4f) - docs: change github/Github to GitHub (Christian Berendt)
* [a8b163a8](https://github.com/ceph/ceph-ansible/commit/a8b163a8) - docs: use apt instead of apt-get (Christian Berendt)
* [3abc253f](https://github.com/ceph/ceph-ansible/commit/3abc253f) - mgr: fix enabling of mgr module on mimic (Guillaume Abrioux)
* [44d51485](https://github.com/ceph/ceph-ansible/commit/44d51485) - Rolling upgrades: Migrate to ceph-key module (Vishal Kanaujia)
* [63658c05](https://github.com/ceph/ceph-ansible/commit/63658c05) - ceph-client: do not kill the dummy container (Sébastien Han)
* [96b187b3](https://github.com/ceph/ceph-ansible/commit/96b187b3) - ci: remove DCO (Sébastien Han)
* [a6294089](https://github.com/ceph/ceph-ansible/commit/a6294089) - ceph-mds: enable application pool (Sébastien Han)
* [103c279c](https://github.com/ceph/ceph-ansible/commit/103c279c) - ceph-defaults: add default application to pool (Sébastien Han)
* [1d454b61](https://github.com/ceph/ceph-ansible/commit/1d454b61) - Enable monitor repo for mgr nodes and Tools repo for iscsi/nfs/clients (Vasu Kulkarni)
* [eb836e7c](https://github.com/ceph/ceph-ansible/commit/eb836e7c) - Sync config_template with upstream (Andy McCrae)
* [abdb53e1](https://github.com/ceph/ceph-ansible/commit/abdb53e1) - ceph-osd: trigger osd container restart on script change (Sébastien Han)
* [f6239972](https://github.com/ceph/ceph-ansible/commit/f6239972) - systemd: remove changed_when: false (Sébastien Han)
* [653b483f](https://github.com/ceph/ceph-ansible/commit/653b483f) - Add ceph_keyring_permissions variable to control permissions for keyring files in /etc/ceph. Default value is the same as it was (0600), but this variable allows user to override it (f.e. set it to 0640). (George Shuklin)
* [a7b7735b](https://github.com/ceph/ceph-ansible/commit/a7b7735b) - ceph-mon: Generate initial keyring (Ha Phan)
* [b7b8aba4](https://github.com/ceph/ceph-ansible/commit/b7b8aba4) - Generate a copy of ceph.conf locally (Ha Phan)
* [a4a3d9a0](https://github.com/ceph/ceph-ansible/commit/a4a3d9a0) - Fix package state for upgrades on SuSE/RHEL (Andy McCrae)
* [322e2de7](https://github.com/ceph/ceph-ansible/commit/322e2de7) - mon: honour mon_docker_net_host option (Sébastien Han)
* [08160084](https://github.com/ceph/ceph-ansible/commit/08160084) - tests: reduce the amount of time we wait (Guillaume Abrioux)
* [f2e57a56](https://github.com/ceph/ceph-ansible/commit/f2e57a56) - tests: factorize docker tests using docker_exec_cmd logic (Guillaume Abrioux)
* [fe79a5d2](https://github.com/ceph/ceph-ansible/commit/fe79a5d2) - tests: refact test_all_*_osds_are_up_and_in (Guillaume Abrioux)
* [2d560b56](https://github.com/ceph/ceph-ansible/commit/2d560b56) - tests: skip tests for node iscsi-gw when deploying jewel (Guillaume Abrioux)
* [1c3dae4a](https://github.com/ceph/ceph-ansible/commit/1c3dae4a) - tests: skip rgw_tuning_pools_are_set when rgw_create_pools is not defined (Guillaume Abrioux)
* [d83b24d2](https://github.com/ceph/ceph-ansible/commit/d83b24d2) - tests: fix broken test when collocated daemons scenarios (Guillaume Abrioux)
* [d0cd6de5](https://github.com/ceph/ceph-ansible/commit/d0cd6de5) - Use rebase as merge strategy for PR (Julien Danjou)
* [824ec6d2](https://github.com/ceph/ceph-ansible/commit/824ec6d2) - Use rebase as merge strategy for PR (Julien Danjou)
* [ddb1520c](https://github.com/ceph/ceph-ansible/commit/ddb1520c) - add mergify (Sébastien Han)
* [77749357](https://github.com/ceph/ceph-ansible/commit/77749357) - Added 'squash' as a parameter to nfs-ganesha. (Michel Rode)
* [372b4a7b](https://github.com/ceph/ceph-ansible/commit/372b4a7b) - doc: Update CONTRIBUTING.md (Guillaume Abrioux)
* [888fb4fc](https://github.com/ceph/ceph-ansible/commit/888fb4fc) - Fix RHEL based Ansible installation (Yaniv Kaul)
* [775a77dc](https://github.com/ceph/ceph-ansible/commit/775a77dc) - Revert "tests: add more verbosity in testinfra" (Guillaume Abrioux)
* [48394597](https://github.com/ceph/ceph-ansible/commit/48394597) - reset failed count of ceph-mgr (Christian Zunker)
* [68eb850b](https://github.com/ceph/ceph-ansible/commit/68eb850b) - tests: add more verbosity in testinfra (Guillaume Abrioux)
* [f68936ca](https://github.com/ceph/ceph-ansible/commit/f68936ca) - tests: fix *_has_correct_value tests (Guillaume Abrioux)
* [481c1445](https://github.com/ceph/ceph-ansible/commit/481c1445) - tests: add more nodes in ooo testing scenario (Guillaume Abrioux)
* [bea4027f](https://github.com/ceph/ceph-ansible/commit/bea4027f) - common: start firewalld if configure_firewall (Sébastien Han)
* [a9ed3579](https://github.com/ceph/ceph-ansible/commit/a9ed3579) - mon/osd: bump container memory limit (Sébastien Han)
* [21894655](https://github.com/ceph/ceph-ansible/commit/21894655) - tests: keep same ceph release during handlers/idempotency test (Guillaume Abrioux)
* [51cf3b7f](https://github.com/ceph/ceph-ansible/commit/51cf3b7f) - client: try to kill dummy container only on first client node (Guillaume Abrioux)
* [9ce81ae8](https://github.com/ceph/ceph-ansible/commit/9ce81ae8) - ceph-mds: do not enable multimds on jewel (Patrick Donnelly)
* [752781e2](https://github.com/ceph/ceph-ansible/commit/752781e2) - core: make ansible pinning to latest ansible 2.4 (Guillaume Abrioux)
* [2e841273](https://github.com/ceph/ceph-ansible/commit/2e841273) - common: ability to enable/disable fw configuration (Sébastien Han)
* [bbb86913](https://github.com/ceph/ceph-ansible/commit/bbb86913) - tests: increase memory to 1024Mb for centos7_cluster scenario (Guillaume Abrioux)
* [a351b087](https://github.com/ceph/ceph-ansible/commit/a351b087) - tests: set CEPH_DOCKER_IMAGE_TAG when ceph release is luminous (Guillaume Abrioux)
* [a4ad2eb2](https://github.com/ceph/ceph-ansible/commit/a4ad2eb2) - validate: be more explicit with error msg when notario isn't installed (Guillaume Abrioux)
* [3a075684](https://github.com/ceph/ceph-ansible/commit/3a075684) - ceph-osd: set 'openstack_keys_tmp' only when 'openstack_config' is defined. (Konstantin Shalygin)
* [1a610df0](https://github.com/ceph/ceph-ansible/commit/1a610df0) - Fix to run secure cluster only once in a run (Vishal Kanaujia)
* [6035978e](https://github.com/ceph/ceph-ansible/commit/6035978e) - test: only on containerized iscsi (Sébastien Han)
* [090ecff9](https://github.com/ceph/ceph-ansible/commit/090ecff9) - client: keyrings aren't created when single client node (Guillaume Abrioux)
* [315ab08b](https://github.com/ceph/ceph-ansible/commit/315ab08b) - contrib: fix generate group_vars samples (Sébastien Han)
* [20c8065e](https://github.com/ceph/ceph-ansible/commit/20c8065e) - ceph-iscsi: rename group iscsi_gws (Sébastien Han)
* [c00fb124](https://github.com/ceph/ceph-ansible/commit/c00fb124) - ci: add functionnal tests for iscsi (Sébastien Han)
* [fdeee9eb](https://github.com/ceph/ceph-ansible/commit/fdeee9eb) - site-docker: add iscsi role (Sébastien Han)
* [5ff2f03e](https://github.com/ceph/ceph-ansible/commit/5ff2f03e) - ci: add iscsi test (Sébastien Han)
* [91bf53ee](https://github.com/ceph/ceph-ansible/commit/91bf53ee) - ceph-iscsi: support for containerize deployment (Sébastien Han)
* [8363ab43](https://github.com/ceph/ceph-ansible/commit/8363ab43) - pin version of ansible to 2.4 in requirements.txt (Andrew Schoen)
* [4b5cac2e](https://github.com/ceph/ceph-ansible/commit/4b5cac2e) - tests: increase ssh timeout and retries in ansible.cfg (Andrew Schoen)
* [28d21b4e](https://github.com/ceph/ceph-ansible/commit/28d21b4e) - tests: update ooo inventory hostfile (Guillaume Abrioux)
* [8a653cac](https://github.com/ceph/ceph-ansible/commit/8a653cac) - client: add a default value for keyring file (Guillaume Abrioux)
* [5eacc8f8](https://github.com/ceph/ceph-ansible/commit/5eacc8f8) - tests: add a dummy value for 'dev' release (Guillaume Abrioux)
* [24ef47b0](https://github.com/ceph/ceph-ansible/commit/24ef47b0) - ceph-common: move firewall checks after package installation (Andrew Schoen)
* [7b156deb](https://github.com/ceph/ceph-ansible/commit/7b156deb) - client: use dummy created container when there is no mon in inventory (Guillaume Abrioux)
* [c94ada69](https://github.com/ceph/ceph-ansible/commit/c94ada69) - tests: improve mds tests (Guillaume Abrioux)
* [433ecc7c](https://github.com/ceph/ceph-ansible/commit/433ecc7c) - osd: copy openstack keys over to all mon (Guillaume Abrioux)
* [232a16d7](https://github.com/ceph/ceph-ansible/commit/232a16d7) - rolling_update: fix facts gathering delegation (Guillaume Abrioux)
* [91f9da53](https://github.com/ceph/ceph-ansible/commit/91f9da53) - change max_mds default to 1 (Patrick Donnelly)
* [f0cd4b06](https://github.com/ceph/ceph-ansible/commit/f0cd4b06) - tests: skip disabling fastest mirror detection on atomic host (Guillaume Abrioux)
* [47276764](https://github.com/ceph/ceph-ansible/commit/47276764) - tests: fix rgw tests (Guillaume Abrioux)
* [2cdb0d18](https://github.com/ceph/ceph-ansible/commit/2cdb0d18) - Syntax error fix in rgw multisite role (Vishal Kanaujia)
* [41b4632a](https://github.com/ceph/ceph-ansible/commit/41b4632a) - test: do not always copy admin key (Sébastien Han)
* [2cf06b51](https://github.com/ceph/ceph-ansible/commit/2cf06b51) - rgw: refact rgw pools creation (Guillaume Abrioux)
* [1f3c9ce4](https://github.com/ceph/ceph-ansible/commit/1f3c9ce4) - Use python instead of python2 (Ha Phan)
* [db50aec1](https://github.com/ceph/ceph-ansible/commit/db50aec1) - ceph-common: add firewall rules for ceph-mgr (Sébastien Han)
* [08d94324](https://github.com/ceph/ceph-ansible/commit/08d94324) - Rolling upgrades should use norebalance flag for OSDs (Vishal Kanaujia)
* [493f615e](https://github.com/ceph/ceph-ansible/commit/493f615e) - ceph-defaults: Enable local epel repository (Erwan Velu)
* [600e1e2c](https://github.com/ceph/ceph-ansible/commit/600e1e2c) - rgws: renames create_pools variable with rgw_create_pools. (jtudelag)
* [8704144e](https://github.com/ceph/ceph-ansible/commit/8704144e) - Adds RGWs pool creation to containerized installation. (jtudelag)
* [aae37b44](https://github.com/ceph/ceph-ansible/commit/aae37b44) - mons: move set_fact of openstack_keys in ceph-osd (Guillaume Abrioux)
* [c2423e2c](https://github.com/ceph/ceph-ansible/commit/c2423e2c) - ceph-defaults: add the nautilus 14.x entry to ceph_release_num (Andrew Schoen)
* [9d5265fe](https://github.com/ceph/ceph-ansible/commit/9d5265fe) - osds: wait for osds to be up before creating pools (Guillaume Abrioux)
* [0b67f42f](https://github.com/ceph/ceph-ansible/commit/0b67f42f) - Makefile: followup on #2585 (Guillaume Abrioux)
* [c68126d6](https://github.com/ceph/ceph-ansible/commit/c68126d6) - mdss: do not make pg_num a mandatory params (Guillaume Abrioux)
* [34e646e7](https://github.com/ceph/ceph-ansible/commit/34e646e7) - osds: do not set docker_exec_cmd fact (Guillaume Abrioux)
* [6f489015](https://github.com/ceph/ceph-ansible/commit/6f489015) - tests: fix broken symlink (Guillaume Abrioux)
* [34f70428](https://github.com/ceph/ceph-ansible/commit/34f70428) - tests: resize root partition when atomic host (Guillaume Abrioux)
* [1fca8277](https://github.com/ceph/ceph-ansible/commit/1fca8277) - CONTRIBUTING.md: Initial release (Erwan Velu)
* [98cb6ed8](https://github.com/ceph/ceph-ansible/commit/98cb6ed8) - tests: avoid yum failures (Guillaume Abrioux)
* [144b2fce](https://github.com/ceph/ceph-ansible/commit/144b2fce) - python-netaddr is required to generate ceph.conf (Ha Phan)
* [e91648a7](https://github.com/ceph/ceph-ansible/commit/e91648a7) - rolling_update: add role ceph-iscsi-gw (Sébastien Han)
* [2890b57c](https://github.com/ceph/ceph-ansible/commit/2890b57c) - Add privilege escalation to iscsi purge tasks (Paul Cuzner)
* [608ea947](https://github.com/ceph/ceph-ansible/commit/608ea947) - mds: move mds fs pools creation (Guillaume Abrioux)
* [1c084efb](https://github.com/ceph/ceph-ansible/commit/1c084efb) - rgw: container add option to configure multi-site zone (Sébastien Han)
* [82884801](https://github.com/ceph/ceph-ansible/commit/82884801) - playbook: follow up on #2553 (Guillaume Abrioux)
* [3c32280c](https://github.com/ceph/ceph-ansible/commit/3c32280c) - group_vars: resync group_vars (Sébastien Han)
* [3a0e168a](https://github.com/ceph/ceph-ansible/commit/3a0e168a) - mdss: move cephfs pools creation in ceph-mds (Guillaume Abrioux)
* [a10e73d7](https://github.com/ceph/ceph-ansible/commit/a10e73d7) - tests: move cephfs_pools variable (Guillaume Abrioux)
* [564a662b](https://github.com/ceph/ceph-ansible/commit/564a662b) - osds: move openstack pools creation in ceph-osd (Guillaume Abrioux)
* [f8260119](https://github.com/ceph/ceph-ansible/commit/f8260119) - defaults: resync sample files with actual defaults (Guillaume Abrioux)
* [43e96c1f](https://github.com/ceph/ceph-ansible/commit/43e96c1f) - ceph-radosgw: disable NSS PKI db when SSL is disabled (Luigi Toscano)
* [bf9593bc](https://github.com/ceph/ceph-ansible/commit/bf9593bc) - rhcs: bump version to 3.0 for stable 3.1 (Sébastien Han)
* [ef5f52b1](https://github.com/ceph/ceph-ansible/commit/ef5f52b1) - Skip GPT header creation for lvm osd scenario (Vishal Kanaujia)
* [da5b1040](https://github.com/ceph/ceph-ansible/commit/da5b1040) - rolling_update: fix get fsid for containers (Sébastien Han)
* [c7e269fc](https://github.com/ceph/ceph-ansible/commit/c7e269fc) - Fix restarting OSDs twice during a rolling update. (Subhachandra Chandra)
* [4d1338b4](https://github.com/ceph/ceph-ansible/commit/4d1338b4) - validate: split schema for lvm osd scenario per objecstore (Alfredo Deza)
* [a9ad8eb5](https://github.com/ceph/ceph-ansible/commit/a9ad8eb5) - ceph-validate: do not check ceph version on dev or rhcs installs (Andrew Schoen)
* [9801bde4](https://github.com/ceph/ceph-ansible/commit/9801bde4) - purge_cluster: fix dmcrypt purge (Guillaume Abrioux)
* [e7d02a50](https://github.com/ceph/ceph-ansible/commit/e7d02a50) - ceph-validate: move system checks from ceph-common to ceph-validate (Andrew Schoen)
* [62c34e3c](https://github.com/ceph/ceph-ansible/commit/62c34e3c) - set the python-notario version to >= 0.0.13 in ceph-ansible.spec.in (Andrew Schoen)
* [c40ed1c6](https://github.com/ceph/ceph-ansible/commit/c40ed1c6) - site.yml: combine validate play with fact gathering play (Andrew Schoen)
* [fd7bb16e](https://github.com/ceph/ceph-ansible/commit/fd7bb16e) - docs: explain the ceph-validate role and how it validates configuration (Andrew Schoen)
* [cf2868f0](https://github.com/ceph/ceph-ansible/commit/cf2868f0) - validate: support validation of osd_auto_discovery (Andrew Schoen)
* [8b6097e5](https://github.com/ceph/ceph-ansible/commit/8b6097e5) - validate: remove objectstore from osd options schema (Andrew Schoen)
* [645f61c3](https://github.com/ceph/ceph-ansible/commit/645f61c3) - ceph-defaults: remove backwards compat for containerized_deployment (Andrew Schoen)
* [c65ea7e9](https://github.com/ceph/ceph-ansible/commit/c65ea7e9) - site-docker: validate config before pulling container images (Andrew Schoen)
* [890e265f](https://github.com/ceph/ceph-ansible/commit/890e265f) - validate: adds a CEPH_RELEASES constant (Andrew Schoen)
* [d30a99c3](https://github.com/ceph/ceph-ansible/commit/d30a99c3) - validate: add support for containerized_deployment (Andrew Schoen)
* [5d64eb79](https://github.com/ceph/ceph-ansible/commit/5d64eb79) - validate: show an error and stop the playbook when notario is missing (Andrew Schoen)
* [62d6f2d8](https://github.com/ceph/ceph-ansible/commit/62d6f2d8) - site-docker.yml: add config validation play (Andrew Schoen)
* [a80a109a](https://github.com/ceph/ceph-ansible/commit/a80a109a) - site.yml: the validation play must use become: true (Andrew Schoen)
* [12bdb8ef](https://github.com/ceph/ceph-ansible/commit/12bdb8ef) - docs: add instructions for installing ansible and notario (Andrew Schoen)
* [ef48ed4e](https://github.com/ceph/ceph-ansible/commit/ef48ed4e) - adds a requiremnts.txt file for the project (Andrew Schoen)
* [dea1ea93](https://github.com/ceph/ceph-ansible/commit/dea1ea93) - tests: use notario>=0.0.13 when testing (Andrew Schoen)
* [f84c2ba2](https://github.com/ceph/ceph-ansible/commit/f84c2ba2) - ceph-defaults: fix failing tasks when osd_scenario was not set correctly (Andrew Schoen)
* [91f65e24](https://github.com/ceph/ceph-ansible/commit/91f65e24) - validate: improve error messages when config fails validation (Andrew Schoen)
* [d83bdce8](https://github.com/ceph/ceph-ansible/commit/d83bdce8) - site.yml: abort playbook when it fails during config validation (Andrew Schoen)
* [1f15a81c](https://github.com/ceph/ceph-ansible/commit/1f15a81c) - ceph-defaults: move cephfs vars from the ceph-mon role (Andrew Schoen)
* [ffe05872](https://github.com/ceph/ceph-ansible/commit/ffe05872) - validate: only validate cephfs_pools on mon nodes (Andrew Schoen)
* [760a1afc](https://github.com/ceph/ceph-ansible/commit/760a1afc) - validate: only validate osd config options on osd hosts (Andrew Schoen)
* [4325ccc8](https://github.com/ceph/ceph-ansible/commit/4325ccc8) - validate: only check mon and rgw config if the node is in those groups (Andrew Schoen)
* [b2b905f4](https://github.com/ceph/ceph-ansible/commit/b2b905f4) - site.yml: remove the testing task that fails the playbook run (Andrew Schoen)
* [48c2a4fd](https://github.com/ceph/ceph-ansible/commit/48c2a4fd) - validate: check rados config options (Andrew Schoen)
* [377fe81c](https://github.com/ceph/ceph-ansible/commit/377fe81c) - validate: make sure ceph_stable_release is set to the correct value (Andrew Schoen)
* [ba7f09c0](https://github.com/ceph/ceph-ansible/commit/ba7f09c0) - ceph-validate: move var checks from ceph-common into this role (Andrew Schoen)
* [32bac6b4](https://github.com/ceph/ceph-ansible/commit/32bac6b4) - ceph-validate: move var checks from ceph-osd into this role (Andrew Schoen)
* [29a9dffc](https://github.com/ceph/ceph-ansible/commit/29a9dffc) - ceph-validate: move ceph-mon config checks into this role (Andrew Schoen)
* [d87a3234](https://github.com/ceph/ceph-ansible/commit/d87a3234) - adds a new ceph-validate role (Andrew Schoen)
* [692ab267](https://github.com/ceph/ceph-ansible/commit/692ab267) - validate: validate osd_scenarios (Andrew Schoen)
* [4baa8389](https://github.com/ceph/ceph-ansible/commit/4baa8389) - validate: check monitor options (Andrew Schoen)
* [4008d700](https://github.com/ceph/ceph-ansible/commit/4008d700) - site.yml: move validate task to it's own play (Andrew Schoen)
* [9f68dad2](https://github.com/ceph/ceph-ansible/commit/9f68dad2) - validate: first pass at validating the install options (Andrew Schoen)
* [0ace2e95](https://github.com/ceph/ceph-ansible/commit/0ace2e95) - site: add validation task (Alfredo Deza)
* [86a32071](https://github.com/ceph/ceph-ansible/commit/86a32071) - rpm: add python-notario as a dependency for validation (Alfredo Deza)
* [e33608ec](https://github.com/ceph/ceph-ansible/commit/e33608ec) - library: add a placeholder module for the validate action plugin (Alfredo Deza)
* [36dc7c78](https://github.com/ceph/ceph-ansible/commit/36dc7c78) - plugins create an action plugin for validation using notario (Alfredo Deza)
* [2f43e9da](https://github.com/ceph/ceph-ansible/commit/2f43e9da) - defaults: restart_osd_daemon unit spaces (Sébastien Han)
* [ed050bf3](https://github.com/ceph/ceph-ansible/commit/ed050bf3) - Do nothing when mgr module is in good state (Michael Vollman)
* [415dc0a2](https://github.com/ceph/ceph-ansible/commit/415dc0a2) - take-over: fix bug when trying to override variable (Guillaume Abrioux)
* [fa8e2e75](https://github.com/ceph/ceph-ansible/commit/fa8e2e75) - Adding mgr_vms variable (Ha Phan)
* [f45662e2](https://github.com/ceph/ceph-ansible/commit/f45662e2) - Fix template reference for ganesha.conf (Andy McCrae)
* [49a47124](https://github.com/ceph/ceph-ansible/commit/49a47124) - switch: disable ceph-disk units (Sébastien Han)
* [a9247c4d](https://github.com/ceph/ceph-ansible/commit/a9247c4d) - purge_cluster: wipe all partitions (Guillaume Abrioux)
* [9cad113e](https://github.com/ceph/ceph-ansible/commit/9cad113e) - purge_cluster: fix bug when building device list (Guillaume Abrioux)
* [d80a871a](https://github.com/ceph/ceph-ansible/commit/d80a871a) - rolling_update: move osd flag section (Sébastien Han)
* [fcea5684](https://github.com/ceph/ceph-ansible/commit/fcea5684) - Makefile: add "make tag" command (Ken Dreyer)
* [a55ff1cf](https://github.com/ceph/ceph-ansible/commit/a55ff1cf) - contrib: check for lt 3 arguments (Sébastien Han)
* [8ba4ffa7](https://github.com/ceph/ceph-ansible/commit/8ba4ffa7) - contruib: ability to set a prefix on backport script (Sébastien Han)
* [226f80c2](https://github.com/ceph/ceph-ansible/commit/226f80c2) - Install packages as a list (Andy McCrae)
* [f7498308](https://github.com/ceph/ceph-ansible/commit/f7498308) - mon: refactor of mgr key fetching (Guillaume Abrioux)
* [926be51b](https://github.com/ceph/ceph-ansible/commit/926be51b) - mgr: delete copy_configs.yml (containerized) (Guillaume Abrioux)
* [1b4c3f29](https://github.com/ceph/ceph-ansible/commit/1b4c3f29) - rolling_update: fix dest path for mgr keys fetching (Guillaume Abrioux)
* [3b89f1bf](https://github.com/ceph/ceph-ansible/commit/3b89f1bf) - rolling_update: get fsid in mgr pre_task (Guillaume Abrioux)
* [52fc8a03](https://github.com/ceph/ceph-ansible/commit/52fc8a03) - rolling_update: move mgr key creation (Sébastien Han)
* [e810fb21](https://github.com/ceph/ceph-ansible/commit/e810fb21) - Revert "mon: fix mgr keyring creation when upgrading from jewel" (Sébastien Han)
* [a145caf9](https://github.com/ceph/ceph-ansible/commit/a145caf9) - iscsi-gw: fix issue when trying to mask target (Guillaume Abrioux)
* [8c7c11b7](https://github.com/ceph/ceph-ansible/commit/8c7c11b7) - iscsi: add python-rtslib repository (Sébastien Han)
* [08a2b58d](https://github.com/ceph/ceph-ansible/commit/08a2b58d) - Allow os_tuning_params to overwrite fs.aio-max-nr (Andy McCrae)
* [9a9aa247](https://github.com/ceph/ceph-ansible/commit/9a9aa247) - Makefile: bail out on unknown Git tag formats (Ken Dreyer)
* [f60b049a](https://github.com/ceph/ceph-ansible/commit/f60b049a) - client: remove default value for pg_num in pools creation (Guillaume Abrioux)
* [0b803fc1](https://github.com/ceph/ceph-ansible/commit/0b803fc1) - contrib: update backport script to reflect stable branch (Sébastien Han)
* [26f6a650](https://github.com/ceph/ceph-ansible/commit/26f6a650) - adds missing state needed to upgrade nfs-ganesha (Gregory Meno)