@ECHO OFF

IF (%6)==() GOTO Usage
IF NOT (%7)==() (
	set ALIAS=%7
) else (
	set ALIAS=rhevm
)

copy cert.template cert.conf
echo C = %2% >> cert.conf
echo O = %3% >> cert.conf
echo CN = %4% >> cert.conf


if %1 EQU 1 (
	keytool -certreq -keystore .\.keystore -storepass %6 -alias %ALIAS% -file requests\%5.req
) else (
	openssl req -newkey rsa:1024 -config cert.conf -out requests\%5.req -keyout keys\%5.pem
)

EXIT /B %ERRORLEVEL%

:Usage
ECHO CreateReq.bat - Generate a new keypair and certificate request
ECHO Usage: 
ECHO     CreateReq [useKeyStore] [Country] [Organization] [Name] [Filename] [Pass] [Alias]
ECHO Where:
ECHO     KeyStore     = Store keys in keystore: 0 or 1
ECHO     Country      = 2 Letters country code
ECHO     Organization = Organization name string
ECHO     Name         = Certificate Subject Name
ECHO     Filename     = name of keys and request files (must match, script add .pem and .req respectivly)
ECHO     Pass         = Keystore password
ECHO     Alias        = Certificate alias in keystore
Exit /B 1