PRINT 'Processing sync_sp.sql'

SET NOCOUNT ON	
set ANSI_NULLS ON
set QUOTED_IDENTIFIER ON

go


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Sync_update_config_values_xml')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].Sync_update_config_values_xml AS RETURN')
END
GO


ALTER PROCEDURE [dbo].[Sync_update_config_values_xml]    
@xml xml,
@version nvarchar(40)
AS
BEGIN
	BEGIN TRY
		BEGIN TRAN
			declare @sql nvarchar(max)
            declare @parameterList nvarchar(max)
			SET @parameterList = '@xml xml OUTPUT'
			set @sql = '
				INSERT dbo.vdc_options (option_name, option_value, version) (
				SELECT  t.c.[value](''@key'',''nvarchar(100)'') as [Name],
					 t.c.[value](''@value'', ''nvarchar(max)'')as [Value],
                     ''' + @version + '''
				FROM @xml.nodes(''Versions/Version[@name="' + @version + '"]/Fields/FieldGroup/Field'')as t(c))'
			EXECUTE sp_executesql @sql, @parameterList, @xml = @xml OUTPUT
		COMMIT TRAN
    END TRY

    BEGIN CATCH
		ROLLBACK TRAN
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    
GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Sync_update_config_values')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].Sync_update_config_values AS RETURN')
END
GO

ALTER PROCEDURE [dbo].[Sync_update_config_values]    
@filname nvarchar(255)
AS
BEGIN

	BEGIN TRY

		BEGIN TRAN
			DECLARE @xml XML, @sql nvarchar(1000), @ParameterList nvarchar(100)
			 SET @ParameterList = '@xml xml OUTPUT'
			declare @version nvarchar(40)

			-- delete all values from the table
			DELETE from dbo.vdc_options

			set @sql = 'SELECT @xml = BulkColumn FROM OPENROWSET
			(BULK ''' + @filname+ ''', SINGLE_BLOB) AS CustomerXML'

			--Convert file content to a xml variable
			EXECUTE sp_executesql @sql, @ParameterList, @xml = @xml OUTPUT			
			DECLARE c1 CURSOR 
			FOR
					SELECT  t.c.[value]('@name','nvarchar(40)') as Version
					FROM @xml.nodes('/Versions/Version')as t(c)
			OPEN c1

			FETCH NEXT FROM c1
			INTO @version

			WHILE @@FETCH_STATUS = 0
			BEGIN  
				EXECUTE Sync_update_config_values_xml @xml, @version
				FETCH NEXT FROM c1
				INTO @version            
			END
			CLOSE c1
			DEALLOCATE c1	
		
		COMMIT TRAN
    END TRY

    BEGIN CATCH
		ROLLBACK TRAN
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    
GO
