using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using VdcCommon.BusinessEntities;

namespace org.ovirt.engine.ui.uicommon
{
	/// <summary>
	/// Contains extension methods for some common operation.
	/// </summary>
	public static class Extensions
	{
		/// <summary>
		/// Separates a selected strings (by selector expression) with a separator character.
		/// </summary>
		//public static string Separate<TSource>(this IEnumerable<TSource> source, char separator, Func<TSource, string> selector)
		//{
		//    string str = source.Select(selector).Aggregate(String.Empty, (c, d) => c += d + separator);
		//    if (!String.IsNullOrEmpty(str))
		//    {
		//        str = str.Remove(str.Length - 1);
		//    }

		//    return str;
		//}


		/// <summary>
		/// Flattens an exception tree, exception itself and all inner ones.
		/// </summary>
		public static IEnumerable<Exception> Flatten(Exception source)
		{
			List<Exception> result = new List<Exception>();
			Exception ex = source;

			//TODO: Can't convert to Java.
			//while (ex != null)
			//{
			//    result.Add(ex);
			//    ex = ex.InnerException;
			//}

			result.Add(ex);

			return result;
		}


		/// <summary>
		/// Applies a specific action to each element of enumeration.
		/// Pay attention! Enumeration is done on the source itself
		/// rather than on a new instance as it done in case of ToList.ForEach
		/// When using this method don't change enumeration by adding of removing
		/// elements.
		/// </summary>
		//public static void Each<T>(this IEnumerable<T> source, Action<T> action)
		//{
		//    foreach (var item in source)
		//    {
		//        action(item);
		//    }
		//}


		//public static void EachRecursive<T>(this T source, Func<T, IEnumerable<T>> childrenSelector, Action<T, IEnumerable<T>> action)
		//{
		//    var children = childrenSelector(source);
		//    action(source, children);

		//    if (children != null)
		//    {
		//        children.Each(a => a.EachRecursive(childrenSelector, action));
		//    }
		//}


		/// <summary>
		/// Returns a friendly version, for example 4.4.x.x returned as 2.1.x.x.
		/// </summary>
		public static Version GetFriendlyVersion(Version source)
		{
			if (source != null)
			{
				int major = source.Major;
				int minor = source.Minor;

				if (major == 4 && minor == 4)
				{
					major = 2;
					minor = 1;
				}
				else if (major == 4 && minor == 5)
				{
					major = 2;
					minor = 2;
				}
                else if (major == 4 && minor == 9)
                {
                    major = 3;
                    minor = 0;
                }
                if(source.Build == -1)
                {
                    return new Version(major,minor);
                }
                if (source.Revision == -1)
                {
                    return new Version(major, minor, source.Build);
                }
				return new Version(major, minor, source.Build, source.Revision);
			}
			return new Version();
		}

        /// <summary>
        /// Sort by comparer created at runtime
        /// </summary>
        /// <typeparam name="TSource"></typeparam>
        /// <typeparam name="TValue"></typeparam>
        /// <param name="source"></param>
        /// <param name="selector"></param>
		//public static void Sort<TSource, TValue>(this List<TSource> source,
		//    Func<TSource, TValue> selector)
		//{
		//    var comparer = Comparer<TValue>.Default;
		//    source.Sort((a, b) => comparer.Compare(selector(a), selector(b)));
		//}       
	}
}
