using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Collections.Specialized;
using System.Text;
using org.ovirt.engine.ui.uicompat;
using VdcCommon.BusinessEntities;
using VdcCommon.Interfaces;
using VdcFrontend;
using System.Collections;
using System.ComponentModel;

namespace org.ovirt.engine.ui.uicommon.models.events
{
	public class AlertListModel : SearchableListModel
	{
		private ObservableCollection<IVdcQueryable> items;

		#region Events

		//		public event EventHandler NewAlert = delegate { };

		public static EventDefinition NewAlertEventDefinition;
		public Event NewAlertEvent { get; private set; }

		#endregion

		#region Properties

		public new IList Items
		{
			get { return (IList)base.Items; }
			set { base.Items = value; }
		}

		private bool hasAlerts;
		public bool HasAlerts
		{
			get { return hasAlerts; }
			private set
			{
				if (hasAlerts != value)
				{
					hasAlerts = value;
					OnPropertyChanged(new PropertyChangedEventArgs("HasAlerts"));
				}
			}
		}

		private AuditLog lastAlert;
		public AuditLog LastAlert
		{
			get { return lastAlert; }
			private set
			{
				if (lastAlert != value)
				{
					lastAlert = value;
					OnPropertyChanged(new PropertyChangedEventArgs("LastAlert"));
				}
			}
		}

		#endregion

		static AlertListModel()
		{
			NewAlertEventDefinition = new EventDefinition("NewAlert", typeof(AlertListModel));
		}

		public AlertListModel()
		{
			NewAlertEvent = new Event(NewAlertEventDefinition);

			DefaultSearchString = "Events: severity=alert";
			SearchString = DefaultSearchString;

			SearchNextPageCommand.IsAvailable = true;
			SearchPreviousPageCommand.IsAvailable = true;

			UpdateTitle();
		}

		protected override void AsyncSearch()
		{
			base.AsyncSearch();

			Items = new ObservableCollection<IVdcQueryable>();

			AsyncResult = Frontend.RegisterSearch(SearchString, SearchType.AuditLog, SearchPageSize);
			items = AsyncResult.Data;

			IProvideCollectionChangedEvent notifier = items as IProvideCollectionChangedEvent;
			if (notifier != null)
			{
				notifier.CollectionChangedEvent.addListener(this);
			}
		}

		internal override void EnsureAsyncSearchStopped()
		{
			base.EnsureAsyncSearchStopped();

			if (AsyncResult != null && !AsyncResult.Id.Equals(Guid.Empty))
			{
				IProvideCollectionChangedEvent notifier = items as IProvideCollectionChangedEvent;
				if (notifier != null)
				{
					notifier.CollectionChangedEvent.removeListener(this);
				}
			}
		}

		public override void eventRaised(Event ev, object sender, EventArgs args)
		{
			base.eventRaised(ev, sender, args);

			if (ev.Equals(ProvideCollectionChangedEvent.Definition))
			{
				items_CollectionChanged(sender, (NotifyCollectionChangedEventArgs)args);
			}
		}

		void items_CollectionChanged(object sender, NotifyCollectionChangedEventArgs e)
		{
			base.ItemsCollectionChanged(sender, e);

			if (e.Action == NotifyCollectionChangedAction.Remove)
			{
				List<AuditLog> items = Linq.Cast<AuditLog>(Items);

				//var itemsToRemove =
				//	e.OldItems
				//	.Cast<AuditLog>()
				//	.Select(a => items.FirstOrDefault(b => b.audit_log_id == a.audit_log_id))
				//	.ToList();
				List<AuditLog> itemsToRemove = new List<AuditLog>();
				foreach (object item in e.OldItems)
				{
					AuditLog a = (AuditLog)item;
					long i = default(long);
					foreach (AuditLog b in items)
					{
						if (b.audit_log_id == a.audit_log_id)
						{
							i = b.audit_log_id;
							break;
						}
					}

					if (a.audit_log_id == i)
					{
						itemsToRemove.Add(a);
					}
				}

				//itemsToRemove.Each(a => Items.Remove(a));
				foreach (AuditLog a in itemsToRemove)
				{
					Items.Remove(a);
				}
			}

			if (e.Action == NotifyCollectionChangedAction.Add)
			{
				foreach (object item in e.NewItems)
				{
					AuditLog a = (AuditLog)item;
					if (Items.Count == 100)
					{
						Items.RemoveAt(Items.Count - 1);
					}

					//var lastItem = Items.Count > 0 ? Items[Items.Count - 1] as AuditLog : null;
					AuditLog lastItem = Items.Count > 0 ? (AuditLog)Items[Items.Count - 1] : null;
					if (lastItem != null && lastItem.audit_log_id < a.audit_log_id)
					{
						Items.Insert(0, a);
						//NewAlert(this, EventArgs.Empty);
						NewAlertEvent.raise(this, EventArgs.Empty);
					}
					else
					{
						Items.Add(a);
					}
				}

				LastAlert = Items.Count > 0 ? (AuditLog)Items[0] : null;
			}

			UpdateTitle();
		}

		private void UpdateTitle()
		{
			Title = String.Format("{0} Alerts", (Items == null || Items.Count == 0) ? "No" : Convert.ToString(Items.Count));
			HasAlerts = Items != null && Items.Count > 0;
		}
	}
}
