@echo off

if "%1%" == "-h" goto Syntax
if "%1%" == "--help" goto Syntax

SET sqlServer=%1%
if "%1%" == "" set sqlServer=.\sqlexpress

SET dbname=%2%
if "%2%" == "" set dbname=rhevm 

for %%v in (%0) do set MyPath=%%~dpv
pushd "%MyPath%"

SET user=%3%
if "%3%" == "" set user=sa

SET pass=%4%
if "%4%" == "" set pass=RHEVMadmin2009!

SET debug=%5%
if "%5%" == "" set debug='true'

echo server - %sqlServer%
echo dbname - %dbname%

echo updating options ...
sqlcmd  -S %sqlServer% -U %user% -P %pass% -d %dbname%  -i rhevxconf.sql
echo Done.

popd

goto:EOF

:Syntax
echo rhevxconf.cmd [server] [dbname] [user] [pass] [debug]
echo     server - the sql server to access (default = .\sqlexpress)
echo     dbname - the database name to access/create (default = rhevm)
echo	 user - the database administrator user name
echo	 pass - the database administrator password
echo	 debug - true/false enables storing of exception data in DB
goto:EOF