using VdcCommon.BusinessEntities;

namespace SearchBackend
{
    class PoolConditionFieldAutoCompleter :BaseConditionFieldAutoCompleter
    {
        public PoolConditionFieldAutoCompleter()
        {
            //Building the basic vervs Dict
            mVerbs.Add("NAME", "NAME");
            mVerbs.Add("DESCRIPTION", "DESCRIPTION");
            mVerbs.Add("TYPE", "TYPE");
            
            //Building the autoCompletion Dict
            buildCompletions();
            //Building the types dict
            TypeDictionary.Add("NAME", typeof(string));
            TypeDictionary.Add("DESCRIPTION", typeof(string));
            TypeDictionary.Add("TYPE", typeof(VmPoolType));
            
            //building the ColumnName Dict
            mColumnNameDict.Add("NAME", "vm_pool_name");
            mColumnNameDict.Add("DESCRIPTION", "vm_pool_description");
            mColumnNameDict.Add("TYPE", "vm_pool_type");
            
            //Building the validation dict
            buildBasicValidationTable();
        }

        public override IAutoCompleter getFieldRelationshipAutoCompleter(string fieldName)
        {
			 IAutoCompleter retval;
			 switch (fieldName)
			 {
				 default:
					 retval = new StringConditionRelationAutoCompleter();
					 break;
			 }
            
            return retval;
        }

        public override IConditionValueAutoCompleter getFieldValueAutoCompleter(string fieldName)
        {
            IConditionValueAutoCompleter retval = null;
            switch (fieldName)
            {
                case "TYPE":
                    retval = new EnumValueAutoCompleter(typeof(VmPoolType));
                    break;
                default:
                    break;
            }
            return retval;
        }

        

    }
    
}
