using System;
using System.Text;
using System.Threading;
using System.Windows.Threading;

namespace org.ovirt.engine.ui.uicompat
{
	//Provides a simplified way to do a background work on a UI thread
	//with ability to make a call on last.
	public class Task
	{
		private readonly Thread thread;
		private readonly TaskContext context;
		private readonly ITaskTarget target;


		public static Task Create(ITaskTarget target, object state)
		{
			return new Task(target, state);
		}

		private Task(ITaskTarget target, object state)
		{
			//TODO: Ensure that task is being created on a UI thread.

			this.target = target;
			context = new TaskContext(Dispatcher.CurrentDispatcher, state);

			thread =
				new Thread(() => target.run(context))
				{
					Name = "Thread for task"
				};
		}

		public void Run()
		{
			thread.Start();
		}

		/// <summary>
		/// Invokes method directly on a UI thread without creating thread.
		/// </summary>
		public void InvokeUIThread()
		{
			context.InvokeUIThread(target, context.State);
		}
	}
}
