﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Diagnostics;
using System.Windows.Input;

namespace UI.WPFClient
{
	public class DropDownButton : Button
	{
		#region Commands

		public static RoutedCommand DropDownCommand = new RoutedCommand("DropDown", typeof(DropDownButton));

		#endregion

		#region Properties

		public ContextMenu DropMenu
		{
			get { return (ContextMenu)GetValue(DropMenuProperty); }
			set { SetValue(DropMenuProperty, value); }
		}
		public static readonly DependencyProperty DropMenuProperty =
			DependencyProperty.Register("DropMenu", typeof(ContextMenu), typeof(DropDownButton), new UIPropertyMetadata(null, DropMenuChanged));

		private static void DropMenuChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
		{
			DropDownButton instance = (DropDownButton)d;
			instance.DropMenuChanged();
		}


		public bool IsDropDownOnly
		{
			get { return (bool)GetValue(IsDropDownOnlyProperty); }
			set { SetValue(IsDropDownOnlyProperty, value); }
		}
		public static readonly DependencyProperty IsDropDownOnlyProperty =
			DependencyProperty.Register("IsDropDownOnly", typeof(bool), typeof(DropDownButton), new UIPropertyMetadata(true));

		#endregion

		public DropDownButton()
		{
			CommandBindings.Add(new CommandBinding(DropDownCommand, DropDownExecuted));
		}

		private void DropDownExecuted(object sender, ExecutedRoutedEventArgs e)
		{
			DropDown();
			e.Handled = true;
		}

		private void DropMenuChanged()
		{
			if (DropMenu != null)
			{
				DropMenu.PlacementTarget = this;
			}
		}

		protected override void OnClick()
		{
			base.OnClick();

			if (IsDropDownOnly)
			{
				DropDown();
			}
		}

		private void DropDown()
		{
			if (DropMenu != null)
			{
				DropMenu.IsOpen = !DropMenu.IsOpen;
			}
		}
	}
}
