PRINT 'Processing vm_templates_sp.sql'

----------------------------------------------------------------
-- [dbo].[vm_templates] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'InsertVmTemplate')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[InsertVmTemplate] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[InsertVmTemplate]
 @child_count int,  
 @creation_date datetime,  
 @description nvarchar(max) = NULL,  
 @mem_size_mb int,  
 @name nvarchar(40),  
 @num_of_sockets int,  
 @cpu_per_socket int,  
 @os int,  
 @vmt_guid uniqueidentifier,  
 @vds_group_id uniqueidentifier,  
 @domain nvarchar(40),  
 @num_of_monitors int,  
 @status int,  
 @usb_policy int,  
 @time_zone varchar(40) = NULL,  
 @fail_back bit = null,  
 @is_auto_suspend bit,  
 @vm_type int = 0,  
 @hypervisor_type int = null,  
 @operation_mode int = null,  
 @nice_level int,  
 @default_boot_sequence int,  
 @default_display_type int,  
 @priority int,  
 @auto_startup bit,  
 @is_stateless bit,  
 @iso_path nvarchar(max) = null,  
 @origin int = 0,
 @initrd_url    nvarchar(max) = null,
 @kernel_url    nvarchar(max) = null,
 @kernel_params nvarchar(max) = null
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    INSERT INTO [dbo].[vm_templates] ([child_count], [creation_date], [description], [mem_size_mb], [name], [num_of_sockets], [cpu_per_socket], [os], [vmt_guid], [vds_group_id],[domain],[num_of_monitors],[status],[usb_policy],[time_zone],[fail_back],[is_auto_suspend],[vm_type],[hypervisor_type],[operation_mode],[nice_level],[default_boot_sequence],[default_display_type],[priority],[auto_startup],[is_stateless],[iso_path],[origin],[initrd_url],[kernel_url],[kernel_params])
	VALUES (@child_count, @creation_date, @description, @mem_size_mb, @name, @num_of_sockets, @cpu_per_socket, @os, @vmt_guid, @vds_group_id, @domain,@num_of_monitors,@status,@usb_policy,@time_zone,@fail_back,@is_auto_suspend,@vm_type,@hypervisor_type,@operation_mode,@nice_level,@default_boot_sequence,@default_display_type,@priority,@auto_startup,@is_stateless,@iso_path,@origin,@initrd_url,@kernel_url,@kernel_params)
    
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'UpdateVmTemplate')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[UpdateVmTemplate] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[UpdateVmTemplate]
 @child_count int,  
 @creation_date datetime,  
 @description nvarchar(max) = NULL,  
 @mem_size_mb int,  
 @name nvarchar(40),  
 @num_of_sockets int,  
 @cpu_per_socket int,  
 @os int,  
 @vmt_guid uniqueidentifier,  
 @vds_group_id uniqueidentifier,  
 @domain nvarchar(40),  
 @num_of_monitors int,  
 @status int,  
 @usb_policy int,  
 @time_zone varchar(40) = NULL,  
 @fail_back bit = NULL,  
 @is_auto_suspend bit,  
 @vm_type int = 0,  
 @hypervisor_type int = null,  
 @operation_mode int = null,  
 @nice_level int,  
 @default_boot_sequence int,  
 @default_display_type int,  
 @priority int,  
 @auto_startup bit,  
 @is_stateless bit,  
 @iso_path nvarchar(max) = null,  
 @origin int = 0,
 @initrd_url nvarchar(max) = null,
 @kernel_url nvarchar(max) = null,
 @kernel_params nvarchar(max) = null

AS
BEGIN

	--The [dbo].[vm_templates] table doesn't have a timestamp column. Optimistic concurrency logic cannot be generated
	SET NOCOUNT ON

	BEGIN TRY
	UPDATE [dbo].[vm_templates] 
	SET [child_count] = @child_count, [creation_date] = @creation_date, [description] = @description, [mem_size_mb] = @mem_size_mb, [name] = @name, [num_of_sockets] = @num_of_sockets, [cpu_per_socket] = @cpu_per_socket, [os] = @os, [vds_group_id] = @vds_group_id, [domain] = @domain,[num_of_monitors] = @num_of_monitors,[status] = @status,[usb_policy]=@usb_policy,[time_zone]=@time_zone,[fail_back]=@fail_back,[is_auto_suspend] = @is_auto_suspend,
	[vm_type] = @vm_type,[hypervisor_type] = @hypervisor_type,[operation_mode] = @operation_mode, [nice_level] = @nice_level, [default_boot_sequence] = @default_boot_sequence, [default_display_type] = @default_display_type, [priority] = @priority, [auto_startup] = @auto_startup, [is_stateless] = @is_stateless, [iso_path] = @iso_path, [origin] = @origin, [initrd_url] = @initrd_url, [kernel_url] = @kernel_url, [kernel_params] = @kernel_params

	WHERE [vmt_guid]=@vmt_guid

	IF @@ROWCOUNT = 0
	BEGIN
		RAISERROR('Update statement affected 0 rows.', 16, 2)
	END
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH	

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'DeleteVmTemplates')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[DeleteVmTemplates] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[DeleteVmTemplates]
	 @vmt_guid uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		declare @val uniqueidentifier
        -- Get (and keep) a shared lock with "right to upgrade to exclusive"
		-- in order to force locking parent before children 
		SELECT @val = [vmt_guid]
		FROM [dbo].[vm_templates] WITH (UPDLOCK)
		WHERE [vmt_guid]=@vmt_guid

		DELETE FROM [dbo].[vm_templates]
		WHERE [vmt_guid]=@vmt_guid
		-- delete Template permissions --
		DELETE FROM [dbo].[permissions] where object_id = @vmt_guid 
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromVmTemplates')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromVmTemplates] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromVmTemplates]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[vm_templates].[child_count] AS 'child_count',
		[vm_templates].[creation_date] AS 'creation_date',
		[vm_templates].[description] AS 'description',
		[vm_templates].[mem_size_mb] AS 'mem_size_mb',
		[vm_templates].[name] AS 'name',
		[vm_templates].[num_of_sockets] AS 'num_of_sockets',
		[vm_templates].[cpu_per_socket] AS 'cpu_per_socket',
		[vm_templates].[num_of_sockets] * [vm_templates].[cpu_per_socket] AS 'num_of_cpus',
		[vm_templates].[os] AS 'os',
		[vm_templates].[vmt_guid] AS 'vmt_guid',
		[vm_templates].[vds_group_id] AS 'vds_group_id',
		[vm_templates].[domain] AS 'domain',
		[vm_templates].[num_of_monitors] AS 'num_of_monitors',
		[vm_templates].[status] AS 'status',
		[vm_templates].[usb_policy]	AS 'usb_policy',
		[vm_templates].[time_zone]	AS 'time_zone',
		[vm_templates].[fail_back]	AS 'fail_back',
		[vm_templates].[is_auto_suspend] AS 'is_auto_suspend',
		[vm_templates].[vds_group_name] AS 'vds_group_name',
		[vm_templates].[vm_type] AS 'vm_type',
		[vm_templates].[hypervisor_type] AS 'hypervisor_type',
		[vm_templates].[operation_mode] AS 'operation_mode',
		[vm_templates].[nice_level] AS 'nice_level',
		[vm_templates].[storage_pool_id] AS 'storage_pool_id',
		[vm_templates].[storage_pool_name] AS 'storage_pool_name',
		[vm_templates].[default_boot_sequence] AS 'default_boot_sequence',
		[vm_templates].[default_display_type] AS 'default_display_type',
		[vm_templates].[priority] AS 'priority',
		[vm_templates].[auto_startup] AS 'auto_startup',
		[vm_templates].[is_stateless] AS 'is_stateless',
		[vm_templates].[iso_path] AS 'iso_path',
		[vm_templates].[origin] AS 'origin',
		[vm_templates].[initrd_url] as 'initrd_url',
		[vm_templates].[kernel_url] as 'kernel_url',
		[vm_templates].[kernel_params] as 'kernel_params'
		FROM [dbo].[vm_templates_view] [vm_templates]
		ORDER BY name
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVmTemplateByVmtGuid')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVmTemplateByVmtGuid] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVmTemplateByVmtGuid] 
	@vmt_guid uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[vm_templates].[child_count] AS 'child_count',
		[vm_templates].[creation_date] AS 'creation_date',
		[vm_templates].[description] AS 'description',
		[vm_templates].[mem_size_mb] AS 'mem_size_mb',
		[vm_templates].[name] AS 'name',
		[vm_templates].[num_of_sockets] AS 'num_of_sockets',
		[vm_templates].[cpu_per_socket] AS 'cpu_per_socket',
		[vm_templates].[num_of_sockets] * [vm_templates].[cpu_per_socket] AS 'num_of_cpus',
		[vm_templates].[os] AS 'os',
		[vm_templates].[vmt_guid] AS 'vmt_guid',
		[vm_templates].[vds_group_id] AS 'vds_group_id',
		[vm_templates].[domain] AS 'domain'	,
		[vm_templates].[num_of_monitors] AS 'num_of_monitors',
		[vm_templates].[status] AS 'status',
		[vm_templates].[usb_policy]	AS 'usb_policy',
		[vm_templates].[time_zone]	AS 'time_zone',
		[vm_templates].[fail_back]	AS 'fail_back',
		[vm_templates].[is_auto_suspend] AS 'is_auto_suspend',
		[vm_templates].[vds_group_name] AS 'vds_group_name',
		[vm_templates].[vm_type] AS 'vm_type',
		[vm_templates].[hypervisor_type] AS 'hypervisor_type',
		[vm_templates].[operation_mode] AS 'operation_mode',
		[vm_templates].[nice_level] AS 'nice_level',
		[vm_templates].[storage_pool_id] AS 'storage_pool_id',
		[vm_templates].[storage_pool_name] AS 'storage_pool_name',
		[vm_templates].[default_boot_sequence] AS 'default_boot_sequence',
		[vm_templates].[default_display_type] AS 'default_display_type',
		[vm_templates].[priority] AS 'priority',
		[vm_templates].[auto_startup] AS 'auto_startup',
		[vm_templates].[is_stateless] AS 'is_stateless',
		[vm_templates].[iso_path] AS 'iso_path',
		[vm_templates].[origin] AS 'origin',
		[vm_templates].[initrd_url] as 'initrd_url',
		[vm_templates].[kernel_url] as 'kernel_url',
		[vm_templates].[kernel_params] as 'kernel_params'

		FROM [dbo].[vm_templates_view] [vm_templates]
		WHERE [vmt_guid]=@vmt_guid
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVmTemplateByVdsGroupId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVmTemplateByVdsGroupId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVmTemplateByVdsGroupId] 
	@vds_group_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[vm_templates].[child_count] AS 'child_count',
		[vm_templates].[creation_date] AS 'creation_date',
		[vm_templates].[description] AS 'description',
		[vm_templates].[mem_size_mb] AS 'mem_size_mb',
		[vm_templates].[name] AS 'name',
		[vm_templates].[num_of_sockets] AS 'num_of_sockets',
		[vm_templates].[cpu_per_socket] AS 'cpu_per_socket',
		[vm_templates].[num_of_sockets] * [vm_templates].[cpu_per_socket] AS 'num_of_cpus',
		[vm_templates].[os] AS 'os',
		[vm_templates].[vmt_guid] AS 'vmt_guid',
		[vm_templates].[vds_group_id] AS 'vds_group_id',
		[vm_templates].[domain] AS 'domain',
		[vm_templates].[num_of_monitors] AS 'num_of_monitors',
		[vm_templates].[status] AS 'status',
		[vm_templates].[usb_policy]	AS 'usb_policy',
		[vm_templates].[time_zone]	AS 'time_zone',
		[vm_templates].[fail_back]	AS 'fail_back',
		[vm_templates].[is_auto_suspend] AS 'is_auto_suspend',
		[vm_templates].[vds_group_name] AS 'vds_group_name',
		[vm_templates].[vm_type] AS 'vm_type',
		[vm_templates].[hypervisor_type] AS 'hypervisor_type',
		[vm_templates].[operation_mode] AS 'operation_mode',
		[vm_templates].[nice_level] AS 'nice_level',
		[vm_templates].[storage_pool_id] AS 'storage_pool_id',
		[vm_templates].[storage_pool_name] AS 'storage_pool_name',
		[vm_templates].[default_boot_sequence] AS 'default_boot_sequence',
		[vm_templates].[default_display_type] AS 'default_display_type',
		[vm_templates].[priority] AS 'priority',
		[vm_templates].[auto_startup] AS 'auto_startup',
		[vm_templates].[is_stateless] AS 'is_stateless',
		[vm_templates].[iso_path] AS 'iso_path',
		[vm_templates].[origin] AS 'origin',
		[vm_templates].[initrd_url] as 'initrd_url',
		[vm_templates].[kernel_url] as 'kernel_url',
		[vm_templates].[kernel_params] as 'kernel_params'

		FROM [dbo].[vm_templates_view] [vm_templates]
		WHERE [vds_group_id]=@vds_group_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVmTemplateByImageId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVmTemplateByImageId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVmTemplateByImageId] 
	@image_guid uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[vm_templates].[child_count] AS 'child_count',
		[vm_templates].[creation_date] AS 'creation_date',
		[vm_templates].[description] AS 'description',
		[vm_templates].[mem_size_mb] AS 'mem_size_mb',
		[vm_templates].[name] AS 'name',
		[vm_templates].[num_of_sockets] AS 'num_of_sockets',
		[vm_templates].[cpu_per_socket] AS 'cpu_per_socket',
		[vm_templates].[num_of_sockets] * [vm_templates].[cpu_per_socket] AS 'num_of_cpus',
		[vm_templates].[os] AS 'os',
		[vm_templates].[vmt_guid] AS 'vmt_guid',
		[vm_templates].[vds_group_id] AS 'vds_group_id',
		[vm_templates].[domain] AS 'domain',
		[vm_templates].[num_of_monitors] AS 'num_of_monitors',
		[vm_templates].[status] AS 'status',
		[vm_templates].[usb_policy]	AS 'usb_policy',
		[vm_templates].[time_zone]	AS 'time_zone',
		[vm_templates].[fail_back]	AS 'fail_back',
		[vm_templates].[is_auto_suspend] AS 'is_auto_suspend',
		[vm_templates].[vds_group_name] AS 'vds_group_name',
		[vm_templates].[vm_type] AS 'vm_type',
		[vm_templates].[hypervisor_type] AS 'hypervisor_type',
		[vm_templates].[operation_mode] AS 'operation_mode',
		[vm_templates].[nice_level] AS 'nice_level',
		[vm_templates].[storage_pool_id] AS 'storage_pool_id',
		[vm_templates].[storage_pool_name] AS 'storage_pool_name',
		[vm_templates].[default_boot_sequence] AS 'default_boot_sequence',
		[vm_templates].[default_display_type] AS 'default_display_type',
		[vm_templates].[priority] AS 'priority',
		[vm_templates].[auto_startup] AS 'auto_startup',
		[vm_templates].[is_stateless] AS 'is_stateless',
		[vm_templates].[iso_path] AS 'iso_path',
		[vm_templates].[origin] AS 'origin',
		[vm_templates].[initrd_url] as 'initrd_url',
		[vm_templates].[kernel_url] as 'kernel_url',
		[vm_templates].[kernel_params] as 'kernel_params'

		FROM [dbo].[vm_templates_view] [vm_templates]
		inner join [vm_template_image_map] on [vm_templates].[vmt_guid] = [vm_template_image_map].[vmt_guid]
		WHERE [vm_template_image_map].[it_guid]=@image_guid
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVmTemplatesByStorageDomainId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVmTemplatesByStorageDomainId] AS RETURN')
END

GO 

ALTER PROCEDURE [dbo].[GetVmTemplatesByStorageDomainId] 
	@storage_domain_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT DISTINCT
		[vm_templates].[child_count] AS 'child_count',
		[vm_templates].[creation_date] AS 'creation_date',
		[vm_templates].[description] AS 'description',
		[vm_templates].[mem_size_mb] AS 'mem_size_mb',
		[vm_templates].[name] AS 'name',
		[vm_templates].[num_of_sockets] AS 'num_of_sockets',
		[vm_templates].[cpu_per_socket] AS 'cpu_per_socket',
		[vm_templates].[num_of_sockets] * [vm_templates].[cpu_per_socket] AS 'num_of_cpus',
		[vm_templates].[os] AS 'os',
		[vm_templates].[vmt_guid] AS 'vmt_guid',
		[vm_templates].[vds_group_id] AS 'vds_group_id',
		[vm_templates].[domain] AS 'domain'	,
		[vm_templates].[num_of_monitors] AS 'num_of_monitors',
		[vm_templates].[status] AS 'status',
		[vm_templates].[usb_policy]	AS 'usb_policy',
		[vm_templates].[time_zone]	AS 'time_zone',
		[vm_templates].[fail_back]	AS 'fail_back',
		[vm_templates].[is_auto_suspend] AS 'is_auto_suspend',
		[vm_templates].[vds_group_name] AS 'vds_group_name',
		[vm_templates].[vm_type] AS 'vm_type',
		[vm_templates].[hypervisor_type] AS 'hypervisor_type',
		[vm_templates].[operation_mode] AS 'operation_mode',
		[vm_templates].[nice_level] AS 'nice_level',
		[vm_templates].[storage_pool_id] AS 'storage_pool_id',
		[vm_templates].[storage_pool_name] AS 'storage_pool_name',
		[vm_templates].[default_boot_sequence] AS 'default_boot_sequence',
		[vm_templates].[default_display_type] AS 'default_display_type',
		[vm_templates].[priority] AS 'priority',
		[vm_templates].[auto_startup] AS 'auto_startup',
		[vm_templates].[is_stateless] AS 'is_stateless',
		[vm_templates].[iso_path] AS 'iso_path',
		[vm_templates].[origin] AS 'origin',
		[vm_templates].[initrd_url] as 'initrd_url',
		[vm_templates].[kernel_url] as 'kernel_url',
		[vm_templates].[kernel_params] as 'kernel_params'
		FROM [dbo].[vm_templates_view] [vm_templates]

inner join vm_template_image_map on vm_templates.vmt_guid = vm_template_image_map.vmt_guid
where vm_template_image_map.it_guid in
(select image_guid from images where storage_id = @storage_domain_id or image_group_id in 
	(select image_group_id from dbo.image_group_storage_domain_map 
	where image_group_storage_domain_map.storage_domain_id = @storage_domain_id)
)
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END
GO




