'''
Created on Apr 28, 2010

@author: mpastern@redhat.com
'''

import types
import os

from org.ovirt.engine.ui.sdk.internals.method import Method
from org.ovirt.engine.ui.sdk.ext.colors import set_color
from org.ovirt.engine.ui.sdk.internals.argsWrapper import ArgsWrapper
from org.ovirt.engine.ui.sdk.internals.parameter import Parameter
from org.ovirt.engine.ui.sdk.containers.parametersContainer import ParametersContainer

class MethodSignature(Method):
    '''
    This class represents invokable WebMethod Signature.
    '''
    __clientHandler = None
    __ancestor = ''
    __returnType = ''
    __name = ''
    __params = {}
    __argsContainer = None
    __wrappedWsdlTypesHash = {}
    __wsdlTypes = []
    __paramNames = []
    __paint = False
    __printArgType = True
    __argumentProcessingAlgorithm = 'root' 
    __wrapMethodsHelp=True
#TODO: Get cur. console w.    
    __CONSOLE_WIDTH__ = 50
#TODO: - Get current __CONSOLE_WIDTH__ dynamically 
#    __consoleSize = None
    
    def __init__(self, obj, ancestor, returnType, name, params):
        '''
        @var clientHandler: WEB based invocation infrastructure
        @type clientHandler: clientHandler
        @var ancestor: method's ancestor
        @type ancestor: string
        @var returnType: method's return type
        @type returnType: string
        @var name: method's name
        @type name: string
        @var params: method's parameters
        @type params: dict
        '''        
        self.__clientHandler = obj                
        self.__ancestor = ancestor
        self.__returnType = returnType
        self.__name = name
        self.__params = params
        
        cHconfObj = self.__clientHandler.getConfiguration()
        self.__paint=cHconfObj['Color']
        self.__printArgType=cHconfObj['printArgumentsTypes']
        self.__argumentProcessingAlgorithm=cHconfObj['argumentProcessingAlgorithm']     
        self.__wrapMethodsHelp=cHconfObj['wrapMethodsHelp']
        
        self.__wsdlTypes = []
        self.__wrappedWsdlTypesHash = {}
        self. __paramNames = []
        self.__argsContainer = ParametersContainer()
        self.__updateWsdlTypes()
        self.__createArgsContainer()

    def get_args_container(self):
        return self.__argsContainer

    def get_argument_processing_algorithm(self):
        return self.__argumentProcessingAlgorithm

#        self.__consoleSize = self.__getConsoleSize()
    '''
    if(wrapToCliFormat == False(default))
    This method wrapping method representation in to Method driven manner:
    (e.g methodName(argAType argA, argBType argB,...))
    
    if(wrapToCliFormat == True)
    This method expending QueryConfig properties in to method's arguments 
    and wrapping method representation in to CLI driven manner:
    (e.g: methodName {argAType}<argA> {argBType}<argB> [{argCType}<argC>] ...).
    '''    
    def __str__(self, wrapToCliFormat=False):
        if(wrapToCliFormat):
            return (self.__returnType + ' ' + self.__paintTxt(self.__name,'green') + ' ' + self.__paintTxt(self.__params2CLIString(),'cyan'))
        else:
            return (self.__returnType + ' ' + self.__name + '(' + self.__params2String(True) + ')')
    '''
    This method is deprecated and or internal use ONLY!
    '''

    def __createArgsContainer(self):
        for k in self.__params.keys():
            if(self.__wsdlTypes.__contains__(self.__params[k].values()[0])):
                try:
                    self.__generateParamsMetadata(\
                                  param=self.__params[k],\
                                  argsContainer=self.__argsContainer)
                except Exception, e: 
                    print e
            else:
                self.__argsContainer.append(\
                                 Parameter(\
                                           self.__params[k].values()[0], \
                                           self.__params[k].keys()[0]))
    
    def getSignatureWithNoReturnType(self, wrapToCliFormat=False):
        if(wrapToCliFormat):
            return (self.__name + ' ' + self.__params2CLIString())
        else:
            return self.__name + '(' + self.__params2String() + ')'
        
    def __params2String(self,useCliFormat=False):
        if(useCliFormat):
            return self.__params2CLIString(False)
        else:
            params = ''
            for k in self.__params.keys():
                params += unicode.encode(self.__params[k].values()[0] + ' ' + self.__params[k].keys()[0] + ',')
            return params[0:(len(params) - 1)]
        
    def __updateWsdlTypes(self):
        if(len(self.__wsdlTypes) == 0):
            self.__wsdlTypes = self.__clientHandler.getTypes()

    def __paintTxt(self,str,color='white'):
        if(self.__paint == True and (not os.name == 'nt')):
            return set_color(str, color)
        return str

#    def __getConsoleSize(self):
#        rows, columns = os.popen('stty size', 'r').read().split()
#        r= os.environ["COLUMNS"]
#        return rows, columns

    def __params2CLIString(self,addDashToParam=True): 
        
        if(self.__wrapMethodsHelp):
            return self.__createWrappedHelp(addDashToParam)
        else:
             return self.__createUnWrappedHelp(addDashToParam)
               
       
    def __createUnWrappedHelp(self,addDashToParam=True):
        res=''        
        for arg in self.__argsContainer.get_parameters() :
            tempHelpLine=''
            
            if(self.__printArgType): res+='{'+arg.get_type()+'}<'            
            else:res+='<'            
            if(addDashToParam):tempHelpLine+='-'
            
            if(self.__argumentProcessingAlgorithm=='leaf'):
                tempHelpLine +=arg.get_unique_name()
            else:
                tempHelpLine += arg.get_fq_name()           
            
            if(arg.get_options()!=''):
                tempHelpLine += '['+ arg.get_options()+']'
            
            tempHelpLine+='> '
            
            #res+=self.__fitHelpLineToConsoleWidth(tempHelpLine)
            res+=tempHelpLine 
        return res
    def __createWrappedHelp(self,addDashToParam=True):
        res=''        
        for arg in self.__argsContainer.get_parameters() :
            tempHelpLine=''
            
            if(self.__printArgType): res+='\n\t\t{'+arg.get_type()+'}<'            
            else:res+='\n\t\t<'            
            if(addDashToParam):tempHelpLine+='-'
            
            if(self.__argumentProcessingAlgorithm=='leaf'):
                tempHelpLine =self.__setNewLineIfNeeded(tempHelpLine,arg.get_unique_name())
            else:
                tempHelpLine =self.__setNewLineIfNeeded(tempHelpLine,arg.get_fq_name())                 
            
            if(arg.get_options()!=''):
                tempHelpLine =  self.__setNewLineIfNeeded(tempHelpLine,(' ['+ arg.get_options()+']'),True)
            
            tempHelpLine+='>'
            
            #res+=self.__fitHelpLineToConsoleWidth(tempHelpLine)
            res+=tempHelpLine 
        return res
    
    def __setNewLineIfNeeded(self,str1='',str2='',isThisOptionsStr=False):
        new_line_param = '\n\t\t'   
        newOptionsLine = self.__returnType + ' ' + self.__name
        finalLine = str1
        newOptionsArr=[]

        if((((str1+str2).__len__()-1)>=self.__CONSOLE_WIDTH__)and isThisOptionsStr==False):
            return str1+new_line_param+str2
        elif(((str1+str2).__len__()-1)>=self.__CONSOLE_WIDTH__):            
            i=0
            newOptionsArr = str2.split('|')
            while (i < newOptionsArr.__len__()):
                if(((newOptionsLine + newOptionsArr[i]).__len__()-1)>=self.__CONSOLE_WIDTH__):
                    #finalLine += (newOptionsLine+new_line_param+newOptionsArr[i])+ '|'
                    finalLine += self.__addSeparator(new_line_param+newOptionsArr[i])
                    newOptionsLine = self.__addSeparator(newOptionsArr[i])               
                else:   
                    finalLine += self.__addSeparator(newOptionsArr[i]) 
                    newOptionsLine += self.__addSeparator(newOptionsArr[i]) 
                       
                i+=1
        else: finalLine = str1+str2
        
        return finalLine
        
    def __addSeparator(self,str=''):
        if(not str.endswith(']')):
            return (str + '|')
        return str
        
    def __fitHelpLineToConsoleWidth(self,helpLine):
        newHelpLine=''
        i=0
        while i < helpLine.__len__():
            if((newHelpLine+helpLine[i]).__len__() >self.__CONSOLE_WIDTH__) :
                newHelpLine+='\n\t\t '
            newHelpLine+=helpLine[i]
            i+=1
    
    def __getParameterType(self,param):
        splitedwsdlType = param.values()[0].split(".")
        if(len(splitedwsdlType) == 1):
            return param.values()[0]
        return splitedwsdlType[len(splitedwsdlType)-1]
    
    def __getParamNameFromTree(self,tree,index=1):
        paramTree = tree.split('.')
        if(paramTree.__class__ is list and paramTree.__len__() > 0):
            if(paramTree.__len__() == index):
                newParameter = paramTree[index-1]
            else:
                newParameter = paramTree[paramTree.__len__()-index]    
            if(self.__isThisParameterAmbiguous(newParameter)):
                return self.__getParamNameFromTree(tree,(index+1)) 
            else:
                return newParameter
        return paramTree
    def __isThisParameterAmbiguous(self,param):   
        #print self.getName()
        #print self.__paramNames
        encodedParm =  unicode.encode(param)
        if(self.__paramNames.__contains__(encodedParm)):
            return True
        self.__paramNames.append(encodedParm)
        return False        
    
    def __getTypeInstance(self,wsdlType):
        if(not self.__wrappedWsdlTypesHash.has_key(wsdlType)):  
            self.__wrappedWsdlTypesHash[wsdlType] = self.__clientHandler.createEntity(wsdlType)
        return self.__wrappedWsdlTypesHash[wsdlType]
    
    def __generateParamsMetadata(self,param,argsContainer):
        wsdlType = self.__getParameterType(param)
        paramName = param.keys()[0]
        
        wsEntity = self.__getTypeInstance(wsdlType)
        
        if (type(wsEntity) is types.InstanceType) and (self.__isThisEnum(wsEntity)):
            options=''
            for prop in wsEntity:
                if(options != ''):
                    options+=' | '
                options+=prop[0] 
            argsContainer.append(\
                                 Parameter(\
                                           wsdlType, \
                                           paramName,options))
        else:
            for prop in wsEntity:
                if((not prop == None) and (type(prop[1]) is types.InstanceType) and \
                        (self.__wsdlTypes.__contains__(prop[0]))):
                    key=(paramName+'.'+prop[0])
                    val=(wsdlType+'.'+prop[0])
                    if(self.__isThisLoop(key, val)):
                        self.__writeLoopWarning(self.__name,key,val)                        
                    else:
                        self.__generateParamsMetadata({key:val},argsContainer)
                elif((not prop == None) and (type(prop[1]) is types.InstanceType) and \
                        (self.__wsdlTypes.__contains__(prop[1].__class__.__name__))):
                    key=(paramName+'.'+prop[0])  
                    val=(wsdlType+'.'+prop[1].__class__.__name__)
                    if(self.__isThisLoop(key, val)):
                        self.__writeLoopWarning(self.__name,key,val) 
                    else:
                        self.__generateParamsMetadata({key:val},argsContainer)
                else:
                    argsContainer.append(\
                                         Parameter(\
                                                   wsdlType, \
                                                   (paramName + '.' + prop[0])))
        return argsContainer
            

    def __writeLoopWarning(self,methodName,key,val):
        print '<WARNING>: [Method: %s()] Looks like your WebService created loop,\n\t\tby embedding internally \'%s\' entity\n\t\tat \'%s\', IGNORING this argument expansion!' %(methodName,val,key)
    
    def __isThisLoop(self,key,val):
        splitted_val=val.split(".")
        if(len(splitted_val) > 1):
            if(splitted_val[0]==splitted_val[1]):
                return True
        return False
   
    def __isThisEnum(self, wsdlType):
        for prop in wsdlType:
            if(not prop[0] == prop[1]):
                return False
            return True
    def getAncestor(self):
        return self.__ancestor
    def setAncestor(self, ancestor):
        self.__ancestor = ancestor
    def getReturnType(self):
        return self.__returnType
    def getName(self):
        return self.__name
    def getParams(self):
        return self.__params   
    def getParamType(self,paramName):        
        for k in self.__params.keys():            
            if(self.__params[k].keys()[0] == paramName):
                return self.__params[k].values()[0]

        return None   
    def invoke(self, kwargs={}):
        '''
        Invokes this WebMethod signature.
        '''
        return self.__clientHandler.invokeMethod(self.__name, kwargs=kwargs)
    def __warpArgsToArgsWrapperFormat(self,args={}):
        retVal = []
        retVal.append(self.__name)
        for k,v in args.iteritems():
            retVal.append({k:v})
        return retVal
    def __call__(self, *args, **kwargs):
        '''
        Invokes this WebMethod signature.
        '''        
        aWrapper=ArgsWrapper([],self.__clientHandler)
        fName,kwargs = aWrapper.wrapAndCollapseArgs(self.__warpArgsToArgsWrapperFormat(kwargs))
        del fName,aWrapper
        return self.__clientHandler.invokeMethod(self.__name,*args, **kwargs)
    argumentProcessingAlgorithm = property(get_argument_processing_algorithm, None, None, None)
    argsContainer = property(get_args_container, None, None, None)
