#!/bin/bash

# refreshStoredProcedures.sh
echo $1
if [[ $1 = "-h" || $1 = "--help" ]]
then
    echo Usage : refreshStoredProcedures [server] [dbname] [user] [password] [debug]
    echo     "server    - the sql server to access (default = .\sqlexpress)"
    echo     "dbname    - the database name to access/create (default = rhevm)"
    echo     "user      - the datbase user name (default = sa)"
    echo     "password	- the datbase user password (default = RHEVMadmin2009!)"
    echo     debug - true/false enables storing of exception data in DB
    exit
fi


sqlServer=$1
if [[ ! -n $1 ]]
then
    sqlServer=.\sqlexpress
fi

dbname=$2
if [[ ! -n $2 ]]
then
     dbname=rhevm
fi

user=$3
if [[ ! -n $3 ]]
then
    user=sa
fi

password=$4
if [[ ! -n $4 ]]
then
     password=RHEVMadmin2009!
fi

debug=$5
if [[ ! -n $5 ]]
then
     debug=false
fi

echo server - $sqlServer
echo dbname - $dbname
echo user - $user
echo password - $password
echo debug - $debug

var='''$(dbname)='$dbname' $(debug)='$debug''''

echo create views ...
../sqlcmd.py -U$user -P$password -S$sqlServer -d$dbname -i../create_views.sql
echo Done.

echo creating the Stored Procs .....
# -------------------------------------------------------------------------------
# Force running common_sp before other procedures to avoid warnings and after it
# to insure that error handling procedure is not overridden by auto generated sql.
# -------------------------------------------------------------------------------
../sqlcmd.py -U$user -P$password -S$sqlServer -d$dbname -i../common_sp.sql -v$var
for v in $(ls ../*_sp.sql) ;do
	echo Processing $v ...
	../sqlcmd.py -U$user -P$password -S$sqlServer -d$dbname -i$v
done
../sqlcmd.py -U$user -P$password -S$sqlServer -d$dbname -i../common_sp.sql -v$var
if [[ $? != 0 ]]
then
    exit 1
fi
echo Done.

