using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Text;
using System.Threading;
using System.Windows.Threading;
using org.ovirt.engine.ui.uicompat;
using VdcCommon.VdcQueries;
using VdcCommon.BusinessEntities;
using VdcFrontend;

namespace org.ovirt.engine.ui.uicommon.models.storage
{
	public abstract class ImportSanStorageModel : SanStorageModelBase
	{
		#region Properties

		private IList<storage_domains> candidates;
		public IList<storage_domains> Candidates
		{
			get { return candidates; }
			set
			{
				if (candidates != value)
				{
					candidates = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Candidates"));
				}
			}
		}

		private string error;
		public string Error
		{
			get { return error; }
			set
			{
				if (error != value)
				{
					error = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Error"));
				}
			}
		}

		#endregion

		private VDS oldHost;

		protected ImportSanStorageModel()
		{
			InitializeItems(null);
		}

		protected override void PostDiscoverTargets(List<SanTargetModel> newItems)
		{
			base.PostDiscoverTargets(newItems);

			InitializeItems(newItems);
		}

		protected override void UpdateInternal()
		{
			base.UpdateInternal();

			if (Container.Progress != null)
			{
				return;
			}

			VDS host = (VDS)Container.Host.SelectedItem;
			if (host == null)
			{
				return;
			}

			if (host != oldHost)
			{
				Items = null;
				oldHost = host;
			}

			InitializeItems(null);

			Error = null;
			Container.StartProgress(null);

			Frontend.RunQuery(VdcQueryType.GetExistingStorageDomainList, new GetExistingStorageDomainListParameters(host.vds_id, Type, Role, String.Empty), new AsyncQuery(this,
				(target, returnValue) =>
				{
					ImportSanStorageModel model = (ImportSanStorageModel)target;

					object result = ((VdcQueryReturnValue)returnValue).ReturnValue;
					if (result != null)
					{
						model.Candidates = (List<storage_domains>)(valueObjectEnumerableList)result;
					}
					else
					{
						Error = "Error while retrieving list of domains. Please consult your Storage Administrator.";
					}

					model.Container.StopProgress();
				},
				true)
			);
		}

		private void InitializeItems(IList<SanTargetModel> newItems)
		{
			if (Items == null)
			{
				Items = new ObservableCollection<SanTargetModel>();
			}
			else
			{
				IList<SanTargetModel> items = (IList<SanTargetModel>)Items;

				//Add new targets.
				if (newItems != null)
				{
					foreach (SanTargetModel newItem in newItems)
					{
						if (Linq.FirstOrDefault(items, new Linq.TargetPredicate(newItem)) == null)
						{
							items.Add(newItem);
						}
					}
				}

				UpdateLoginAllAvailability();
			}
		}

		public override bool Validate()
		{
			IsValid = SelectedItem != null;

			return base.Validate() && IsValid;
		}
	}


	public class IscsiImportStorageModel : ImportSanStorageModel
	{
		public override StorageType Type
		{
			get { return StorageType.ISCSI; }
		}
	}


	public class FcpImportStorageModel : ImportSanStorageModel
	{
		public override StorageType Type
		{
			get { return StorageType.FCP; }
		}
	}
}
