using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Text;
using VdcCommon.Interfaces;
using VdcCommon.VdcQueries;
using VdcFrontend;
using System.ComponentModel;
using System.Collections;
using VdcCommon.BusinessEntities;
using VdcCommon;

namespace org.ovirt.engine.ui.uicommon.models.storage
{
	public class StorageIsoListModel : SearchableListModel, IFrontendMultipleQueryAsyncCallback
	{
		public StorageIsoListModel()
		{
			Title = "Images";
		}

		protected override void OnEntityChanged()
		{
			base.OnEntityChanged();

			SearchCommand.Execute();
		}

		public override void Search()
		{
			if (Entity != null)
			{
				base.Search();
			}
			else
			{
				Items = null;
			}
		}

		protected override void SyncSearch()
		{
			base.SyncSearch();

			if (Progress != null)
			{
				return;
			}

			storage_domains storageDomain = (storage_domains)Entity;

			GetAllIsoImagesListParameters parameters =
				new GetAllIsoImagesListParameters
				{
					StorageDomainId = storageDomain.id,
					ForceRefresh = true
				};

			StartProgress(null);

			Frontend.RunMultipleQueries(
				new List<VdcQueryType>
				{
					VdcQueryType.GetAllIsoImagesList,
					VdcQueryType.GetAllFloppyImagesList
				},
				new List<VdcQueryParametersBase>
				{
					parameters,
					parameters
				},
				this);
		}

		protected override void AsyncSearch()
		{
			base.AsyncSearch();
			SyncSearch();
		}

		public void Executed(FrontendMultipleQueryAsyncResult result)
		{
			StopProgress();

			List<EntityModel> items = new List<EntityModel>();

			VdcQueryReturnValue isoReturnValue = result.ReturnValues[0];

			List<RepoFileMetaData> isoImages = isoReturnValue.Succeeded
				? (List<RepoFileMetaData>)isoReturnValue.ReturnValue
				: new List<RepoFileMetaData>();

			foreach (RepoFileMetaData item in isoImages)
			{
				EntityModel model = new EntityModel();
				model.Title = item.RepoFileName;
				model.Entity = "CD/DVD";
				items.Add(model);
			}


			VdcQueryReturnValue floppyReturnValue = result.ReturnValues[1];

			List<RepoFileMetaData> floppyImages = floppyReturnValue.Succeeded
				? (List<RepoFileMetaData>)floppyReturnValue.ReturnValue
				: new List<RepoFileMetaData>();

			foreach (RepoFileMetaData item in floppyImages)
			{
				EntityModel model = new EntityModel();
				model.Title = item.RepoFileName;
				model.Entity = "Floppy";
				items.Add(model);
			}

			Items = items;
			IsEmpty = items.Count == 0;
		}
	}
}
