﻿using System;
using System.Collections.Generic;
using System.Net;

namespace VdcUtils
{
	public class DocumentationPathTranslator
	{
		private static Dictionary<string, string> documentationPathDictionary;

		public static string GetPath(string hashName)
		{
			try
			{
				if (documentationPathDictionary != null && documentationPathDictionary.ContainsKey(hashName))
					return documentationPathDictionary[hashName];
				return null;
			}
			catch (Exception)
			{
				return null;
			}
		}

		public static void Init(string path)
		{
			QLogger.Instance.InfoFormat("DocumentationPathTranslator.Init::Start to download, path={0}.", path);
			try
			{
				var client = new WebClient();
				string src = null;

				//Read the values from DocumentationPath.csv
				src = client.DownloadString(path);
				if (String.IsNullOrEmpty(src))
					throw new Exception("DocumentationPathTranslator.Init::downloaded empty string from file"+ path);
				QLogger.Instance.InfoFormat("DocumentationPathTranslator.Init::downloaded content length: {0}",src.Length);
				documentationPathDictionary = new Dictionary<string, string>();
				string x = Environment.NewLine;
				string[] allLines = src.Split('\n');
				string[] splitLine;
				foreach (string line in allLines)
				{
					splitLine = line.Split(',');
					if (splitLine.Length > 1 && !String.IsNullOrEmpty(splitLine[0]) && !String.IsNullOrEmpty(splitLine[1]))
					{
						if (!documentationPathDictionary.ContainsKey(splitLine[0]))
						{
							documentationPathDictionary.Add(splitLine[0], splitLine[1]);
						}
					}
				}
			}
			catch (Exception e)
			{
				QLogger.Instance.Error("Frontend.DocumentationPathTranslator.Init::Error in parsing File", e);
				documentationPathDictionary = null;
			}
		}
	}
}
