@echo off

if "%1%" == "-h" goto Syntax
if "%1%" == "--help" goto Syntax

SET sqlServer="%1%"
if "%1%" == "" set sqlServer=.\sqlexpress

SET dbname=%2%
if "%2%" == "" set dbname=rhevm

SET user=%3%

SET pass=%4%

SET debug=%5%
if "%5%" == "" set debug='true'

SET dbcmd=-b -S %sqlServer% -d %dbname% 
if not "%user%" == "" set dbcmd=-b -S %sqlServer% -d %dbname% -U %user% -P %pass% 

for %%v in (%0) do set MyPath=%%~dpv
pushd "%MyPath%"

echo server - %sqlServer%
echo dbname - %dbname%

REM -------------------------------------------------------------------------------
REM Refreshing all views 
REM -------------------------------------------------------------------------------

sqlcmd  %dbcmd% -v debug=%debug% -i create_views.sql
if %ERRORLEVEL% NEQ 0 goto ERROR


echo Creating the Stored Procs .....
REM -------------------------------------------------------------------------------
REM Force running common_sp before other procedures to avoid warnings and after it
REM to insure that error handling procedure is not overridden by auto generated sql.
REM -------------------------------------------------------------------------------
sqlcmd  %dbcmd% -v debug=%debug% -i common_sp.sql
REM USING ERRORLEVEL in the loop rather than %ERRORLEVEL% since %ERRORLEVEL% gives 0 code even if one of the sp scripts fails.
REM The for loop should be one-liner since in cmd, environment variables within a FOR loop 
REM are expanded at the beginning of the loop, so when you use %sqlServer% 
REM (and the value passedto that script is (localhost)\SQLEXPRESS ) the cmd throws an exception.
for %%v in (*_sp.sql) do sqlcmd  %dbcmd% -i %%v || if ERRORLEVEL 1 goto ERROR
sqlcmd  %dbcmd% -v debug=%debug% -i common_sp.sql
if %ERRORLEVEL% NEQ 0 goto ERROR

echo Done.

popd

goto:EOF


:Syntax
echo refrashStoredProcedures.cmd script-path [server] [dbname] [user] [password] [debug]
echo	 script-path - the path to the sql scripts folder
echo     server      - the sql server to access (default = .\sqlexpress)
echo     dbname      - the database name to access/create (default = rhevm)
echo	 user        - the dbo user name (default is to use integrated authentication)
echo	 password    - the dbo password (default is to use integrated authentication)
echo	 debug - true/false enables storing of exception data in DB

goto:EOF
:ERROR
exit /b 1
