package org.ovirt.engine.core.config.validation;

import java.util.Arrays;
import java.util.List;
import org.ovirt.engine.core.config.RhevmConfigMap;

/**
 * The <code>ConfigAction</code> enum holds the optional actions in the RhevmConfig tool. The enum runs validations that
 * are action-specific. Each ConfigAction holds a list of strings that represent it, and a list of validators that are
 * relevant for it.
 */
public enum ConfigActionType {
    ACTION_ALL(Arrays.asList(new String[] { "-a", "--all" }), null),
    ACTION_LIST(Arrays.asList(new String[] { "-l", "--list" }), null),
    ACTION_GET(Arrays.asList(new String[] { "-g", "--get" }), new ValidatorType[] { ValidatorType.get }),
    ACTION_SET(Arrays.asList(new String[] { "-s", "--set" }), new ValidatorType[] { ValidatorType.set });

    private List<String> optionalStrings;
    private ValidatorType[] validatorTypes;

    private ConfigActionType(List<String> optionalStrings, ValidatorType[] validationTypes) {
        this.optionalStrings = optionalStrings;
        this.validatorTypes = validationTypes;
    }

    static public ConfigActionType getActionType(String arg) {
        for (ConfigActionType type : ConfigActionType.values()) {
            if (type.optionalStrings.contains(arg)) {
                return type;
            }
        }
        return null;
    }

    /**
     * Iterates through the list of action specific validators of this ConfigAction
     * @param rhevmConfigMap
     *            Should hold the arguments needed in order to validate this ConfigAction.
     */
    public void validate(RhevmConfigMap rhevmConfigMap) throws IllegalArgumentException {
        if (validatorTypes != null) {
            for (ValidatorType val : validatorTypes) {
                RhevmConfigValidatorFactory.instance().getValidation(val).validate(this, rhevmConfigMap);
            }
        }
    }
}