using System;
using System.Collections.Generic;
using System.Text;
using System.Windows;

using VdcCommon.VdcQueries;
using VdcFrontend;
using VdcCommon.Interfaces;
using VdcCommon.BusinessEntities;
using System.Collections.ObjectModel;
using System.Collections;

namespace org.ovirt.engine.ui.uicommon.models.users
{
	public class FindDesktopModel : SearchableListModel
	{
		#region Properties

		public IEnumerable ExcludeItems { get; set; }

		#endregion


		protected override void SyncSearch()
		{
			//			List<VM> exclude = ExcludeItems != null ? Linq.Cast<VM>(ExcludeItems) : new List<VM>();

			HashSet<guid> exludeGuids = new HashSet<guid>();
			if (ExcludeItems != null)
			{
				foreach (object item in ExcludeItems)
				{
					VM vm = (VM)item;
					exludeGuids.Add(vm.vm_guid);
				}
			}


			VdcQueryReturnValue returnValue = Frontend.RunQuery(VdcQueryType.Search, new SearchParameters(String.Format("Vms: pool=null type=desktop {0}", SearchString), SearchType.VM));
			if (returnValue != null && returnValue.Succeeded)
			{
				//                List<EntityModel> items = ((List<IVdcQueryable>)returnValue.ReturnValue)
				//					.Cast<VM>()
				//					.Where(a => !exclude.Any(b => b.vm_guid == a.vm_guid))
				//					.Select(a => new EntityModel() { Entity = a })
				//					.ToList();
				List<EntityModel> items = new List<EntityModel>();
				foreach (IVdcQueryable item in (List<IVdcQueryable>)returnValue.ReturnValue)
				{
					VM vm = (VM)item;
					if (!exludeGuids.Contains(vm.vm_guid))
					{
						items.Add(new EntityModel { Entity = vm });
					}
				}

				Items = items;
			}
			else
			{
				Items = null;
			}
		}

		protected override void AsyncSearch()
		{
			base.AsyncSearch();
			SyncSearch();
		}
	}
}
