PRINT 'Processing Upgrade_sp.sql'

/*
Override database values with current product settings only for entries in the xml
that are marked with the override flag. This enables force overriding a value that may be 
already changed by the customer to a new value.
*/
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Upgrade_override_config_values')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Upgrade_override_config_values] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Upgrade_override_config_values]   
@xml xml,
@version nvarchar(40)
AS
BEGIN
	SET NOCOUNT ON	
	BEGIN TRY
        declare @parameterList nvarchar(max)
		declare @sql nvarchar(max)
		SET @parameterList = '@xml xml OUTPUT'
		set @sql = '
		UPDATE u
		SET option_value = A.[value]
		FROM dbo.vdc_options u
		INNER JOIN (
			SELECT  t.c.[value](''@key'',''nvarchar(100)'') as [key],
				 t.c.[value](''@value'', ''nvarchar(max)'') as [value],
				 t.c.[value](''@override'', ''nvarchar(10)'') as [override]
			FROM @xml.nodes(''Versions/Version[@name="' + @version + '"]/Fields/FieldGroup/Field'')as t(c)
		) A
		ON A.[key] = u.option_name
		WHERE  A.[override] = ''true'' and u.version =''' + @version + ''''
	EXECUTE sp_executesql @sql, @parameterList, @xml = @xml OUTPUT
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

/*
Inserts new values added by the latest version in the xml file to the database.
*/
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Upgrade_insert_new_config_values')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Upgrade_insert_new_config_values] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Upgrade_insert_new_config_values]    
@xml xml,
@version nvarchar(40)

AS
BEGIN
	SET NOCOUNT ON	
	BEGIN TRY
        declare @parameterList nvarchar(max)
		declare @sql nvarchar(max)
		SET @parameterList = '@xml xml OUTPUT'
		set @sql = '
		INSERT dbo.vdc_options (option_name, option_value, version) (
			SELECT  t.c.[value](''@key'',''nvarchar(100)'') as [key],
				 t.c.[value](''@value'', ''nvarchar(max)'') as [value],''' + @version + 
			''' FROM @xml.nodes(''Versions/Version[@name="' + @version + '"]/Fields/FieldGroup/Field'')as t(c)
			WHERE t.c.[value](''@key'',''nvarchar(100)'') not in (
				select option_name from dbo.vdc_options where version = ''' + @version + '''))'
	EXECUTE sp_executesql @sql, @parameterList, @xml = @xml OUTPUT

    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    
GO

/*
Cleanup any configuration variables that are no longer supported (or being renamed) by the latest version.
*/
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Upgrade_cleanup_config_values')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Upgrade_cleanup_config_values] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Upgrade_cleanup_config_values]    
@xml xml,
@version nvarchar(40)

AS
BEGIN
	SET NOCOUNT ON	
	BEGIN TRY
        declare @parameterList nvarchar(max)
		declare @sql nvarchar(max)
		SET @parameterList = '@xml xml OUTPUT'
		set @sql = '
		DELETE FROM dbo.vdc_options
		where option_name not in 
		(
			SELECT  t.c.[value](''@key'',''nvarchar(100)'') as [key]
			FROM @xml.nodes(''Versions/Version[@name="' + @version + '"]/Fields/FieldGroup/Field'')as t(c)
		) and dbo.vdc_options.version ='''  + @version + '''' 
	EXECUTE sp_executesql @sql, @parameterList, @xml = @xml OUTPUT

    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO
