﻿using System;
using System.Runtime.Serialization;
using VdcCommon.BusinessEntities;
using System.Collections.Generic;

namespace VdcCommon.BusinessEntities
{
    
    public partial class StorageDomainQueryParametersBase : VdcQueryParametersBase
    {
        public StorageDomainQueryParametersBase() { }

        public StorageDomainQueryParametersBase(Guid storageDomainId)
        {
            StorageDomainId = storageDomainId;
        }

        public override RegisterableQueryReturnDataType GetReturnedDataTypeByVdcQueryType(VdcQueryType queryType)
        {
			switch (queryType)
			{
				case VdcQueryType.GetStorageDomainListById:
				case VdcQueryType.GetStoragePoolsByStorageDomainId:
					return RegisterableQueryReturnDataType.LIST_IQUERYABLE;
				default:
					return RegisterableQueryReturnDataType.IQUERYABLE;
			}
        }
    }

	public partial class StorageDomainQueryTopSizeVmsParameters : StorageDomainQueryParametersBase
	{
		public StorageDomainQueryTopSizeVmsParameters()
		{
			
		}
		public StorageDomainQueryTopSizeVmsParameters(Guid storageDomainId, int maxVmsToReturn) : base(storageDomainId)
		{
			this.MaxVmsToReturn = maxVmsToReturn;
		}
	}
	
	public partial class StorageDomainAndPoolQueryParameters : StorageDomainQueryParametersBase
	{
		public override RegisterableQueryReturnDataType GetReturnedDataTypeByVdcQueryType(VdcQueryType queryType)
		{
			return RegisterableQueryReturnDataType.IQUERYABLE;
		}
	}
    
    public partial class StorageServerConnectionQueryParametersBase : VdcQueryParametersBase
    {
        public StorageServerConnectionQueryParametersBase() { }

        public StorageServerConnectionQueryParametersBase(string serverConnectionId)
        {
            ServerConnectionId = serverConnectionId;
        }

        public override RegisterableQueryReturnDataType GetReturnedDataTypeByVdcQueryType(VdcQueryType queryType)
        {
            return RegisterableQueryReturnDataType.UNDEFINED;
        }
    }
    
    public partial class VGQueryParametersBase : VdsIdParametersBase
    {
       
        public VGQueryParametersBase() { }

        public VGQueryParametersBase(string vgID, Guid vdsId)
            : base(vdsId)
        {
            VGId = vgID;
        }

        public override RegisterableQueryReturnDataType GetReturnedDataTypeByVdcQueryType(VdcQueryType queryType)
        {
            return RegisterableQueryReturnDataType.UNDEFINED;
        }
    }
    
    public partial class StoragePoolQueryParametersBase : VdcQueryParametersBase
    {
        public StoragePoolQueryParametersBase() { }

        public StoragePoolQueryParametersBase(Guid storagePoolId)
        {
            StoragePoolId = storagePoolId;
        }

        public override RegisterableQueryReturnDataType GetReturnedDataTypeByVdcQueryType(VdcQueryType queryType)
        {
            switch (queryType)
            {
                case(VdcQueryType.GetStoragePoolById):
                    return RegisterableQueryReturnDataType.IQUERYABLE;
                
                case(VdcQueryType.GetVdsGroupsByStoragePoolId):
				case VdcQueryType.GetStorageDomainsByStoragePoolId:
					return RegisterableQueryReturnDataType.LIST_IQUERYABLE;

                default:
                    return RegisterableQueryReturnDataType.UNDEFINED;
            }
        }
    }
	
	public partial class DiscoverSendTargetsQueryParameters : VdcQueryParametersBase
	{
        public DiscoverSendTargetsQueryParameters() { }

        public DiscoverSendTargetsQueryParameters(Guid vdsId, storage_server_connections connection)
		{
			VdsId = vdsId;
			Connection = connection;
		}
	}
	
	public partial class GetStorageDomainsByVmTemplateIdQueryParameters : GetVmTemplatesDisksParameters
	{
        public GetStorageDomainsByVmTemplateIdQueryParameters() { }

		public GetStorageDomainsByVmTemplateIdQueryParameters(Guid vmTemplateId)
			: base(vmTemplateId)
		{
		}
	}

	
	public partial class  GetAllFromExportDomainQueryParamenters : VdcQueryParametersBase
	{
        
        public GetAllFromExportDomainQueryParamenters() { }
        public GetAllFromExportDomainQueryParamenters(Guid storagePoolId, Guid storageDomainId)
		{
            // for getting existing Vm as well
            GetAll = false;
            this.StoragePoolId = storagePoolId;
            this.StorageDomainId = storageDomainId;
		}
	}
	
	public partial class GetDeviceListQueryParameters : VdsIdParametersBase
	{
       
        public GetDeviceListQueryParameters() { }

        public GetDeviceListQueryParameters(Guid vdsId, StorageType storageType)
			: base(vdsId)
		{
			StorageType = storageType;
		}
	}
    
    public partial class GetExistingStorageDomainListParameters : VdsIdParametersBase
    {
    
        public GetExistingStorageDomainListParameters() {}
        public GetExistingStorageDomainListParameters(Guid vdsId, StorageType storageType, StorageDomainType storageDomainType, string path)
            : base(vdsId)
        {
            StorageType = storageType;
            StorageDomainType = storageDomainType;
            Path = path;
        }
    }
}
