
namespace VdcUtils
{
    public class XmlRpcLogger : CookComputing.XmlRpc.XmlRpcLogger 
    {
        public static bool sLogXmlRpcData = Config.GetValue<bool>(ConfigValues.LogXmlRpcData);
        protected override void OnRequest(object sender, CookComputing.XmlRpc.XmlRpcRequestEventArgs e)
        {
            if (sLogXmlRpcData)
            {
                QLogger.Instance.DebugFormat("XMLRPC request begins:");
                DumpStream(e.RequestStream);
                QLogger.Instance.DebugFormat("XMLRPC request ends.");
            }
        }

        protected override void OnResponse(object sender, CookComputing.XmlRpc.XmlRpcResponseEventArgs e)
        {
            if (sLogXmlRpcData)
            {
                QLogger.Instance.DebugFormat("XMLRPC response:");
                DumpStream(e.ResponseStream);
                QLogger.Instance.DebugFormat("XMLRPC response ends.");
            }
        }

        private void DumpStream(System.IO.Stream stm)
        {
            stm.Position = 0;
            System.IO.TextReader trdr = new System.IO.StreamReader(stm);
            System.String s = trdr.ReadLine();
            while (s != null)
            {
                QLogger.Instance.DebugFormat("{0}", s);
                s = trdr.ReadLine();
            }
        }
    }
}
