using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using org.ovirt.engine.ui.uicommon;
using Microsoft.Practices.Unity;
using VdcCommon.BusinessEntities;
using org.ovirt.engine.ui.uicommon.models.clusters;

namespace UI.WPFClient
{
	public partial class ClusterPolicyView
	{
		private WindowView view;

		public new ClusterPolicyModel Model
		{
			get { return base.Model as ClusterPolicyModel; }
			set { base.Model = value; }
		}


		public ClusterPolicyView()
		{
			InitializeComponent();
		}

		protected override void ModelPropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			base.ModelPropertyChanged(sender, e);

			if (e.PropertyName != "Window") return;

			if (Model.Window != null)
			{
				if (Model.LastExecutedCommand == Model.EditCommand)
				{
					view = TypeResolver.Instance.Resolve<ClusterPolicyEditView>();
				}
				else
				{
					throw new NotImplementedException();
				}

				view.Model = Model.Window;
				WindowManager.AddWindow(view);
			}
			else
			{
				WindowManager.RemoveWindow(view);
				view = null;
			}
		}
	}
}
