using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using org.ovirt.engine.ui.uicommon.models.clusters;
using org.ovirt.engine.ui.uicommon.models.datacenters;
using org.ovirt.engine.ui.uicommon.models.hosts;
using org.ovirt.engine.ui.uicommon.models.storage;
using VdcCommon.BusinessEntities;
using org.ovirt.engine.ui.uicommon;
using Microsoft.Practices.Unity;

namespace UI.WPFClient
{
	public partial class DataCenterGuideView
	{
		private WindowView view;
		private WindowView view1;

		public new DataCenterGuideModel Model
		{
			get { return (DataCenterGuideModel)base.Model; }
			set { base.Model = value; }
		}

		public DataCenterGuideView()
		{
			InitializeComponent();
		}

		protected override void ModelPropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			base.ModelPropertyChanged(sender, e);

			if (e.PropertyName == "Window")
			{
				if (Model.Window != null)
				{
					if (Model.Window is HostModel)
					{
						view = TypeResolver.Instance.Resolve<HostView>();
					}
					else if (Model.Window is ClusterModel)
					{
						view = TypeResolver.Instance.Resolve<ClusterView>();
					}
					else if (Model.Window is StorageModel)
					{
						view = TypeResolver.Instance.Resolve<StorageView>();
					}
					else if (Model.Window is MoveHost)
					{
						view = TypeResolver.Instance.Resolve<FindMultipleHostView>();
					}
						//TODO: Turn Guide dialog actions to be commands. And compare by instances rather than title and model type.
					else if (Model.Window.Title == "Attach Storage")
					{
						view = TypeResolver.Instance.Resolve<FindMultipleStorageView>();
					}
					else if (Model.Window.Title == "Attach ISO Library")
					{
						view = TypeResolver.Instance.Resolve<FindSingleStorageView>();
					}
					else
					{
						throw new NotImplementedException();
					}

					view.Model = Model.Window;
					WindowManager.AddWindow(view);
				}
				else
				{
					WindowManager.RemoveWindow(view);
					view = null;
				}
			}
			else if(e.PropertyName == "ConfirmWindow")
			{
				if (Model.ConfirmWindow != null)
				{
					view1 = TypeResolver.Instance.Resolve<ConfirmationView>();
					view1.Model = Model.ConfirmWindow;
					WindowManager.AddWindow(view1);
				}
				else
				{
					WindowManager.RemoveWindow(view1);
					view1 = null;
				}
			}
		}
	}
}
