/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

final class TDSChannel {
    private static final Logger logger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.TDS.Channel");
    private final SQLServerConnection con;
    private final TDSWriter tdsWriter;
    private Socket tcpSocket;
    private SSLSocket sslSocket;
    private Socket channelSocket;
    ProxySocket proxySocket = null;
    private boolean isClosed;
    private InputStream tcpInputStream;
    private OutputStream tcpOutputStream;
    private InputStream inputStream;
    private OutputStream outputStream;
    private static Logger packetLogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.TDS.DATA");
    private final boolean isLoggingPackets = packetLogger.isLoggable(Level.FINEST);
    int numMsgsSent = 0;
    int numMsgsRcvd = 0;
    private int spid = 0;
    private static final String SEPARATOR = System.getProperty("file.separator");
    private static final String JAVA_HOME = System.getProperty("java.home");
    private static final String JSSECACERTS = JAVA_HOME + SEPARATOR + "lib" + SEPARATOR + "security" + SEPARATOR + "jssecacerts";
    private static final String CACERTS = JAVA_HOME + SEPARATOR + "lib" + SEPARATOR + "security" + SEPARATOR + "cacerts";

    final Logger getLogger() {
        return logger;
    }

    public final String toString() {
        return "TDSChannel (" + this.con.toString() + ")";
    }

    final TDSWriter getWriter() {
        return this.tdsWriter;
    }

    final TDSReader getReader() {
        return new TDSReader(this, this.con);
    }

    private final void checkClosed() throws SQLServerException {
        if (this.isClosed) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_connectionIsClosed"), null, false);
        }
    }

    final boolean isLoggingPackets() {
        return this.isLoggingPackets;
    }

    void setSPID(int n) {
        this.spid = n;
    }

    int getSPID() {
        return this.spid;
    }

    void resetPooledConnection() {
        this.tdsWriter.resetPooledConnection();
    }

    TDSChannel(SQLServerConnection sQLServerConnection) {
        this.con = sQLServerConnection;
        this.isClosed = false;
        this.tcpSocket = null;
        this.sslSocket = null;
        this.channelSocket = null;
        this.tcpInputStream = null;
        this.tcpOutputStream = null;
        this.inputStream = null;
        this.outputStream = null;
        this.tdsWriter = new TDSWriter(this, sQLServerConnection);
    }

    final void open(String string, int n, int n2) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.toString() + ": Opening TCP socket...");
        }
        if (0 == n2) {
            this.channelSocket = this.tcpSocket = new Socket(string, n);
        } else {
            this.channelSocket = this.tcpSocket = new Socket();
            InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
            if (inetSocketAddress.isUnresolved()) {
                throw new UnknownHostException();
            }
            this.tcpSocket.connect(inetSocketAddress, n2);
        }
        this.tcpSocket.setTcpNoDelay(true);
        this.tcpSocket.setKeepAlive(true);
        this.inputStream = this.tcpInputStream = this.tcpSocket.getInputStream();
        this.outputStream = this.tcpOutputStream = this.tcpSocket.getOutputStream();
    }

    void disableSSL() {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.toString() + " Disabling SSL...");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
        try {
            ((InputStream)byteArrayInputStream).close();
        }
        catch (IOException iOException) {
            logger.fine("Ignored error closing InputStream: " + iOException.getMessage());
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ((OutputStream)byteArrayOutputStream).close();
        }
        catch (IOException iOException) {
            logger.fine("Ignored error closing OutputStream: " + iOException.getMessage());
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this.toString() + " Rewiring proxy streams for SSL socket close");
        }
        this.proxySocket.setStreams(byteArrayInputStream, byteArrayOutputStream);
        try {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(this.toString() + " Closing SSL socket");
            }
            this.sslSocket.close();
        }
        catch (IOException iOException) {
            logger.fine("Ignored error closing SSLSocket: " + iOException.getMessage());
        }
        this.proxySocket = null;
        this.inputStream = this.tcpInputStream;
        this.outputStream = this.tcpOutputStream;
        this.channelSocket = this.tcpSocket;
        this.sslSocket = null;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.toString() + " SSL disabled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enableSSL(String string, int n) throws SQLServerException {
        try {
            Object object;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(this.toString() + " Enabling SSL...");
            }
            String string2 = this.con.activeConnectionProperties.getProperty("trustStore");
            String string3 = this.con.activeConnectionProperties.getProperty("trustStorePassword");
            String string4 = this.con.activeConnectionProperties.getProperty("hostNameInCertificate");
            assert (0 == this.con.getRequestedEncryptionLevel() || 1 == this.con.getRequestedEncryptionLevel());
            assert (0 == this.con.getNegotiatedEncryptionLevel() || 1 == this.con.getNegotiatedEncryptionLevel() || 3 == this.con.getNegotiatedEncryptionLevel());
            TrustManager[] trustManagerArray = null;
            if (0 == this.con.getRequestedEncryptionLevel() || 1 == this.con.getRequestedEncryptionLevel() && this.con.trustServerCertificate()) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(this.toString() + " SSL handshake will trust any certificate");
                }
                trustManagerArray = new TrustManager[]{new PermissiveX509TrustManager(this)};
            } else {
                Object object2;
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(this.toString() + " SSL handshake will validate server certificate");
                }
                object = null;
                if (null == string2 && null == string3) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer(this.toString() + " Using system default trust store and password");
                    }
                } else {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest(this.toString() + " Finding key store interface");
                    }
                    object = KeyStore.getInstance("JKS");
                    object2 = this.loadTrustStore(string2);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest(this.toString() + " Loading key store");
                    }
                    try {
                        ((KeyStore)object).load((InputStream)object2, null == string3 ? null : string3.toCharArray());
                    }
                    finally {
                        block34: {
                            this.con.activeConnectionProperties.remove("trustStorePassword");
                            if (null != object2) {
                                try {
                                    ((InputStream)object2).close();
                                }
                                catch (IOException iOException) {
                                    if (!logger.isLoggable(Level.FINE)) break block34;
                                    logger.fine(this.toString() + " Ignoring error closing trust material InputStream...");
                                }
                            }
                        }
                    }
                }
                object2 = null;
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(this.toString() + " Locating X.509 trust manager factory");
                }
                object2 = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(this.toString() + " Getting trust manager");
                }
                ((TrustManagerFactory)object2).init((KeyStore)object);
                trustManagerArray = ((TrustManagerFactory)object2).getTrustManagers();
                trustManagerArray = null != string4 ? new TrustManager[]{new HostNameOverrideX509TrustManager(this, (X509TrustManager)trustManagerArray[0], string4)} : new TrustManager[]{new HostNameOverrideX509TrustManager(this, (X509TrustManager)trustManagerArray[0], this.tcpSocket.getInetAddress().getCanonicalHostName())};
            }
            object = null;
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + " Getting SSLv3 or better SSL context");
            }
            object = SSLContext.getInstance("SSLv3");
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + " Initializing SSL context");
            }
            ((SSLContext)object).init(null, trustManagerArray, null);
            this.proxySocket = new ProxySocket(this);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + " Creating SSL socket");
            }
            this.sslSocket = (SSLSocket)((SSLContext)object).getSocketFactory().createSocket(this.proxySocket, string, n, false);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(this.toString() + " Starting SSL handshake");
            }
            this.sslSocket.startHandshake();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + " Rewiring proxy streams after handshake");
            }
            this.proxySocket.setStreams(this.inputStream, this.outputStream);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + " Getting SSL InputStream");
            }
            this.inputStream = this.sslSocket.getInputStream();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + " Getting SSL OutputStream");
            }
            this.outputStream = this.sslSocket.getOutputStream();
            this.channelSocket = this.sslSocket;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(this.toString() + " SSL enabled");
            }
        }
        catch (Exception exception) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, exception.getMessage(), exception);
            }
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_sslFailed"));
            Object[] objectArray = new Object[]{exception.getMessage()};
            this.con.terminate(5, messageFormat.format(objectArray));
        }
    }

    final InputStream loadTrustStore(String string) {
        FileInputStream fileInputStream;
        block17: {
            block18: {
                fileInputStream = null;
                if (null != string) {
                    try {
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest(this.toString() + " Opening specified trust store: " + string);
                        }
                        fileInputStream = new FileInputStream(string);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine(this.toString() + " Trust store not found: " + fileNotFoundException.getMessage());
                        }
                        break block17;
                    }
                }
                string = System.getProperty("javax.net.ssl.trustStore");
                if (null != string) {
                    try {
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest(this.toString() + " Opening default trust store (from javax.net.ssl.trustStore): " + string);
                        }
                        fileInputStream = new FileInputStream(string);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine(this.toString() + " Trust store not found: " + fileNotFoundException.getMessage());
                        }
                        break block17;
                    }
                }
                try {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest(this.toString() + " Opening default trust store: " + JSSECACERTS);
                    }
                    fileInputStream = new FileInputStream(JSSECACERTS);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (!logger.isLoggable(Level.FINE)) break block18;
                    logger.fine(this.toString() + " Trust store not found: " + fileNotFoundException.getMessage());
                }
            }
            if (null == fileInputStream) {
                try {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest(this.toString() + " Opening default trust store: " + CACERTS);
                    }
                    fileInputStream = new FileInputStream(CACERTS);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (!logger.isLoggable(Level.FINE)) break block17;
                    logger.fine(this.toString() + " Trust store not found: " + fileNotFoundException.getMessage());
                }
            }
        }
        return fileInputStream;
    }

    final int read(byte[] byArray, int n, int n2) throws SQLServerException {
        try {
            return this.inputStream.read(byArray, n, n2);
        }
        catch (IOException iOException) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this.toString() + " read failed:" + iOException.getMessage());
            }
            this.con.terminate(3, iOException.getMessage());
            return 0;
        }
    }

    final void write(byte[] byArray, int n, int n2) throws SQLServerException {
        try {
            this.outputStream.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(this.toString() + " write failed:" + iOException.getMessage());
            }
            this.con.terminate(3, iOException.getMessage());
        }
    }

    final void flush() throws SQLServerException {
        try {
            this.outputStream.flush();
        }
        catch (IOException iOException) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(this.toString() + " flush failed:" + iOException.getMessage());
            }
            this.con.terminate(3, iOException.getMessage());
        }
    }

    final void close() {
        if (null != this.sslSocket) {
            this.disableSSL();
        }
        if (null != this.inputStream) {
            block13: {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(this.toString() + ": Closing inputStream...");
                }
                try {
                    this.inputStream.close();
                }
                catch (IOException iOException) {
                    if (!logger.isLoggable(Level.FINE)) break block13;
                    logger.log(Level.FINE, this.toString() + ": Ignored error closing inputStream", iOException);
                }
            }
            this.inputStream = null;
        }
        if (null != this.outputStream) {
            block14: {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(this.toString() + ": Closing outputStream...");
                }
                try {
                    this.outputStream.close();
                }
                catch (IOException iOException) {
                    if (!logger.isLoggable(Level.FINE)) break block14;
                    logger.log(Level.FINE, this.toString() + ": Ignored error closing outputStream", iOException);
                }
            }
            this.outputStream = null;
        }
        if (null != this.tcpSocket) {
            block15: {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(this.toString() + ": Closing TCP socket...");
                }
                try {
                    this.tcpSocket.close();
                }
                catch (IOException iOException) {
                    if (!logger.isLoggable(Level.FINE)) break block15;
                    logger.log(Level.FINE, this.toString() + ": Ignored error closing socket", iOException);
                }
            }
            this.tcpSocket = null;
        }
        this.isClosed = true;
    }

    void logPacket(byte[] byArray, int n, int n2, String string) {
        assert (0 <= n2 && n2 <= byArray.length);
        assert (0 <= n && n <= byArray.length);
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] cArray2 = new char[]{'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.'};
        char[] cArray3 = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.'};
        char[] cArray4 = new char[cArray3.length];
        System.arraycopy(cArray3, 0, cArray4, 0, cArray3.length);
        StringBuffer stringBuffer = new StringBuffer(string.length() + 4 * n2 + 4 * (1 + n2 / 16) + 80);
        stringBuffer.append(this.tcpSocket.getLocalAddress().toString() + ":" + this.tcpSocket.getLocalPort() + " SPID:" + this.spid + " " + string + "\r\n");
        int n3 = 0;
        while (true) {
            int n4;
            int n5;
            for (n5 = 0; n5 < 16 && n3 < n2; ++n5, ++n3) {
                n4 = (byArray[n + n3] + 256) % 256;
                cArray4[3 * n5] = cArray[n4 / 16];
                cArray4[3 * n5 + 1] = cArray[n4 % 16];
                cArray4[50 + n5] = cArray2[n4];
            }
            for (n4 = n5; n4 < 16; ++n4) {
                cArray4[3 * n4] = 32;
                cArray4[3 * n4 + 1] = 32;
            }
            stringBuffer.append(cArray4, 0, 50 + n5);
            if (n3 == n2) break;
            stringBuffer.append("\r\n");
        }
        packetLogger.finest(stringBuffer.toString());
    }

    private final class HostNameOverrideX509TrustManager
    implements X509TrustManager {
        private final Logger logger;
        private final String logContext;
        private final X509TrustManager defaultTrustManager;
        private String hostName;

        HostNameOverrideX509TrustManager(TDSChannel tDSChannel2, X509TrustManager x509TrustManager, String string) {
            this.logger = tDSChannel2.getLogger();
            this.logContext = tDSChannel2.toString() + " (HostNameOverrideX509TrustManager):";
            this.defaultTrustManager = x509TrustManager;
            this.hostName = string.toLowerCase();
        }

        private String parseCommonName(String string) {
            int n = string.indexOf("cn=");
            if (n == -1) {
                return null;
            }
            string = string.substring(n + 3);
            for (n = 0; n < string.length() && string.charAt(n) != ','; ++n) {
            }
            String string2 = string.substring(0, n);
            if (string2.length() > 1 && '\"' == string2.charAt(0)) {
                string2 = '\"' == string2.charAt(string2.length() - 1) ? string2.substring(1, string2.length() - 1) : null;
            }
            return string2;
        }

        private void validateServerNameInCertificate(String string) throws CertificateException {
            String string2;
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.logContext + " Validating the server name:" + this.hostName);
            }
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.logContext + " The DN name in certificate:" + string);
            }
            if (null == (string2 = this.parseCommonName(string))) {
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.finer(this.logContext + " Failed to parse the subject name from the certificate or certificate subject name is empty.");
                }
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_certNameFailed"));
                Object[] objectArray = new Object[]{new String(this.hostName), new String(string)};
                throw new CertificateException(messageFormat.format(objectArray));
            }
            if (!string2.startsWith(this.hostName)) {
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.finer(this.logContext + " The name in certificate does not start with the server name.");
                }
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_certNameFailed"));
                Object[] objectArray = new Object[]{new String(this.hostName), new String(string2)};
                throw new CertificateException(messageFormat.format(objectArray));
            }
            if (this.hostName.length() != string2.length() && '.' != string2.charAt(this.hostName.length())) {
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.finer(this.logContext + " The name in certificate does not start with the server name and end in a period(.).");
                }
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_certNameFailed"));
                Object[] objectArray = new Object[]{new String(this.hostName), new String(string2)};
                throw new CertificateException(messageFormat.format(objectArray));
            }
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer(this.logContext + " The name in certificate:" + string2 + " validated.");
            }
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.logContext + " Forwarding ClientTrusted.");
            }
            this.defaultTrustManager.checkClientTrusted(x509CertificateArray, string);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.logContext + " Forwarding Trusting server certificate");
            }
            this.defaultTrustManager.checkServerTrusted(x509CertificateArray, string);
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.logContext + " default serverTrusted succeeded proceeding with server name validation");
            }
            this.validateServerNameInCertificate(x509CertificateArray[0].getSubjectX500Principal().getName("canonical"));
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.defaultTrustManager.getAcceptedIssuers();
        }
    }

    private final class PermissiveX509TrustManager
    implements X509TrustManager {
        private final TDSChannel tdsChannel;
        private final Logger logger;
        private final String logContext;

        PermissiveX509TrustManager(TDSChannel tDSChannel2) {
            this.tdsChannel = tDSChannel2;
            this.logger = tDSChannel2.getLogger();
            this.logContext = tDSChannel2.toString() + " (PermissiveX509TrustManager):";
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer(this.logContext + " Trusting client certificate (!)");
            }
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer(this.logContext + " Trusting server certificate");
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    private class ProxySocket
    extends Socket {
        private final TDSChannel tdsChannel;
        private final Logger logger;
        private final String logContext;
        private final ProxyInputStream proxyInputStream;
        private final ProxyOutputStream proxyOutputStream;

        ProxySocket(TDSChannel tDSChannel2) {
            this.tdsChannel = tDSChannel2;
            this.logger = tDSChannel2.getLogger();
            this.logContext = tDSChannel2.toString() + " (ProxySocket):";
            SSLHandshakeOutputStream sSLHandshakeOutputStream = new SSLHandshakeOutputStream(tDSChannel2);
            SSLHandshakeInputStream sSLHandshakeInputStream = new SSLHandshakeInputStream(tDSChannel2, sSLHandshakeOutputStream);
            this.proxyOutputStream = new ProxyOutputStream(sSLHandshakeOutputStream);
            this.proxyInputStream = new ProxyInputStream(sSLHandshakeInputStream);
        }

        void setStreams(InputStream inputStream, OutputStream outputStream) {
            this.proxyInputStream.setFilteredStream(inputStream);
            this.proxyOutputStream.setFilteredStream(outputStream);
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.logContext + " Getting input stream");
            }
            return this.proxyInputStream;
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.logContext + " Getting output stream");
            }
            return this.proxyOutputStream;
        }

        @Override
        public InetAddress getInetAddress() {
            return this.tdsChannel.tcpSocket.getInetAddress();
        }

        @Override
        public boolean getKeepAlive() throws SocketException {
            return this.tdsChannel.tcpSocket.getKeepAlive();
        }

        @Override
        public InetAddress getLocalAddress() {
            return this.tdsChannel.tcpSocket.getLocalAddress();
        }

        @Override
        public int getLocalPort() {
            return this.tdsChannel.tcpSocket.getLocalPort();
        }

        @Override
        public SocketAddress getLocalSocketAddress() {
            return this.tdsChannel.tcpSocket.getLocalSocketAddress();
        }

        @Override
        public boolean getOOBInline() throws SocketException {
            return this.tdsChannel.tcpSocket.getOOBInline();
        }

        @Override
        public int getPort() {
            return this.tdsChannel.tcpSocket.getPort();
        }

        @Override
        public int getReceiveBufferSize() throws SocketException {
            return this.tdsChannel.tcpSocket.getReceiveBufferSize();
        }

        @Override
        public SocketAddress getRemoteSocketAddress() {
            return this.tdsChannel.tcpSocket.getRemoteSocketAddress();
        }

        @Override
        public boolean getReuseAddress() throws SocketException {
            return this.tdsChannel.tcpSocket.getReuseAddress();
        }

        @Override
        public int getSendBufferSize() throws SocketException {
            return this.tdsChannel.tcpSocket.getSendBufferSize();
        }

        @Override
        public int getSoLinger() throws SocketException {
            return this.tdsChannel.tcpSocket.getSoLinger();
        }

        @Override
        public int getSoTimeout() throws SocketException {
            return this.tdsChannel.tcpSocket.getSoTimeout();
        }

        @Override
        public boolean getTcpNoDelay() throws SocketException {
            return this.tdsChannel.tcpSocket.getTcpNoDelay();
        }

        @Override
        public int getTrafficClass() throws SocketException {
            return this.tdsChannel.tcpSocket.getTrafficClass();
        }

        @Override
        public boolean isBound() {
            return true;
        }

        @Override
        public boolean isClosed() {
            return false;
        }

        @Override
        public boolean isConnected() {
            return true;
        }

        @Override
        public boolean isInputShutdown() {
            return false;
        }

        @Override
        public boolean isOutputShutdown() {
            return false;
        }

        @Override
        public String toString() {
            return this.tdsChannel.tcpSocket.toString();
        }

        @Override
        public SocketChannel getChannel() {
            return null;
        }

        @Override
        public void bind(SocketAddress socketAddress) throws IOException {
            this.logger.finer(this.logContext + " Disallowed call to bind.  Throwing IOException.");
            throw new IOException();
        }

        @Override
        public void connect(SocketAddress socketAddress) throws IOException {
            this.logger.finer(this.logContext + " Disallowed call to connect (without timeout).  Throwing IOException.");
            throw new IOException();
        }

        @Override
        public void connect(SocketAddress socketAddress, int n) throws IOException {
            this.logger.finer(this.logContext + " Disallowed call to connect (with timeout).  Throwing IOException.");
            throw new IOException();
        }

        @Override
        public void close() throws IOException {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer(this.logContext + " Ignoring close");
            }
        }

        @Override
        public void setReceiveBufferSize(int n) throws SocketException {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer(this.toString() + " Ignoring setReceiveBufferSize size:" + n);
            }
        }

        @Override
        public void setSendBufferSize(int n) throws SocketException {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer(this.toString() + " Ignoring setSendBufferSize size:" + n);
            }
        }

        @Override
        public void setReuseAddress(boolean bl) throws SocketException {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer(this.toString() + " Ignoring setReuseAddress");
            }
        }

        @Override
        public void setSoLinger(boolean bl, int n) throws SocketException {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer(this.toString() + " Ignoring setSoLinger");
            }
        }

        @Override
        public void setSoTimeout(int n) throws SocketException {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer(this.toString() + " Ignoring setSoTimeout");
            }
        }

        @Override
        public void setTcpNoDelay(boolean bl) throws SocketException {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer(this.toString() + " Ignoring setTcpNoDelay");
            }
        }

        @Override
        public void setTrafficClass(int n) throws SocketException {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer(this.toString() + " Ignoring setTrafficClass");
            }
        }

        @Override
        public void shutdownInput() throws IOException {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer(this.toString() + " Ignoring shutdownInput");
            }
        }

        @Override
        public void shutdownOutput() throws IOException {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer(this.toString() + " Ignoring shutdownOutput");
            }
        }

        @Override
        public void sendUrgentData(int n) throws IOException {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer(this.toString() + " Ignoring sendUrgentData");
            }
        }

        @Override
        public void setKeepAlive(boolean bl) throws SocketException {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer(this.toString() + " Ignoring setKeepAlive");
            }
        }

        @Override
        public void setOOBInline(boolean bl) throws SocketException {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer(this.toString() + " Ignoring setOOBInline");
            }
        }
    }

    final class ProxyOutputStream
    extends OutputStream {
        private OutputStream filteredStream;
        private final byte[] singleByte = new byte[1];

        ProxyOutputStream(OutputStream outputStream) {
            this.filteredStream = outputStream;
        }

        final void setFilteredStream(OutputStream outputStream) {
            this.filteredStream = outputStream;
        }

        @Override
        public void close() throws IOException {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + " Closing");
            }
            this.filteredStream.close();
        }

        @Override
        public void flush() throws IOException {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + " Flushing");
            }
            this.filteredStream.flush();
        }

        @Override
        public void write(int n) throws IOException {
            this.singleByte[0] = (byte)(n & 0xFF);
            this.writeInternal(this.singleByte, 0, this.singleByte.length);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.writeInternal(byArray, 0, byArray.length);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.writeInternal(byArray, n, n2);
        }

        private void writeInternal(byte[] byArray, int n, int n2) throws IOException {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + " Writing " + n2 + " bytes");
            }
            this.filteredStream.write(byArray, n, n2);
        }
    }

    private final class ProxyInputStream
    extends InputStream {
        private InputStream filteredStream;
        private final byte[] oneByte = new byte[1];

        ProxyInputStream(InputStream inputStream) {
            this.filteredStream = inputStream;
        }

        final void setFilteredStream(InputStream inputStream) {
            this.filteredStream = inputStream;
        }

        @Override
        public long skip(long l) throws IOException {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + " Skipping " + l + " bytes");
            }
            long l2 = this.filteredStream.skip(l);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + " Skipped " + l + " bytes");
            }
            return l2;
        }

        @Override
        public int available() throws IOException {
            int n = this.filteredStream.available();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + " " + n + " bytes available");
            }
            return n;
        }

        @Override
        public int read() throws IOException {
            int n;
            while (0 == (n = this.readInternal(this.oneByte, 0, this.oneByte.length))) {
            }
            assert (1 == n || -1 == n);
            return 1 == n ? this.oneByte[0] : -1;
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.readInternal(byArray, 0, byArray.length);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.readInternal(byArray, n, n2);
        }

        private int readInternal(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + " Reading " + n2 + " bytes");
            }
            try {
                n3 = this.filteredStream.read(byArray, n, n2);
            }
            catch (IOException iOException) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(this.toString() + " " + iOException.getMessage());
                }
                logger.finer(this.toString() + " Reading bytes threw exception:" + iOException.getMessage());
                throw iOException;
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + " Read " + n3 + " bytes");
            }
            return n3;
        }

        @Override
        public boolean markSupported() {
            boolean bl = this.filteredStream.markSupported();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + " Returning markSupported: " + bl);
            }
            return bl;
        }

        @Override
        public void mark(int n) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + " Marking next " + n + " bytes");
            }
            this.filteredStream.mark(n);
        }

        @Override
        public void reset() throws IOException {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + " Resetting to previous mark");
            }
            this.filteredStream.reset();
        }

        @Override
        public void close() throws IOException {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + " Closing");
            }
            this.filteredStream.close();
        }
    }

    private class SSLHandshakeOutputStream
    extends OutputStream {
        private final TDSWriter tdsWriter;
        private boolean messageStarted;
        private final Logger logger;
        private final String logContext;
        private final byte[] singleByte = new byte[1];

        SSLHandshakeOutputStream(TDSChannel tDSChannel2) {
            this.tdsWriter = tDSChannel2.getWriter();
            this.messageStarted = false;
            this.logger = tDSChannel2.getLogger();
            this.logContext = tDSChannel2.toString() + " (SSLHandshakeOutputStream):";
        }

        @Override
        public void flush() throws IOException {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.logContext + " Ignored a request to flush the stream");
            }
        }

        void endMessage() throws SQLServerException {
            assert (this.messageStarted);
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.logContext + " Finishing TDS message");
            }
            this.tdsWriter.endMessage();
            this.messageStarted = false;
        }

        @Override
        public void write(int n) throws IOException {
            this.singleByte[0] = (byte)(n & 0xFF);
            this.writeInternal(this.singleByte, 0, this.singleByte.length);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.writeInternal(byArray, 0, byArray.length);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.writeInternal(byArray, n, n2);
        }

        private void writeInternal(byte[] byArray, int n, int n2) throws IOException {
            try {
                if (!this.messageStarted) {
                    if (this.logger.isLoggable(Level.FINEST)) {
                        this.logger.finest(this.logContext + " Starting new TDS packet...");
                    }
                    this.tdsWriter.startMessage((byte)18);
                    this.messageStarted = true;
                }
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest(this.logContext + " Writing " + n2 + " bytes...");
                }
                this.tdsWriter.writeBytes(byArray, n, n2);
            }
            catch (SQLServerException sQLServerException) {
                this.logger.finer(this.logContext + " Writing bytes threw exception:" + sQLServerException.getMessage());
                throw new IOException(sQLServerException.getMessage());
            }
        }
    }

    private class SSLHandshakeInputStream
    extends InputStream {
        private final TDSReader tdsReader;
        private final SSLHandshakeOutputStream sslHandshakeOutputStream;
        private final Logger logger;
        private final String logContext;
        private final byte[] oneByte = new byte[1];

        SSLHandshakeInputStream(TDSChannel tDSChannel2, SSLHandshakeOutputStream sSLHandshakeOutputStream) {
            this.tdsReader = tDSChannel2.getReader();
            this.sslHandshakeOutputStream = sSLHandshakeOutputStream;
            this.logger = tDSChannel2.getLogger();
            this.logContext = tDSChannel2.toString() + " (SSLHandshakeInputStream):";
        }

        private final void ensureSSLPayload() throws IOException {
            if (0 == this.tdsReader.available()) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest(this.logContext + " No handshake response bytes available. Flushing SSL handshake output stream.");
                }
                try {
                    this.sslHandshakeOutputStream.endMessage();
                }
                catch (SQLServerException sQLServerException) {
                    this.logger.finer(this.logContext + " Ending TDS message threw exception:" + sQLServerException.getMessage());
                    throw new IOException(sQLServerException.getMessage());
                }
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest(this.logContext + " Reading first packet of SSL handshake response");
                }
                try {
                    this.tdsReader.readPacket();
                }
                catch (SQLServerException sQLServerException) {
                    this.logger.finer(this.logContext + " Reading response packet threw exception:" + sQLServerException.getMessage());
                    throw new IOException(sQLServerException.getMessage());
                }
            }
        }

        @Override
        public long skip(long l) throws IOException {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.logContext + " Skipping " + l + " bytes...");
            }
            if (l <= 0L) {
                return 0L;
            }
            if (l > Integer.MAX_VALUE) {
                l = Integer.MAX_VALUE;
            }
            this.ensureSSLPayload();
            try {
                this.tdsReader.skip((int)l);
            }
            catch (SQLServerException sQLServerException) {
                this.logger.finer(this.logContext + " Skipping bytes threw exception:" + sQLServerException.getMessage());
                throw new IOException(sQLServerException.getMessage());
            }
            return l;
        }

        @Override
        public int read() throws IOException {
            int n;
            while (0 == (n = this.readInternal(this.oneByte, 0, this.oneByte.length))) {
            }
            assert (1 == n || -1 == n);
            return 1 == n ? this.oneByte[0] : -1;
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.readInternal(byArray, 0, byArray.length);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.readInternal(byArray, n, n2);
        }

        private int readInternal(byte[] byArray, int n, int n2) throws IOException {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.logContext + " Reading " + n2 + " bytes...");
            }
            this.ensureSSLPayload();
            try {
                this.tdsReader.readBytes(byArray, n, n2);
            }
            catch (SQLServerException sQLServerException) {
                this.logger.finer(this.logContext + " Reading bytes threw exception:" + sQLServerException.getMessage());
                throw new IOException(sQLServerException.getMessage());
            }
            return n2;
        }
    }
}

