
#ifndef _PCH_H_INCLUDED_
#define _PCH_H_INCLUDED_

#ifdef WIN32

// Disable the 'nonstandard extension used' warning. The use of zero-sized
// arrays is allowed.
#pragma warning(disable:4200)

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <wtypes.h>
#include <winsock2.h>
#include <ws2tcpip.h>

#endif // WIN32

#include <boost/format.hpp>

#include <cassert>

typedef boost::format   fmt;

typedef unsigned char       uint8_t;
typedef unsigned short      uint16_t;
typedef unsigned int        uint32_t;
#ifdef WIN32
typedef unsigned long long  uint64_t;
#endif

#define countof(x) (sizeof((x)) / sizeof((x)[0]))

#include "debug.h"

#ifdef assert
#define ASSERT assert
#endif // assert

#endif // _PCH_H_INCLUDED_
