#% define beta_tag rc2
%define patchleveltag .53
%define baseversion 4.2
%bcond_without tests

Version: %{baseversion}%{patchleveltag}
Name: bash
Summary: The GNU Bourne Again shell
%define base_release .1
Release: 1%{?dist}%{?base_release}
Group: System Environment/Shells
License: GPLv3+
Url: http://www.gnu.org/software/bash
Source0: ftp://ftp.gnu.org/gnu/bash/bash-%{baseversion}.tar.gz

# For now there isn't any doc
#Source2: ftp://ftp.gnu.org/gnu/bash/bash-doc-%{version}.tar.gz

Source1: dot-bashrc
Source2: dot-bash_profile
Source3: dot-bash_logout
Source999: fivextra.tar.bz2

# Official upstream patches
Patch001: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-001
Patch002: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-002
Patch003: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-003
Patch004: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-004
Patch005: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-005
Patch006: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-006
Patch007: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-007
Patch008: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-008
Patch009: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-009
Patch010: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-010
Patch011: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-011
Patch012: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-012
Patch013: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-013
Patch014: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-014
Patch015: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-015
Patch016: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-016
Patch017: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-017
Patch018: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-018
Patch019: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-019
Patch020: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-020
Patch021: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-021
Patch022: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-022
Patch023: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-023
Patch024: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-024
Patch025: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-025
Patch026: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-026
Patch027: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-027
Patch028: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-028
Patch029: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-029
Patch030: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-030
Patch031: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-031
Patch032: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-032
Patch033: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-033
Patch034: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-034
Patch035: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-035
Patch036: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-036
Patch037: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-037
Patch038: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-038
Patch039: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-039
Patch040: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-040
Patch041: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-041
Patch042: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-042
Patch043: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-043
Patch044: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-044
Patch045: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-045
Patch046: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-046
Patch047: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-047
Patch048: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-048
Patch049: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-049
# 1146326 - cve-2014-7169
# we want to keep these patches from Florian Weimer
# instead of the official ones, to match the ()/%%
# detail we already have applied across RHELs and not to
# create incompatibilities in the future

#patchlevel 50
Patch050: bash-4.2-cve-2014-7169-1.patch
#patchlevel 51
Patch051: bash-4.2-cve-2014-7169-2.patch

Patch052: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-052
Patch053: ftp://ftp.gnu.org/pub/gnu/bash/bash-4.2-patches/bash42-053


# Other patches
Patch101: bash-2.02-security.patch
Patch102: bash-2.03-paths.patch
Patch103: bash-2.03-profile.patch
Patch104: bash-2.05a-interpreter.patch
Patch105: bash-2.05b-debuginfo.patch
Patch106: bash-2.05b-manso.patch
Patch107: bash-2.05b-pgrp_sync.patch
Patch108: bash-2.05b-readline-oom.patch
Patch109: bash-2.05b-xcc.patch
Patch110: bash-3.2-audit.patch
Patch111: bash-3.2-ssh_source_bash.patch
Patch112: bash-bashbug.patch
Patch113: bash-infotags.patch
Patch114: bash-requires.patch
Patch115: bash-setlocale.patch
Patch116: bash-tty-tests.patch

# 484809, check if interp section is NOBITS
Patch117: bash-4.0-nobits.patch

# Do the same CFLAGS in generated Makefile in examples
Patch118: bash-4.1-examples.patch

# Builtins like echo and printf won't report errors
# when output does not succeed due to EPIPE
Patch119: bash-4.1-broken_pipe.patch

# Enable system-wide .bash_logout for login shells
Patch120: bash-4.2-rc2-logout.patch

# Static analyzis shows some issues in bash-2.05a-interpreter.patch
Patch121: bash-4.2-coverity.patch

# Don't call malloc in signal handler
Patch122: bash-4.1-defer-sigchld-trap.patch

# 799958, updated info about trap
Patch123: bash-4.2-manpage_trap.patch

# 695656, block the signal and unblock it after the new handler is installed
Patch124: bash-4.2-signal.patch

# https://www.securecoding.cert.org/confluence/display/seccode/INT32-C.+Ensure+that+operations+on+signed+integers+do+not+result+in+overflow
Patch125: bash-4.2-size_type.patch

# 903833, Fix missing close(), fixes fd leaks
Patch126: bash-4.2-missing_closes.patch

# Base patches
Patch70275: bash-4.1-mkbuiltins-cross.patch

BuildRequires: texinfo bison
BuildRequires: ncurses-devel
BuildRequires: autoconf, gettext
Conflicts: filesystem < 3
Provides: /bin/sh
Provides: /bin/bash

%description
The GNU Bourne Again shell (Bash) is a shell or command language
interpreter that is compatible with the Bourne shell (sh). Bash
incorporates useful features from the Korn shell (ksh) and the C shell
(csh). Most sh scripts can be run by bash without modification.

%package doc
Summary: Documentation files for %{name}
Group: Development/Languages
Requires: %{name} = %{version}-%{release}

%description doc
This package contains documentation files for %{name}.

%package fivextra
Summary: Test for %{name} package
Group:  fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}.

%define pkgdocdir %{_datadir}/doc/%{name}-%{version}

%prep
#%setup -q -a 2
%setup -q -n %{name}-%{baseversion} -a 999

# Official upstream patches
%patch001 -p0 -b .001
%patch002 -p0 -b .002
%patch003 -p0 -b .003
%patch004 -p0 -b .004
%patch005 -p0 -b .005
%patch006 -p0 -b .006
%patch007 -p0 -b .007
%patch008 -p0 -b .008
%patch009 -p0 -b .009
%patch010 -p0 -b .010
%patch011 -p0 -b .011
%patch012 -p0 -b .012
%patch013 -p0 -b .013
%patch014 -p0 -b .014
%patch015 -p0 -b .015
%patch016 -p0 -b .016
%patch017 -p0 -b .017
%patch018 -p0 -b .018
%patch019 -p0 -b .019
%patch020 -p0 -b .020
%patch021 -p0 -b .021
%patch022 -p0 -b .022
%patch023 -p0 -b .023
%patch024 -p0 -b .024
%patch025 -p0 -b .025
%patch026 -p0 -b .026
%patch027 -p0 -b .027
%patch028 -p0 -b .028
%patch029 -p0 -b .029
%patch030 -p0 -b .030
%patch031 -p0 -b .031
%patch032 -p0 -b .032
%patch033 -p0 -b .033
%patch034 -p0 -b .034
%patch035 -p0 -b .035
%patch036 -p0 -b .036
%patch037 -p0 -b .037
%patch038 -p0 -b .038
%patch039 -p0 -b .039
%patch040 -p0 -b .040
%patch041 -p0 -b .041
%patch042 -p0 -b .042
%patch043 -p0 -b .043
%patch044 -p0 -b .044
%patch045 -p0 -b .045
%patch046 -p0 -b .046
%patch047 -p0 -b .047
%patch048 -p0 -b .048
%patch049 -p0 -b .049
%patch050 -p0 -b .7169-1
%patch051 -p0 -b .7169-2
%patch052 -p0 -b .052
%patch053 -p0 -b .053

# Other patches
%patch101 -p1 -b .security
%patch102 -p1 -b .paths
%patch103 -p1 -b .profile
%patch104 -p1 -b .interpreter
%patch105 -p1 -b .debuginfo
%patch106 -p1 -b .manso
%patch107 -p1 -b .pgrp_sync
%patch108 -p1 -b .readline_oom
%patch109 -p1 -b .xcc
%patch110 -p1 -b .audit
%patch111 -p1 -b .ssh_source_bash
%patch112 -p1 -b .bashbug
%patch113 -p1 -b .infotags
%patch114 -p1 -b .requires
%patch115 -p1 -b .setlocale
%patch116 -p1 -b .tty_tests
%patch117 -p1 -b .nobits
%patch118 -p1 -b .examples
%patch119 -p1 -b .broken_pipe
%patch120 -p1 -b .logout
%patch121 -p1 -b .coverity
%patch122 -p1 -b .defer_sigchld_trap
%patch123 -p1
%patch124 -p1 -b .signal
%patch125 -p1 -b .size_type
%patch126 -p1 -b .missing_closes
%patch70275 -p1

echo %{version} > _distribution
echo %{release} > _patchlevel

%build
autoconf
%configure --with-bash-malloc=no --with-afs

# Recycles pids is neccessary. When bash's last fork's pid was X
# and new fork's pid is also X, bash has to wait for this same pid.
# Without Recycles pids bash will not wait.
make "CPPFLAGS=-D_GNU_SOURCE -DRECYCLES_PIDS -DDEFAULT_PATH_VALUE='\"/usr/local/bin:/usr/bin\"' `getconf LFS_CFLAGS`"

pushd fivextra
make all
popd

%install
rm -rf $RPM_BUILD_ROOT

if [ -e autoconf ]; then
  # Yuck. We're using autoconf 2.1x.
  export PATH=.:$PATH
fi

# Fix bug #83776
perl -pi -e 's,bashref\.info,bash.info,' doc/bashref.info

make DESTDIR=$RPM_BUILD_ROOT install

mkdir -p $RPM_BUILD_ROOT/etc

# make manpages for bash builtins as per suggestion in DOC/README
pushd doc
sed -e '
/^\.SH NAME/, /\\- bash built-in commands, see \\fBbash\\fR(1)$/{
/^\.SH NAME/d
s/^bash, //
s/\\- bash built-in commands, see \\fBbash\\fR(1)$//
s/,//g
b
}
d
' builtins.1 > man.pages
for i in echo pwd test kill; do
  perl -pi -e "s,$i,,g" man.pages
  perl -pi -e "s,  , ,g" man.pages
done

install -c -m 644 builtins.1 ${RPM_BUILD_ROOT}%{_mandir}/man1/builtins.1

for i in `cat man.pages` ; do
  echo .so man1/builtins.1 > ${RPM_BUILD_ROOT}%{_mandir}/man1/$i.1
  chmod 0644 ${RPM_BUILD_ROOT}%{_mandir}/man1/$i.1
done
popd

# Link bash man page to sh so that man sh works.
ln -s bash.1 ${RPM_BUILD_ROOT}%{_mandir}/man1/sh.1

# Not for printf, true and false (conflict with coreutils)
rm -f $RPM_BUILD_ROOT/%{_mandir}/man1/printf.1
rm -f $RPM_BUILD_ROOT/%{_mandir}/man1/true.1
rm -f $RPM_BUILD_ROOT/%{_mandir}/man1/false.1

ln -sf bash $RPM_BUILD_ROOT%{_bindir}/sh
rm -f $RPM_BUILD_ROOT%{_infodir}/dir
mkdir -p $RPM_BUILD_ROOT/etc/skel
install -c -m644 %SOURCE1 $RPM_BUILD_ROOT/etc/skel/.bashrc
install -c -m644 %SOURCE2 $RPM_BUILD_ROOT/etc/skel/.bash_profile
install -c -m644 %SOURCE3 $RPM_BUILD_ROOT/etc/skel/.bash_logout
LONG_BIT=$(getconf LONG_BIT)
mv $RPM_BUILD_ROOT%{_bindir}/bashbug \
   $RPM_BUILD_ROOT%{_bindir}/bashbug-"${LONG_BIT}"
ln -s bashbug-"${LONG_BIT}" $RPM_BUILD_ROOT%{_bindir}/bashbug
ln -s bashbug.1 $RPM_BUILD_ROOT/%{_mandir}/man1/bashbug-"$LONG_BIT".1

# Fix missing sh-bangs in example scripts (bug #225609).
for script in \
  examples/scripts/krand.bash \
  examples/scripts/bcsh.sh \
  examples/scripts/precedence \
  examples/scripts/shprompt
do
  cp "$script" "$script"-orig
  echo '#!/bin/bash' > "$script"
  cat "$script"-orig >> "$script"
  rm -f "$script"-orig
done

# bug #820192, need to add execable alternatives for regular built-ins
for ea in alias bg cd command fc fg getopts jobs read umask unalias wait
do
  cat <<EOF > "$RPM_BUILD_ROOT"/%{_bindir}/"$ea"
#!/bin/sh
builtin $ea "\$@"
EOF
chmod +x "$RPM_BUILD_ROOT"/%{_bindir}/"$ea"
done

%find_lang %{name}

# copy doc to /usr/share/doc
cat /dev/null > %{name}-doc.files
mkdir -p $RPM_BUILD_ROOT/%{pkgdocdir}/doc
cp -p COPYING $RPM_BUILD_ROOT/%{pkgdocdir}
# loadables aren't buildable
rm -rf examples/loadables
for file in CHANGES COMPAT NEWS NOTES POSIX examples\
    doc/{FAQ,INTRO,rose94.pdf,article.{pdf,txt},bashref.{html,pdf}}
do
  cp -rp "$file" $RPM_BUILD_ROOT/%{pkgdocdir}/"$file"
  echo "%%doc %{pkgdocdir}/$file" >> %{name}-doc.files
done
echo "%%doc %{pkgdocdir}/doc" >> %{name}-doc.files

# Steps to package the bash tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd


%if %{with tests}
%check
make check
%endif

%clean
rm -rf $RPM_BUILD_ROOT

# ***** bash doesn't use install-info. It's always listed in %{_infodir}/dir
# to prevent prereq loops

# post is in lua so that we can run it without any external deps.  Helps
# for bootstrapping a new install.
# Jesse Keating 2009-01-29 (code from Ignacio Vazquez-Abrams)
# Roman Rakus 2011-11-07 (code from Sergey Romanov) #740611
%post -p <lua>
nl        = '\n'
sh        = '/bin/sh'..nl
bash      = '/bin/bash'..nl
f = io.open('/etc/shells', 'a+')
if f then
  local shells = nl..f:read('*all')..nl
  if not shells:find(nl..sh) then f:write(sh) end
  if not shells:find(nl..bash) then f:write(bash) end
  f:close()
end

%postun -p <lua>
-- Run it only if we are uninstalling
if arg[2] == "0"
then
  t={}
  for line in io.lines("/etc/shells")
  do
    if line ~= "/bin/bash" and line ~= "/bin/sh"
    then
      table.insert(t,line)
    end
  end

  f = io.open("/etc/shells", "w+")
  for n,line in pairs(t)
  do
    f:write(line.."\n")
  end
  f:close()
end

%files -f %{name}.lang
%defattr(-,root,root)
%config(noreplace) /etc/skel/.b*
%{_bindir}/sh
%{_bindir}/bash
%{_bindir}/alias
%{_bindir}/bg
%{_bindir}/cd
%{_bindir}/command
%{_bindir}/fc
%{_bindir}/fg
%{_bindir}/getopts
%{_bindir}/jobs
%{_bindir}/read
%{_bindir}/umask
%{_bindir}/unalias
%{_bindir}/wait
%dir %{pkgdocdir}/
%doc %{pkgdocdir}/COPYING
%attr(0755,root,root) %{_bindir}/bashbug*
%{_infodir}/bash.info*
%{_mandir}/*/*
%{_mandir}/*/..1*

%files doc -f %{name}-doc.files
%defattr(-, root, root)

# For now there isn't any doc
#%doc doc/*.ps doc/*.0 doc/*.html doc/article.txt

%files fivextra
%{prefix}

%changelog
* Wed May 08 2013 baseuser@ibm.com
- Base-8.x spec file
