Summary: A library for editing typed command lines
Name: readline
Version: 6.2
%define base_release .2
Release: 6%{?dist}%{?base_release}
License: GPLv3+
Group: System Environment/Libraries
URL: http://cnswww.cns.cwru.edu/php/chet/readline/rltop.html
Source: ftp://ftp.gnu.org/gnu/readline/readline-%{version}.tar.gz
Source999: fivextra.tar.bz2
# upstream patches
Patch1: ftp://ftp.cwru.edu/pub/bash/readline-6.2-patches/readline62-001
# fix file permissions, remove RPATH, use CFLAGS
Patch20: readline-6.2-shlib.patch
# add TTY input audit support
Patch21: readline-6.1-audit.patch
# isxdigit should not be defined as macro
Patch22:  readline-6.2-cppmacro.patch
# add workaround for problem in gdb
# in new version of readline needs to be deleted
Patch23:  readline-6.2-gdb.patch
Requires(post): /sbin/install-info
Requires(preun): /sbin/install-info
BuildRequires: ncurses-devel
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

%description
The Readline library provides a set of functions that allow users to
edit command lines. Both Emacs and vi editing modes are available. The
Readline library includes additional functions for maintaining a list
of previously-entered command lines for recalling or editing those
lines, and for performing csh-like history expansion on previous
commands.

%package devel
Summary: Files needed to develop programs which use the readline library
Group: Development/Libraries
Requires: %{name} = %{version}-%{release}
Requires: ncurses-devel
Requires(post): /sbin/install-info
Requires(preun): /sbin/install-info

%description devel
The Readline library provides a set of functions that allow users to
edit typed command lines. If you want to develop programs that will
use the readline library, you need to have the readline-devel package
installed. You also need to have the readline package installed.

%package static
Summary: Static libraries for the readline library
Group: Development/Libraries
Requires: %{name}-devel = %{version}-%{release}

%description static
The readline-static package contains the static version of the readline
library.

%package fivextra 
Summary: Test for %{name} package
Group: fivextra
Prefix: /opt/fiv/ltp
Requires: expect

%description fivextra
This package contains testcases for %{name}

%prep
%setup -q %{name}-%{version} -a 999
%patch1 -p0
%patch20 -p1 -b .shlib
%patch21 -p1 -b .audit
%patch22 -p1 -b .cppmacro
%patch23 -p1 -b .gdb

pushd examples
rm -f rlfe/configure
iconv -f iso8859-1 -t utf8 -o rl-fgets.c{_,}
touch -r rl-fgets.c{,_}
mv -f rl-fgets.c{_,}
popd

%build
export CPPFLAGS="-I%{_includedir}/ncurses"
%configure
make %{?_smp_mflags}

pushd fivextra
make all
popd

%install
rm -rf $RPM_BUILD_ROOT

make DESTDIR=$RPM_BUILD_ROOT install

mkdir $RPM_BUILD_ROOT/%{_lib}
mv $RPM_BUILD_ROOT%{_libdir}/libreadline.so.* $RPM_BUILD_ROOT/%{_lib}
for l in $RPM_BUILD_ROOT%{_libdir}/libreadline.so; do
    ln -sf $(echo %{_libdir} | \
        sed 's,\(^/\|\)[^/][^/]*,..,g')/%{_lib}/$(readlink $l) $l
done

rm -rf $RPM_BUILD_ROOT%{_datadir}/readline
rm -f $RPM_BUILD_ROOT%{_infodir}/dir*

#Steps to package readline tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

find $RPM_BUILD_ROOT/%{fivdir}/%{name} -name '*.c' | xargs rm -rf

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%clean
rm -rf $RPM_BUILD_ROOT

%post
/sbin/ldconfig
/sbin/install-info %{_infodir}/history.info.gz %{_infodir}/dir &> /dev/null
/sbin/install-info %{_infodir}/rluserman.info.gz %{_infodir}/dir &> /dev/null
:

%postun -p /sbin/ldconfig

%preun
if [ $1 = 0 ]; then
   /sbin/install-info --delete %{_infodir}/history.info.gz %{_infodir}/dir &> /dev/null
   /sbin/install-info --delete %{_infodir}/rluserman.info.gz %{_infodir}/dir &> /dev/null
fi
:

%post devel
/sbin/install-info %{_infodir}/readline.info.gz %{_infodir}/dir &> /dev/null
:

%preun devel
if [ $1 = 0 ]; then
   /sbin/install-info --delete %{_infodir}/readline.info.gz %{_infodir}/dir &> /dev/null
fi
:

%files
%defattr(-,root,root,-)
%doc CHANGES COPYING NEWS README USAGE
/%{_lib}/libreadline*.so.*
%{_libdir}/libhistory*.so.*
%{_infodir}/history.info*
%{_infodir}/rluserman.info*

%files devel
%defattr(-,root,root,-)
%doc examples/*.c examples/*.h examples/rlfe
%{_includedir}/readline
%{_libdir}/lib*.so
%{_mandir}/man3/*
%{_infodir}/readline.info*

%files static
%defattr(-,root,root,-)
%{_libdir}/lib*.a

%files fivextra
%{prefix}

%changelog
* Thu May 23 2013 baseuser@ibm.com
- Base-8.x spec file
