# Xen is only available on a limited number of architectures
%ifarch %{ix86} x86_64 ia64
%global have_xen 1
%else
%global have_xen 0
%endif

Summary:       Virtualization host metrics daemon
Name:          vhostmd
Version:       0.5
%define base_release .2
Release:       3%{?dist}%{?base_release}
#Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
License:       GPLv2+
Group:         System Environment/Daemons
BuildRoot:     %{_tmppath}/%{name}-%{version}-%{release}-root

URL:           http://gitorious.org/vhostmd

# Upstream tarball hosting is screwed at the moment.  This release is
# of the 0.5 branch, with 'make dist' done by the packager.
Source0:       vhostmd-%{version}.tar.bz2
Source1:       vhostmd.init
Source2:       vhostmd.sysconfig
Source3:       vhostmd.conf

BuildRequires: chrpath
BuildRequires: pkgconfig
BuildRequires: libxml2-devel
BuildRequires: libvirt-devel

%if %{have_xen}
BuildRequires: xen-devel
%endif

Requires(post): chkconfig
Requires(preun): chkconfig
Requires(preun): initscripts
Requires(postun): initscripts
Requires(pre): shadow-utils


%description 
vhostmd provides a "metrics communication channel" between a host and
its hosted virtual machines, allowing limited introspection of host
resource usage from within virtual machines.


%package -n    vm-dump-metrics
Summary:       Virtualization host metrics dump 
Group:         Applications/System


%description -n vm-dump-metrics
Executable to dump all available virtualization host metrics to stdout
or a file.


%package -n    vm-dump-metrics-devel
Summary:       Virtualization host metrics dump development 
Group:         Development/Libraries
Requires:      vm-dump-metrics = %{version}-%{release}
Requires:      pkgconfig


%description -n vm-dump-metrics-devel
Header and libraries necessary for metrics gathering development


%prep
%setup -q


%build
%configure \
%if %{have_xen} == 0
  --without-xenstore \
%endif
  --enable-shared --disable-static
make %{_smp_mflags}


%install
rm -rf $RPM_BUILD_ROOT

make DESTDIR=$RPM_BUILD_ROOT install

mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/init.d
install -m 0755 %{SOURCE1} $RPM_BUILD_ROOT%{_sysconfdir}/init.d/%{name}

mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/sysconfig
install -m 0644 %{SOURCE2} $RPM_BUILD_ROOT%{_sysconfdir}/sysconfig/%{name}

#rm $RPM_BUILD_ROOT%{_libdir}/libmetrics.a
rm $RPM_BUILD_ROOT%{_libdir}/libmetrics.la

chrpath --delete $RPM_BUILD_ROOT%{_sbindir}/vm-dump-metrics

# Remove docdir - we'll make a proper one ourselves.
rm -r $RPM_BUILD_ROOT%{_docdir}/vhostmd

# Remove metric.dtd from /etc.
rm $RPM_BUILD_ROOT%{_sysconfdir}/vhostmd/metric.dtd

# The default configuration file is great for Xen, not so great
# for anyone else.  Replace it with one which is better for libvirt
# users.
mv $RPM_BUILD_ROOT%{_sysconfdir}/vhostmd/vhostmd.conf \
   $RPM_BUILD_ROOT%{_sysconfdir}/vhostmd/vhostmd.conf.for.xen
cp %{SOURCE3} $RPM_BUILD_ROOT%{_sysconfdir}/vhostmd/vhostmd.conf


%clean
rm -rf $RPM_BUILD_ROOT


%post
/sbin/chkconfig --add vhostmd


%preun
if [ $1 = 0 ] ; then
  /sbin/service vhostmd stop >/dev/null 2>&1
  /sbin/chkconfig --del vhostmd
fi


%postun
if [ "$1" -ge "1" ] ; then
  /sbin/service vhostmd condrestart >/dev/null 2>&1 || :
fi


%post -n vm-dump-metrics -p /sbin/ldconfig


%postun -n vm-dump-metrics -p /sbin/ldconfig


%pre
# UID:GID 112:112 reserved, see RHBZ#534109.
getent group vhostmd >/dev/null || groupadd -g 112 -r vhostmd
getent passwd vhostmd >/dev/null || \
useradd -u 112 -r -g vhostmd -d %{_datadir}/vhostmd -s /sbin/nologin \
-c "Virtual Host Metrics Daemon" vhostmd
exit 0


%files
%defattr(-,root,root,-)
%doc AUTHORS ChangeLog COPYING README
%doc mdisk.xml metric.dtd vhostmd.dtd vhostmd.xml

%{_sbindir}/vhostmd

%dir %{_sysconfdir}/vhostmd
%config(noreplace) %{_sysconfdir}/vhostmd/vhostmd.conf
%config(noreplace) %{_sysconfdir}/vhostmd/vhostmd.conf.for.xen
%config %{_sysconfdir}/vhostmd/vhostmd.dtd
%{_sysconfdir}/init.d/%{name}
%config(noreplace) %{_sysconfdir}/sysconfig/%{name}

%dir %{_datadir}/vhostmd
%dir %{_datadir}/vhostmd/scripts
%{_datadir}/vhostmd/scripts/pagerate.pl

%{_mandir}/man8/vhostmd.8.gz


%files -n vm-dump-metrics
%defattr(-,root,root,-)
%doc COPYING
%{_sbindir}/vm-dump-metrics
%{_libdir}/libmetrics.so.0
%{_libdir}/libmetrics.so.0.0.0
%{_mandir}/man1/vm-dump-metrics.1.gz


%files -n vm-dump-metrics-devel
%defattr(-,root,root,-)
%doc README
%{_libdir}/libmetrics.so
%dir %{_includedir}/vhostmd
%{_includedir}/vhostmd/libmetrics.h


%changelog
* Tue Jun 11 2013 baseuser@ibm.com
- Base-8.x spec file
