Name:		bfa-firmware
Summary:	Brocade Fibre Channel HBA Firmware
Version:	3.2.21.1
%define base_release .2
Release:	1%{?dist}%{?base_release}
License:	Redistributable, no modification permitted
Group:		System Environment/Kernel
Source0:	LICENSE
# These files were taken from:
# http://www.brocade.com/sites/dotcom/services-support/drivers-downloads/CNA/Linux.page
# No direct link is available.
Source1:	bfa_firmware_linux-3.0.0.0-0.tgz
Source2:	bfa_firmware_linux-3.0.3.1-0.tgz
Source3:	bfa_fw_update_to_v3.1.2.1.tgz
Source4:	bfa_fw_update_to_v3.2.21.1.tgz
URL:		http://www.brocade.com/sites/dotcom/services-support/drivers-downloads/CNA/Linux.page
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildArch:	noarch
# Needed for /lib/firmware
Requires:	udev

%description
Brocade Fibre Channel HBA Firmware.

%prep
unpack_bfa_firmware() {
	filename=$1
	version=$2
	dir=$3
	installversion=${4:-$version}

	tar xvf $RPM_SOURCE_DIR/$1
	pushd $3
	for i in cbfw ctfw ct2fw; do
		if [ -f $i.bin ]; then
			mv $i.bin $i-$installversion.bin;
		elif [ "$installversion" != "$version" ]; then
			mv $i-$version.bin $i-$installversion.bin
		fi
	done
	popd
}

unpack_bfa_firmware bfa_fw_update_to_v3.2.21.1.tgz 3.2.1.0 bfa_fw_update_to_v3.2.21.1
unpack_bfa_firmware bfa_fw_update_to_v3.1.2.1.tgz 3.1.0.0 bfa_fw_v3.1.2.1
unpack_bfa_firmware bfa_firmware_linux-3.0.3.1-0.tgz 3.0.3.1 .
unpack_bfa_firmware bfa_firmware_linux-3.0.0.0-0.tgz 3.0.0.0 3.0_GA_firwmare_image

cp %{SOURCE0} ./

%build
# Firmware, do nothing.

%install
install_bfa_firmware() {
	ver=$1
	dir=$2

	pushd $dir
	install -m0644 cbfw-$ver.bin ct2fw-$ver.bin ctfw-$ver.bin %{buildroot}/lib/firmware/
	popd
}

link_bfa_firmware() {
	dstver=$2
	srcver=$1

	pushd %{buildroot}/lib/firmware/
		ln -s cbfw$srcver.bin cbfw$dstver.bin
		ln -s ct2fw$srcver.bin ct2fw$dstver.bin
		ln -s ctfw$srcver.bin ctfw$dstver.bin
	popd
}

mkdir -p %{buildroot}/lib/firmware/

install_bfa_firmware 3.2.1.0 bfa_fw_update_to_v3.2.21.1
install_bfa_firmware 3.1.0.0 bfa_fw_v3.1.2.1
install_bfa_firmware 3.0.3.1 .

# RHEL 6.3 uses unversioned filenames
# RHEL 6.4 starting with 3.0.3.1 uses versioned filenames
%if 0%{?rhel}
	install_bfa_firmware 3.0.0.0 3.0_GA_firwmare_image
	link_bfa_firmware "-3.0.0.0"
%else
# Upstream starting with 3.1.0.0 uses versioned filenames
#  so link the old version to the old names as expected
	link_bfa_firmware "-3.0.3.1"
%endif

install -D $RPM_SOURCE_DIR/LICENSE $RPM_BUILD_ROOT/$RPM_DOC_DIR/%{name}-%{version}/LICENSE

%clean
rm -rf %{buildroot}

%files
%defattr(-,root,root,-)
%doc LICENSE
/lib/firmware/cbfw.bin
/lib/firmware/ctfw.bin
/lib/firmware/ct2fw.bin
/lib/firmware/cbfw-3.2.1.0.bin
/lib/firmware/ctfw-3.2.1.0.bin
/lib/firmware/ct2fw-3.2.1.0.bin
/lib/firmware/cbfw-3.1.0.0.bin
/lib/firmware/ctfw-3.1.0.0.bin
/lib/firmware/ct2fw-3.1.0.0.bin
/lib/firmware/cbfw-3.0.3.1.bin
/lib/firmware/ctfw-3.0.3.1.bin
/lib/firmware/ct2fw-3.0.3.1.bin
%if 0%{?rhel}
/lib/firmware/cbfw-3.0.0.0.bin
/lib/firmware/ctfw-3.0.0.0.bin
/lib/firmware/ct2fw-3.0.0.0.bin
%endif

%changelog
* Wed Jun 05 2013 baseuser@ibm.com
- Base-8.x spec file
