Summary: A library for password generation and password quality checking
Name: libpwquality
Version: 1.2.1
%define base_release .4
Release: 2%{?dist}%{?base_release}
# The package is BSD licensed with option to relicense as GPLv2+
# - this option is redundant as the BSD license allows that anyway.
License: BSD or GPLv2+
Group: System Environment/Base
Source0: http://fedorahosted.org/releases/l/i/libpwquality/libpwquality-%{version}.tar.bz2
Source999: fivextra.tar.bz2

%global _moduledir /%{_lib}/security
%global _secconfdir %{_sysconfdir}/security

Requires: cracklib-dicts >= 2.8
Requires: pam%{?_isa}
BuildRequires: cracklib-devel
BuildRequires: gettext
BuildRequires: pam-devel
BuildRequires:  openssh-clients
%{!?cross_build:BuildRequires: python2-devel}

URL: http://libpwquality.fedorahosted.org/

# we don't want to provide private python extension libs
%define __provides_exclude_from ^%{python_sitearch}/.*\.so$.

%description
This is a library for password quality checks and generation
of random passwords that pass the checks.
This library uses the cracklib and cracklib dictionaries
to perform some of the checks.

%package devel
Group: Development/Libraries
Summary: Files needed for developing PAM-aware applications and modules for PAM
Requires: libpwquality%{?_isa} = %{version}-%{release}
Requires: pkgconfig

%description devel
Files needed for development of applications using the libpwquality
library.
See the pwquality.h header file for the API.

%if ! 0%{?cross_build}
%package -n python-pwquality
Group: Development/Libraries
Summary: Python bindings for the libpwquality library
Requires: libpwquality%{?_isa} = %{version}-%{release}

%description -n python-pwquality
This is pwquality Python module that provides Python bindings
for the libpwquality library. These bindings can be used
for easy password quality checking and generation of random
pronounceable passwords from Python applications.
%endif

%package fivextra
Summary: Test for %{name} package
Group:  fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}.

%if ! 0%{?cross_build}
%package -n python-pwquality-fivextra
Summary: Test for python-pwquality package
Group:  fivextra
Prefix: /opt/fiv/ltp
Requires: python-pwquality

%description -n python-pwquality-fivextra
This package contains testcases for kpartx.
%endif

%prep
%setup -q -a 999

%build
%configure \
	--with-securedir=/%{_lib}/security \
	%{!?cross_build:--with-pythonsitedir=%{python_sitearch}} \
	%{?cross_build:--disable-python-bindings} \
	--disable-static

make %{?_smp_mflags}

%install
make install DESTDIR=$RPM_BUILD_ROOT INSTALL='install -p'
#pushd /builddir/build/BUILD/libpwquality-1.2.1
for dir in `cd fivextra/%{name}; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install `find fivextra/%{name}/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

#Steps to package the python-pwquality tests for FIV
for dir in `cd fivextra/python-pwquality; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/python-pwquality/$dir
  install -m 755 `find fivextra/python-pwquality/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/python-pwquality/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd
pushd $RPM_BUILD_ROOT/%{fivdir}/python-pwquality
make install
popd 

#popd

pushd $RPM_BUILD_ROOT%{_libdir}
mv libpwquality.so.* $RPM_BUILD_ROOT/%{_lib}/
ln -sf ../../%{_lib}/libpwquality.so.*.* libpwquality.so
popd
rm -f $RPM_BUILD_ROOT%{_libdir}/*.la
rm -f $RPM_BUILD_ROOT%{_moduledir}/*.la


%find_lang libpwquality

%check
# Nothing yet

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files -f libpwquality.lang
%defattr(-,root,root,-)
%doc COPYING README NEWS AUTHORS
%{_bindir}/pwmake
%{_bindir}/pwscore
%{_moduledir}/pam_pwquality.so
/%{_lib}/libpwquality.so.*
%config(noreplace) %{_secconfdir}/pwquality.conf
%{_mandir}/man1/*
%{_mandir}/man5/*
%{_mandir}/man8/*

%files devel
%defattr(-,root,root,-)
%{_includedir}/pwquality.h
%{_libdir}/libpwquality.so
%{_libdir}/pkgconfig/*.pc

%if ! 0%{?cross_build}
%files -n python-pwquality
%defattr(-,root,root,-)
%{python_sitearch}/pwquality.so
%endif

%files fivextra
%{prefix}/testcases/bin/libpwquality.sh
%{fivdir}/%{name}

%if ! 0%{?cross_build}
%files -n python-pwquality-fivextra
%{prefix}/testcases/bin/python-pwquality.sh
%{fivdir}/python-pwquality
%endif

%changelog
* Wed May 08 2013 baseuser@ibm.com
- Base-8.x spec file
