#define  prever     rc3
#define  prever_dot .rc3
#define  postver    a

Summary:  The Advanced Linux Sound Architecture (ALSA) library
Name:     alsa-lib
Version:  1.0.27.2
%define base_release .1
Release:  1%{?prever_dot}%{?dist}%{?base_release}
License:  LGPLv2+
Group:    System Environment/Libraries
URL:      http://www.alsa-project.org/

Source:   ftp://ftp.alsa-project.org/pub/lib/%{name}-%{version}%{?prever}%{?postver}.tar.bz2
Source10: asound.conf
Source11: modprobe-dist-alsa.conf
Source12: modprobe-dist-oss.conf
Source999: fivextra.tar.bz2
Patch0:   alsa-lib-1.0.24-config.patch
Patch2:   alsa-lib-1.0.14-glibc-open.patch
Patch4:   alsa-lib-1.0.16-no-dox-date.patch

BuildRequires:  doxygen
Requires(post): /sbin/ldconfig, coreutils

%description
The Advanced Linux Sound Architecture (ALSA) provides audio and MIDI
functionality to the Linux operating system.

This package includes the ALSA runtime libraries to simplify application
programming and provide higher level functionality as well as support for
the older OSS API, providing binary compatibility for most OSS programs.

%package  devel
Summary:  Development files from the ALSA library
Group:    Development/Libraries
Requires: %{name} = %{version}-%{release}
Requires: pkgconfig

%description devel
The Advanced Linux Sound Architecture (ALSA) provides audio and MIDI
functionality to the Linux operating system.

This package includes the ALSA development libraries for developing
against the ALSA libraries and interfaces.

%package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains the testcases built from the package for %{name}

%prep
%setup -q -n %{name}-%{version}%{?prever}%{?postver} -a 999
%patch0 -p1 -b .config
%patch2 -p1 -b .glibc-open
%patch4 -p1 -b .no-dox-date

%build
%configure --disable-aload --with-plugindir=%{_libdir}/alsa-lib --disable-alisp

# Remove useless /usr/lib64 rpath on 64bit archs
sed -i 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' libtool
sed -i 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' libtool

make %{?_smp_mflags} V=1
make doc

pushd test/lsb
make CFLAGS="$CFLAGS -I.." config midi_event
popd

%install
make DESTDIR=%{buildroot} install

# We need the library to be available even before /usr might be mounted
mkdir -p %{buildroot}/%{_lib}
mv %{buildroot}%{_libdir}/libasound.so.* %{buildroot}/%{_lib}
ln -snf ../../%{_lib}/libasound.so.2 %{buildroot}%{_libdir}/libasound.so

# Install global configuration files
mkdir -p -m 755 %{buildroot}/etc
install -p -m 644 %{SOURCE10} %{buildroot}/etc

# Install the modprobe files for ALSA
mkdir -p -m 755 %{buildroot}/lib/modprobe.d/
install -p -m 644 %{SOURCE11} %{buildroot}/lib/modprobe.d/dist-alsa.conf
# bug#926973, place this file to the doc directory
mkdir -p -m 755 %{buildroot}%{_defaultdocdir}/%{name}-%{version}/
install -p -m 644 %{SOURCE12} %{buildroot}%{_defaultdocdir}/%{name}-%{version}/modprobe-dist-oss.conf

# Create UCM directory
mkdir -p %{buildroot}/%{_datadir}/alsa/ucm
# Remove all UCM files (should be selected by architecture)
rm -rf %{buildroot}/%{_datadir}/alsa/ucm/*

#Remove libtool archives.
find %{buildroot} -name '*.la' -exec rm -f {} ';'

# Steps to package the alsa-lib tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/tests

pushd test/lsb/.libs
install config midi_event $RPM_BUILD_ROOT/%{fivdir}/%{name}/tests
popd

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-,root,root,-)
%doc COPYING TODO doc/asoundrc.txt
# file is as old as 0.2.0 / Red Hat bugzilla #510212
#doc Changelog
%config %{_sysconfdir}/asound.conf
/%{_lib}/libasound.so.*
%{_bindir}/aserver
%{_libdir}/alsa-lib/
%{_datadir}/alsa/
/lib/modprobe.d/dist-*

%files devel
%defattr(-,root,root,-)
%doc doc/doxygen/
%{_includedir}/alsa/
%{_includedir}/sys/asoundlib.h
%{_libdir}/libasound.so
%{_libdir}/pkgconfig/alsa.pc
%{_datadir}/aclocal/alsa.m4

%files fivextra
%{prefix}

%changelog
* Fri Jan 24 2014 baseuser@ibm.com
- Base-f19.x spec file
